/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1BitString;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.DHParameterGenerator;
import com.phaos.crypto.MessageDigest;
import com.phaos.fips.FIPS_140_2;
import com.phaos.math.BigInt;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;

public class DHParams
implements ASN1Object,
Externalizable {
    private BigInt p;
    private BigInt g;
    private BigInt q;
    private BigInt j;
    private byte[] seed;
    private int pgenCounter;
    private ASN1Sequence contents;
    private static final BigInt one = BigInt.valueOf(1L);
    private static final BigInt two = BigInt.valueOf(2L);

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    DHParams(BigInt bigInt, BigInt bigInt2, BigInt bigInt3) {
        FIPS_140_2.assertReadyState();
        this.p = bigInt;
        this.g = bigInt2;
        this.q = bigInt3;
    }

    DHParams(BigInt bigInt, BigInt bigInt2, BigInt bigInt3, BigInt bigInt4) {
        this(bigInt, bigInt2, bigInt3);
        this.j = bigInt4;
    }

    DHParams(BigInt bigInt, BigInt bigInt2, BigInt bigInt3, BigInt bigInt4, byte[] byArray, int n) {
        this(bigInt, bigInt2, bigInt3, byArray, n);
        this.j = bigInt4;
    }

    DHParams(BigInt bigInt, BigInt bigInt2, BigInt bigInt3, byte[] byArray, int n) {
        this(bigInt, bigInt2, bigInt3);
        this.seed = byArray;
        this.pgenCounter = n;
    }

    public DHParams(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public DHParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this(BigInt.getInstance(bigInteger), BigInt.getInstance(bigInteger2), BigInt.getInstance(bigInteger3));
    }

    public DHParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        this(BigInt.getInstance(bigInteger), BigInt.getInstance(bigInteger2), BigInt.getInstance(bigInteger3), BigInt.getInstance(bigInteger4));
    }

    public DHParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, byte[] byArray, int n) {
        this(BigInt.getInstance(bigInteger), BigInt.getInstance(bigInteger2), BigInt.getInstance(bigInteger3), BigInt.getInstance(bigInteger4), byArray, n);
    }

    public DHParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, byte[] byArray, int n) {
        this(BigInt.getInstance(bigInteger), BigInt.getInstance(bigInteger2), BigInt.getInstance(bigInteger3), byArray, n);
    }

    public BigInteger getG() {
        return new BigInteger(this.getGInternal().toByteArray());
    }

    BigInt getGInternal() {
        FIPS_140_2.assertReadyState();
        return this.g;
    }

    public BigInteger getJ() {
        return new BigInteger(this.getJInternal().toByteArray());
    }

    BigInt getJInternal() {
        FIPS_140_2.assertReadyState();
        return this.j;
    }

    public BigInteger getP() {
        return new BigInteger(this.getPInternal().toByteArray());
    }

    public int getPGenCounter() {
        FIPS_140_2.assertReadyState();
        return this.pgenCounter;
    }

    BigInt getPInternal() {
        FIPS_140_2.assertReadyState();
        return this.p;
    }

    public BigInteger getQ() {
        return new BigInteger(this.getQInternal().toByteArray());
    }

    BigInt getQInternal() {
        FIPS_140_2.assertReadyState();
        return this.q;
    }

    public byte[] getSeed() {
        FIPS_140_2.assertReadyState();
        return (byte[])this.seed.clone();
    }

    public void input(InputStream inputStream) throws IOException {
        FIPS_140_2.assertReadyState();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.p = ASN1Integer.inputBigIntValue(aSN1SequenceInputStream);
        this.g = ASN1Integer.inputBigIntValue(aSN1SequenceInputStream);
        this.q = ASN1Integer.inputBigIntValue(aSN1SequenceInputStream);
        this.j = aSN1SequenceInputStream.hasMoreData() && aSN1SequenceInputStream.getCurrentTag() == 2 ? ASN1Integer.inputBigIntValue(aSN1SequenceInputStream) : null;
        if (aSN1SequenceInputStream.hasMoreData()) {
            ASN1SequenceInputStream aSN1SequenceInputStream2 = new ASN1SequenceInputStream(aSN1SequenceInputStream);
            this.seed = ASN1BitString.inputValue(aSN1SequenceInputStream2);
            this.pgenCounter = new ASN1Integer(aSN1SequenceInputStream2).intValue();
            aSN1SequenceInputStream2.terminate();
        } else {
            this.seed = null;
            this.pgenCounter = 0;
        }
        aSN1SequenceInputStream.terminate();
    }

    public static boolean isValidParams(DHParams dHParams, int n, int n2) {
        if (n % 256 != 0 || n < 1024 || n2 < 160) {
            throw new IllegalArgumentException("Invalid parameters bit length: L=" + n + ", m=" + n2);
        }
        byte[] byArray = dHParams.getSeed();
        int n3 = dHParams.getPGenCounter();
        if (byArray == null) {
            throw new IllegalArgumentException("Missing validation parameters");
        }
        int n4 = (n + 1023) / 1024;
        if (n3 >= 4096 * n4 || n3 <= 0) {
            return false;
        }
        BigInt bigInt = dHParams.getPInternal();
        BigInt bigInt2 = dHParams.getQInternal();
        BigInt bigInt3 = dHParams.getJInternal();
        if (bigInt3 != null && (bigInt3.compareTo(two) < 0 || bigInt.compareTo(bigInt3.multiply(bigInt2).add(one)) != 0)) {
            return false;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(AlgID.sha_1);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new RuntimeException(algorithmIdentifierException.toString());
        }
        BigInt bigInt4 = DHParameterGenerator.generateQ(byArray, n2, messageDigest);
        if (!bigInt4.isProbablePrime(100) || bigInt4.compareTo(bigInt2) != 0) {
            return false;
        }
        BigInt bigInt5 = null;
        int n5 = 0;
        while (!((bigInt5 = DHParameterGenerator.generateP(bigInt4, byArray, n5, n, n2, messageDigest)).compareTo(one.shiftLeft(n - 1)) > 0 && bigInt5.isProbablePrime(100) || ++n5 > n3)) {
        }
        if (n5 != n3 || bigInt5.compareTo(bigInt) != 0) {
            return false;
        }
        BigInt bigInt6 = dHParams.getGInternal();
        return bigInt6.compareTo(two) >= 0 && bigInt6.compareTo(bigInt5.subtract(two)) <= 0 && bigInt6.modPow(bigInt4, bigInt5).compareTo(one) == 0;
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.toASN1Sequence().output(outputStream);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        FIPS_140_2.assertReadyState();
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    private ASN1Sequence toASN1Sequence() {
        FIPS_140_2.assertReadyState();
        if (this.contents == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(new ASN1Integer(this.p));
            aSN1Sequence.addElement(new ASN1Integer(this.g));
            aSN1Sequence.addElement(new ASN1Integer(this.q));
            if (this.j != null) {
                aSN1Sequence.addElement(new ASN1Integer(this.j));
            }
            if (this.seed != null) {
                ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
                aSN1Sequence2.addElement(new ASN1BitString(this.seed));
                aSN1Sequence2.addElement(new ASN1Integer(this.pgenCounter));
                aSN1Sequence.addElement(aSN1Sequence2);
            }
            this.contents = aSN1Sequence;
        }
        return this.contents;
    }

    public String toString() {
        FIPS_140_2.assertReadyState();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{p = ");
        stringBuffer.append(this.p);
        stringBuffer.append(", g = ");
        stringBuffer.append(this.g);
        stringBuffer.append(", q = ");
        stringBuffer.append(this.q);
        if (this.j != null) {
            stringBuffer.append(", j = ");
            stringBuffer.append(this.j);
        }
        if (this.seed != null) {
            stringBuffer.append(",\nseed = ");
            stringBuffer.append(Utils.toHexString(this.seed));
            stringBuffer.append(", pgenCounter = ");
            stringBuffer.append(String.valueOf(this.pgenCounter) + " }");
        }
        return stringBuffer.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }
}

