/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.DHKey;
import com.phaos.crypto.DHParams;
import com.phaos.crypto.PrivateKey;
import com.phaos.fips.FIPS_140_2;
import com.phaos.fips.KeyExportException;
import com.phaos.math.BigInt;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.Utils;
import com.phaos.utils.VersionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class DHPrivateKey
extends DHKey
implements PrivateKey {
    private static final ASN1ObjectID algOID = AlgID.dh.getOID();
    private BigInt x;
    private boolean allowExport = true;
    private byte[] pkiBytes;
    private ASN1Integer keyContents;

    public DHPrivateKey() {
    }

    DHPrivateKey(BigInt bigInt, DHParams dHParams) {
        super(dHParams);
        this.x = bigInt;
    }

    public DHPrivateKey(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public DHPrivateKey(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public DHPrivateKey(BigInteger bigInteger, DHParams dHParams) {
        this(BigInt.getInstance(bigInteger), dHParams);
    }

    private void assertAllowExport() {
        if (!this.getAllowExport() || !FIPS_140_2.getAllowKeyExport()) {
            throw new KeyExportException("Plaintext key export not allowed");
        }
    }

    public Object clone() {
        FIPS_140_2.assertReadyState();
        DHPrivateKey dHPrivateKey = new DHPrivateKey();
        try {
            if (this.params != null) {
                dHPrivateKey.params = new DHParams(Utils.toStream(this.params));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing DH key parameters to stream");
        }
        if (this.x != null) {
            dHPrivateKey.x = BigInt.getInstance(this.x);
        }
        dHPrivateKey.allowExport = this.allowExport;
        return dHPrivateKey;
    }

    public void erase() {
        this.params = null;
        if (this.x != null) {
            this.x.erase();
            this.x = null;
        }
        this.eraseCache();
    }

    private void eraseCache() {
        if (this.pkiBytes != null) {
            Utils.setArray(this.pkiBytes, (byte)0);
            this.pkiBytes = null;
        }
        if (this.keyContents != null) {
            this.keyContents.erase();
            this.keyContents = null;
        }
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        return new AlgorithmIdentifier(algOID, this.params);
    }

    public boolean getAllowExport() {
        return this.allowExport;
    }

    public ASN1Object getContents() {
        this.assertAllowExport();
        FIPS_140_2.assertReadyState();
        return new ASN1Integer(this.x);
    }

    ASN1Object getContentsInternal() {
        FIPS_140_2.assertReadyState();
        if (this.keyContents == null) {
            this.keyContents = new ASN1Integer(this.x);
        }
        return this.keyContents;
    }

    public byte[] getEncoded() {
        this.assertAllowExport();
        return (byte[])this.getEncodedInternal().clone();
    }

    byte[] getEncodedInternal() {
        FIPS_140_2.assertReadyState();
        if (this.pkiBytes == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(new ASN1Integer(0L));
            aSN1Sequence.addElement(this.getAlgID());
            aSN1Sequence.addElement(new ASN1OctetString(Utils.toBytes(this.getContentsInternal())));
            this.pkiBytes = Utils.toBytes(aSN1Sequence);
        }
        return this.pkiBytes;
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public BigInteger getX() {
        this.assertAllowExport();
        return new BigInteger(this.getXInternal().toByteArray());
    }

    BigInt getXInternal() {
        FIPS_140_2.assertReadyState();
        return this.x;
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws AlgorithmIdentifierException, InvalidInputException {
        FIPS_140_2.assertReadyState();
        this.erase();
        if (!algOID.equals(algorithmIdentifier.getOID())) {
            throw new AlgorithmIdentifierException("Wrong algorithm identifier for Diffier-Hellman key");
        }
        try {
            ASN1Object aSN1Object2 = algorithmIdentifier.getParameters();
            if (aSN1Object2 != null) {
                this.params = aSN1Object2 instanceof DHParams ? (DHParams)aSN1Object2 : new DHParams(Utils.toStream((ASN1Sequence)aSN1Object2));
            }
        }
        catch (IOException iOException) {
            throw new AlgorithmIdentifierException("Invalid DH parameters");
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Invalid DH parameters");
        }
        try {
            this.x = ((ASN1Integer)aSN1Object).getBigIntValue();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException("Contents invalid");
        }
    }

    public void input(InputStream inputStream) throws IOException {
        try {
            ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
            ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.elementAt(0);
            if (!aSN1Integer.equals(0)) {
                throw new VersionException(aSN1Integer.getValue(), 0);
            }
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.elementAt(1));
            ASN1Object aSN1Object = ASN1Utils.inputASN1Object(((ASN1OctetString)aSN1Sequence.elementAt(2)).getValue());
            this.initialize(algorithmIdentifier, aSN1Object);
            ((ASN1Integer)aSN1Object).erase();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new InvalidInputException(algorithmIdentifierException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException.toString());
        }
    }

    public int length() {
        return this.getEncodedInternal().length;
    }

    public void output(OutputStream outputStream) throws IOException {
        outputStream.write(this.getEncoded());
    }

    public void setAllowExport(boolean bl) {
        this.allowExport = bl;
    }

    public void setParams(DHParams dHParams) {
        FIPS_140_2.assertReadyState();
        if (dHParams.getP() == null || dHParams.getQ() == null || dHParams.getG() == null) {
            throw new IllegalArgumentException("Missing P, Q or G in DH key parameters");
        }
        this.params = dHParams;
        this.eraseCache();
    }

    public String toString() {
        FIPS_140_2.assertReadyState();
        return "params = {" + this.params + "}, bitLength = " + this.getBitLength() + "}";
    }
}

