/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1BitString;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.DHKey;
import com.phaos.crypto.DHParams;
import com.phaos.crypto.PublicKey;
import com.phaos.fips.FIPS_140_2;
import com.phaos.math.BigInt;
import com.phaos.utils.CryptoUtils;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class DHPublicKey
extends DHKey
implements PublicKey {
    private static final ASN1ObjectID algOID = AlgID.dh.getOID();
    private BigInt y;
    private byte[] spkiBytes;

    public DHPublicKey() {
    }

    DHPublicKey(BigInt bigInt, DHParams dHParams) {
        super(dHParams);
        this.y = bigInt;
    }

    public DHPublicKey(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public DHPublicKey(BigInteger bigInteger, DHParams dHParams) {
        this(BigInt.getInstance(bigInteger), dHParams);
    }

    public Object clone() {
        FIPS_140_2.assertReadyState();
        DHPublicKey dHPublicKey = new DHPublicKey();
        try {
            if (this.params != null) {
                dHPublicKey.params = new DHParams(Utils.toStream(this.params));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing key DH parameters to stream");
        }
        if (this.y != null) {
            dHPublicKey.y = BigInt.getInstance(this.y);
        }
        return dHPublicKey;
    }

    public void erase() {
        this.params = null;
        this.y = null;
        this.spkiBytes = null;
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        return new AlgorithmIdentifier(algOID, this.params);
    }

    public boolean getAllowExport() {
        return true;
    }

    public ASN1Object getContents() {
        FIPS_140_2.assertReadyState();
        return new ASN1Integer(this.y);
    }

    public byte[] getEncoded() {
        FIPS_140_2.assertReadyState();
        if (this.spkiBytes == null) {
            ASN1Sequence aSN1Sequence = CryptoUtils.subjectPublicKeyInfo(this);
            this.spkiBytes = Utils.toBytes(aSN1Sequence);
        }
        return this.spkiBytes;
    }

    public String getFormat() {
        return "X.509";
    }

    public BigInteger getY() {
        return new BigInteger(this.getYInternal().toByteArray());
    }

    BigInt getYInternal() {
        FIPS_140_2.assertReadyState();
        return this.y;
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws AlgorithmIdentifierException, InvalidInputException {
        FIPS_140_2.assertReadyState();
        if (!algOID.equals(algorithmIdentifier.getOID())) {
            throw new AlgorithmIdentifierException("Wrong algorithm identifier for Diffier-Hellman key.");
        }
        try {
            ASN1Object aSN1Object2 = algorithmIdentifier.getParameters();
            if (aSN1Object2 != null) {
                this.params = aSN1Object2 instanceof DHParams ? (DHParams)aSN1Object2 : new DHParams(Utils.toStream((ASN1Sequence)aSN1Object2));
            }
        }
        catch (IOException iOException) {
            throw new AlgorithmIdentifierException("Invalid DH parameters.");
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Invalid DH parameters.");
        }
        try {
            this.y = ((ASN1Integer)aSN1Object).getBigIntValue();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException("Contents invalid.");
        }
        this.spkiBytes = null;
    }

    public void input(InputStream inputStream) throws IOException {
        FIPS_140_2.assertReadyState();
        ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.elementAt(0));
            ASN1Object aSN1Object = ASN1Utils.inputASN1Object(((ASN1BitString)aSN1Sequence.elementAt(1)).getValue());
            this.initialize(algorithmIdentifier, aSN1Object);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new InvalidInputException(algorithmIdentifierException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException.toString());
        }
    }

    public int length() {
        return this.getEncoded().length;
    }

    public void output(OutputStream outputStream) throws IOException {
        outputStream.write(this.getEncoded());
    }

    public void setParams(DHParams dHParams) {
        FIPS_140_2.assertReadyState();
        if (dHParams.getP() == null || dHParams.getQ() == null || dHParams.getG() == null) {
            throw new IllegalArgumentException("Missing P or Q or G in the params");
        }
        this.params = dHParams;
        this.spkiBytes = null;
    }

    public String toString() {
        FIPS_140_2.assertReadyState();
        return "{params = " + this.params + ", y = " + this.y + "}";
    }
}

