/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.AuthenticationException;
import com.phaos.crypto.DSAParams;
import com.phaos.crypto.DSAPrivateKey;
import com.phaos.crypto.DSAPublicKey;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PublicKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.Signature;
import com.phaos.crypto.SignatureException;
import com.phaos.fips.FIPS_140_2;
import com.phaos.math.BigInt;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;

public final class DSA
extends Signature {
    public static final ASN1ObjectID dsaKeyOID = AlgID.dsa.getOID();
    public static final ASN1ObjectID dsaKeyOldOID = AlgID.dsaOld.getOID();
    public static final ASN1ObjectID dsaSigOID = AlgID.dsaWithSHA1.getOID();
    public static final ASN1ObjectID dsaSigOldOID = AlgID.dsaWithSHA.getOID();
    public static final ASN1ObjectID dsaSigOldOID2 = AlgID.dsaWithSHA1Old.getOID();
    private ASN1ObjectID algOID = dsaSigOID;
    private DSAPublicKey publicKey;
    private DSAPrivateKey privateKey;
    private RandomBitsSource rbs;
    private MessageDigest sha;
    private byte[] hash;

    public DSA() {
    }

    public DSA(DSAPrivateKey dSAPrivateKey, RandomBitsSource randomBitsSource, byte[] byArray) throws SignatureException {
        this(null, dSAPrivateKey, randomBitsSource, byArray);
    }

    public DSA(DSAPrivateKey dSAPrivateKey, byte[] byArray) throws SignatureException {
        this(dSAPrivateKey, RandomBitsSource.getDefault(), byArray);
    }

    public DSA(DSAPublicKey dSAPublicKey) {
        this();
        FIPS_140_2.assertReadyState();
        this.publicKey = dSAPublicKey;
    }

    public DSA(DSAPublicKey dSAPublicKey, DSAPrivateKey dSAPrivateKey) {
        this(dSAPublicKey, dSAPrivateKey, RandomBitsSource.getDefault());
    }

    public DSA(DSAPublicKey dSAPublicKey, DSAPrivateKey dSAPrivateKey, RandomBitsSource randomBitsSource) {
        this();
        FIPS_140_2.assertReadyState();
        this.publicKey = dSAPublicKey;
        this.privateKey = dSAPrivateKey;
        this.rbs = randomBitsSource;
    }

    public DSA(DSAPublicKey dSAPublicKey, DSAPrivateKey dSAPrivateKey, RandomBitsSource randomBitsSource, byte[] byArray) throws SignatureException {
        this(dSAPublicKey, dSAPrivateKey, randomBitsSource);
        this.setDocument(byArray);
        this.sign();
    }

    public DSA(DSAPublicKey dSAPublicKey, DSAPrivateKey dSAPrivateKey, byte[] byArray) throws SignatureException {
        this(dSAPublicKey, dSAPrivateKey, RandomBitsSource.getDefault(), byArray);
    }

    public DSA(DSAPublicKey dSAPublicKey, byte[] byArray, byte[] byArray2) {
        this(dSAPublicKey);
        this.setSigBytes(byArray);
        this.setDocument(byArray2);
    }

    public String algName() {
        return "DSA";
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        return new AlgorithmIdentifier(this.algOID, false);
    }

    public AlgorithmIdentifier getDigestEncryptionAlgID() {
        return AlgID.dsaWithSHA1;
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        FIPS_140_2.assertReadyState();
        this.algOID = algorithmIdentifier.getOID();
    }

    public void setHash(byte[] byArray) {
        FIPS_140_2.assertReadyState();
        this.hash = byArray;
        this.document = null;
    }

    public void setPrivateKey(PrivateKey privateKey) throws InvalidKeyException {
        FIPS_140_2.assertReadyState();
        if (!(privateKey instanceof DSAPrivateKey)) {
            throw new InvalidKeyException();
        }
        this.privateKey = (DSAPrivateKey)privateKey;
    }

    public void setPublicKey(PublicKey publicKey) throws InvalidKeyException {
        FIPS_140_2.assertReadyState();
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException();
        }
        this.publicKey = (DSAPublicKey)publicKey;
    }

    public void setRandomBitsSource(RandomBitsSource randomBitsSource) {
        FIPS_140_2.assertReadyState();
        this.rbs = randomBitsSource;
    }

    public byte[] sign() throws SignatureException {
        BigInt bigInt;
        byte[] byArray;
        FIPS_140_2.assertReadyState();
        if (this.rbs == null) {
            this.rbs = RandomBitsSource.getDefault();
        }
        BigInt bigInt2 = this.privateKey.getXInternal();
        DSAParams dSAParams = this.privateKey.getParams();
        BigInt bigInt3 = dSAParams.getPInternal();
        BigInt bigInt4 = dSAParams.getQInternal();
        BigInt bigInt5 = dSAParams.getGInternal();
        if (this.hash != null) {
            byArray = this.hash;
        } else {
            if (this.sha == null) {
                try {
                    this.sha = MessageDigest.getInstance(AlgID.sha_1);
                }
                catch (AlgorithmIdentifierException algorithmIdentifierException) {
                    throw new RuntimeException("SHA1 class not found. " + algorithmIdentifierException.toString());
                }
            }
            if (this.getDocument() != null) {
                this.sha.init();
                this.sha.update(this.getDocument());
            }
            this.sha.computeCurrent();
            byArray = this.sha.getDigestBitsInternal();
        }
        BigInt bigInt6 = new BigInt(1, byArray);
        int n = bigInt4.bitLength();
        while ((bigInt = this.rbs.randomBigInt(n)).compareTo(BigInt.ONE) <= 0 || bigInt.compareTo(bigInt4) >= 0) {
        }
        BigInt bigInt7 = bigInt.modInverse(bigInt4);
        BigInt bigInt8 = bigInt5.modPow(bigInt, bigInt3).mod(bigInt4);
        BigInt bigInt9 = bigInt6.add(bigInt2.multiply(bigInt8)).mod(bigInt4).multiply(bigInt7).mod(bigInt4);
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1Integer(bigInt8));
        aSN1Sequence.addElement(new ASN1Integer(bigInt9));
        this.setSigBytes(Utils.toBytes(aSN1Sequence));
        return this.getSigBytes();
    }

    public boolean verify() throws AuthenticationException {
        FIPS_140_2.assertReadyState();
        try {
            byte[] byArray;
            BigInt bigInt;
            BigInt bigInt2;
            BigInt bigInt3 = this.publicKey.getYInternal();
            DSAParams dSAParams = this.publicKey.getParams();
            BigInt bigInt4 = dSAParams.getPInternal();
            BigInt bigInt5 = dSAParams.getQInternal();
            BigInt bigInt6 = dSAParams.getGInternal();
            ASN1Sequence aSN1Sequence = new ASN1Sequence(new UnsyncByteArrayInputStream(this.getSigBytes()));
            if (aSN1Sequence.size() != 2) {
                throw new AuthenticationException("Invalid signature format");
            }
            try {
                bigInt2 = ((ASN1Integer)aSN1Sequence.elementAt(0)).getBigIntValue();
                bigInt = ((ASN1Integer)aSN1Sequence.elementAt(1)).getBigIntValue();
            }
            catch (ClassCastException classCastException) {
                throw new AuthenticationException("Invalid signature format");
            }
            if (bigInt2.signum() < 0 || bigInt2.compareTo(bigInt5) > 0 || bigInt.signum() < 0 || bigInt.compareTo(bigInt5) > 0) {
                throw new AuthenticationException("Invalid signature format");
            }
            if (this.hash != null) {
                byArray = this.hash;
            } else {
                if (this.sha == null) {
                    try {
                        this.sha = MessageDigest.getInstance(AlgID.sha_1);
                    }
                    catch (AlgorithmIdentifierException algorithmIdentifierException) {
                        throw new RuntimeException("SHA1 class not found. " + algorithmIdentifierException.toString());
                    }
                }
                if (this.getDocument() != null) {
                    this.sha.init();
                    this.sha.update(this.getDocument());
                }
                this.sha.computeCurrent();
                byArray = this.sha.getDigestBits();
            }
            BigInt bigInt7 = new BigInt(1, byArray);
            BigInt bigInt8 = bigInt.modInverse(bigInt5);
            BigInt bigInt9 = bigInt8.multiply(bigInt7).mod(bigInt5);
            BigInt bigInt10 = bigInt8.multiply(bigInt2).mod(bigInt5);
            BigInt bigInt11 = bigInt6.modPow(bigInt9, bigInt4).multiply(bigInt3.modPow(bigInt10, bigInt4)).mod(bigInt4);
            return bigInt11.mod(bigInt5).equals(bigInt2);
        }
        catch (IOException iOException) {
            throw new AuthenticationException(iOException.toString());
        }
    }
}

