/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Object;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.DSAParams;
import com.phaos.crypto.DSAPrivateKey;
import com.phaos.crypto.DSAPublicKey;
import com.phaos.crypto.KeyPair;
import com.phaos.crypto.KeyPairGenerator;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.fips.FIPS_140_2;
import com.phaos.math.BigInt;
import com.phaos.math.Prime;
import com.phaos.utils.Utils;

public class DSAKeyPairGenerator
extends KeyPairGenerator {
    private DSAParams params;
    private AlgorithmIdentifier keyAlgID = AlgID.dsa;
    private boolean initialized;
    protected static final DSAParams params512 = new DSAParams(new BigInt("12492156315694258518438122119006323799237110162140490763848993256055871214032560900677394116414321425392480831123940478668629071213037930849067708987561797"), new BigInt("801990017674004996592495372795475144432167785027"), new BigInt("2416161294771127319901315666703790942713833681450164303616597296690475377189730893345413708325615307310225313979735602963720957950755258782529372026391641"), Utils.fromHexString("aeef7fdc2ec34351c33f81bb85365f0f5fab95ff"), 34, BigInt.valueOf(2L));
    protected static final DSAParams params768 = new DSAParams(new BigInt("847198100946155561710307399779508173184457128156664161164146219421882327915073475669013220667420258484908654810304407590381994918086595198517076267445552648272351841808065130519547223061029101550004978958642084687668586641485517199"), new BigInt("822710224377225222128937326700907925490005902807"), new BigInt("774809834959489591459661268156343047964339133423157824672710776212233910908008334483365011387676918733816159938484546866731411707418746020651507449962477749235816006996558751009410902691182747947857176879528177046533903302222963959"), Utils.fromHexString("ffeb77a7ffcf7fd721e755baae2f8b3ecdb71336"), 130, BigInt.valueOf(2L));
    protected static final DSAParams params1024 = new DSAParams(new BigInt("161756768501353294066626183132608614763109713347781303307809494201788145786086766632565723776515877527063255282137713643496150680763718237323344135572062802611728216674705098439563128548289535101877916048620151565468004419332049256669008213336599980552248203559391936808645815662034554991029528611306511263023"), new BigInt("1079797971804353485335126622997120532804240961111"), new BigInt("6530309311322880764774476607659473863630893214684539533075034340133395178524950590072708632400423957022360602591219745803762207151326446958725779643269855471917579006976398481954391601082152120248406291574749383155233113276975161340818874285909301731513558916061705580890998449766759627672339082497014715890"), Utils.fromHexString("b5460f2173273a4280d748ae3b5794acfddbc631"), 130, BigInt.valueOf(2L));
    static /* synthetic */ Class class$com$phaos$ASN1$ASN1Null;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public KeyPair generateKeyPair() {
        BigInt bigInt;
        if (!this.initialized) {
            throw new IllegalStateException("The generator is not initialized.");
        }
        FIPS_140_2.assertReadyState();
        BigInt bigInt2 = this.params.getPInternal();
        BigInt bigInt3 = this.params.getQInternal();
        BigInt bigInt4 = this.params.getGInternal();
        if (this.rbs == null) {
            this.rbs = RandomBitsSource.getDefault();
        }
        int n = bigInt3.bitLength();
        while ((bigInt = this.rbs.randomBigInt(n)).compareTo(BigInt.ONE) <= 0 || bigInt.compareTo(bigInt3) >= 0) {
        }
        BigInt bigInt5 = bigInt4.modPow(bigInt, bigInt2);
        DSAPublicKey dSAPublicKey = new DSAPublicKey(bigInt5, this.params);
        dSAPublicKey.setKeyAlgOID(this.keyAlgID.getOID());
        DSAPrivateKey dSAPrivateKey = new DSAPrivateKey(bigInt, this.params);
        dSAPrivateKey.setKeyAlgOID(this.keyAlgID.getOID());
        FIPS_140_2.testKeyPair(dSAPublicKey, dSAPrivateKey);
        return new KeyPair(dSAPublicKey, dSAPrivateKey);
    }

    static BigInt generateP(int n, BigInt bigInt, byte[] byArray, MessageDigest messageDigest) {
        int n2 = (n - 1) / 160;
        BigInt bigInt2 = BigInt.ONE.shiftLeft(n - 1);
        BigInt bigInt3 = bigInt2.subtract(BigInt.ONE);
        byte[] byArray2 = new byte[(n2 + 1) * 20];
        int n3 = byArray2.length - 20;
        while (n3 >= 0) {
            int n4 = byArray.length - 1;
            while (n4 >= 0) {
                byArray[n4] = (byte)((byArray[n4] & 0xFF) + 1);
                if (byArray[n4] != 0) break;
                --n4;
            }
            messageDigest.init();
            messageDigest.update(byArray);
            messageDigest.computeCurrent();
            System.arraycopy(messageDigest.getDigestBitsInternal(), 0, byArray2, n3, 20);
            n3 -= 20;
        }
        BigInt bigInt4 = new BigInt(1, byArray2).and(bigInt3).add(bigInt2);
        return bigInt4.subtract(bigInt4.mod(bigInt.shiftLeft(1))).add(BigInt.ONE);
    }

    public static DSAParams generateParameters(int n, RandomBitsSource randomBitsSource) {
        return DSAKeyPairGenerator.generateParameters(n, null, randomBitsSource);
    }

    public static DSAParams generateParameters(int n, byte[] byArray, RandomBitsSource randomBitsSource) {
        int n2;
        FIPS_140_2.assertReadyState();
        byte[] byArray2 = null;
        boolean bl = false;
        if (byArray != null && byArray.length >= 20) {
            byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        } else {
            byArray2 = new byte[20];
            bl = true;
        }
        BigInt bigInt = null;
        BigInt bigInt2 = null;
        BigInt bigInt3 = null;
        byte[] byArray3 = new byte[byArray2.length];
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(AlgID.sha_1);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new RuntimeException("SHA1 class not found. " + algorithmIdentifierException.toString());
        }
        while (true) {
            if (bl) {
                randomBitsSource.randomBytes(byArray2);
            } else {
                bl = true;
            }
            System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
            bigInt2 = DSAKeyPairGenerator.generateQ(byArray3, messageDigest);
            if (!Prime.isProbablePrime(bigInt2, 100, randomBitsSource)) continue;
            n2 = 0;
            while (n2 < 4096) {
                bigInt = DSAKeyPairGenerator.generateP(n, bigInt2, byArray3, messageDigest);
                if (bigInt.compareTo(BigInt.ONE.shiftLeft(n - 1)) >= 0 && Prime.isProbablePrime(bigInt, 100, randomBitsSource)) break;
                bigInt = null;
                ++n2;
            }
            if (bigInt != null) break;
        }
        BigInt bigInt4 = bigInt.subtract(BigInt.ONE).divide(bigInt2);
        BigInt bigInt5 = BigInt.TWO;
        while ((bigInt3 = bigInt5.modPow(bigInt4, bigInt)).compareTo(BigInt.ONE) == 0) {
            bigInt5 = bigInt5.add(BigInt.ONE);
        }
        return new DSAParams(bigInt, bigInt2, bigInt3, byArray2, n2, bigInt5);
    }

    static BigInt generateQ(byte[] byArray, MessageDigest messageDigest) {
        byte[] byArray2 = new byte[20];
        messageDigest.init();
        messageDigest.update(byArray);
        messageDigest.computeCurrent();
        System.arraycopy(messageDigest.getDigestBitsInternal(), 0, byArray2, 0, 20);
        int n = byArray.length - 1;
        while (n >= 0) {
            byArray[n] = (byte)((byArray[n] & 0xFF) + 1);
            if (byArray[n] != 0) break;
            --n;
        }
        messageDigest.init();
        messageDigest.update(byArray);
        messageDigest.computeCurrent();
        int n2 = 0;
        while (n2 < 20) {
            int n3 = n2;
            byArray2[n3] = (byte)(byArray2[n3] ^ messageDigest.getDigestBitsInternal()[n2]);
            ++n2;
        }
        byArray2[0] = (byte)(byArray2[0] | 0x80);
        byArray2[19] = (byte)(byArray2[19] | 1);
        return new BigInt(1, byArray2);
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public static DSAParams getParameters(int n, RandomBitsSource randomBitsSource) {
        FIPS_140_2.assertReadyState();
        if (n == 512) {
            return params512;
        }
        if (n == 768) {
            return params768;
        }
        if (n == 1024) {
            return params1024;
        }
        return DSAKeyPairGenerator.generateParameters(n, randomBitsSource);
    }

    public void initialize(int n, RandomBitsSource randomBitsSource) {
        this.initialize(DSAKeyPairGenerator.getParameters(n, randomBitsSource), randomBitsSource);
    }

    public void initialize(DSAParams dSAParams, RandomBitsSource randomBitsSource) {
        this.params = dSAParams;
        this.setRandomBitsSource(randomBitsSource);
        this.initialized = true;
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        FIPS_140_2.assertReadyState();
        if (algorithmIdentifier.equals(AlgID.dsa) || algorithmIdentifier.equals(AlgID.dsaOld)) {
            this.keyAlgID = algorithmIdentifier;
            ASN1Object aSN1Object = algorithmIdentifier.getParameters();
            if (aSN1Object != null && aSN1Object.getClass() != (class$com$phaos$ASN1$ASN1Null != null ? class$com$phaos$ASN1$ASN1Null : (class$com$phaos$ASN1$ASN1Null = DSAKeyPairGenerator.class$("com.phaos.ASN1.ASN1Null")))) {
                this.params = (DSAParams)aSN1Object;
            }
        } else {
            throw new AlgorithmIdentifierException("Unknown DSA key algorithm identifier");
        }
    }
}

