/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.DSAKeyPairGenerator;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.fips.FIPS_140_2;
import com.phaos.math.BigInt;
import com.phaos.math.Prime;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;

public class DSAParams
implements ASN1Object,
Externalizable {
    private BigInt p;
    private BigInt q;
    private BigInt g;
    private byte[] seed;
    private int counter;
    private transient BigInt h;
    private ASN1Sequence contents;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    public DSAParams() {
    }

    public DSAParams(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(aSN1Sequence);
    }

    DSAParams(BigInt bigInt, BigInt bigInt2, BigInt bigInt3) {
        FIPS_140_2.assertReadyState();
        this.p = bigInt;
        this.q = bigInt2;
        this.g = bigInt3;
    }

    DSAParams(BigInt bigInt, BigInt bigInt2, BigInt bigInt3, byte[] byArray, int n, BigInt bigInt4) {
        FIPS_140_2.assertReadyState();
        this.p = bigInt;
        this.q = bigInt2;
        this.g = bigInt3;
        this.seed = byArray;
        this.counter = n;
        this.h = bigInt4;
    }

    public DSAParams(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public DSAParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this(BigInt.getInstance(bigInteger), BigInt.getInstance(bigInteger2), BigInt.getInstance(bigInteger3));
    }

    public DSAParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, byte[] byArray, int n, BigInteger bigInteger4) {
        this(BigInt.getInstance(bigInteger), BigInt.getInstance(bigInteger2), BigInt.getInstance(bigInteger3), byArray, n, BigInt.getInstance(bigInteger4));
    }

    public int getCounter() {
        FIPS_140_2.assertReadyState();
        return this.counter;
    }

    public BigInteger getG() {
        return new BigInteger(this.getGInternal().toByteArray());
    }

    BigInt getGInternal() {
        FIPS_140_2.assertReadyState();
        return this.g;
    }

    public BigInteger getH() {
        return new BigInteger(this.getHInternal().toByteArray());
    }

    BigInt getHInternal() {
        FIPS_140_2.assertReadyState();
        return this.h;
    }

    public BigInteger getP() {
        return new BigInteger(this.getPInternal().toByteArray());
    }

    BigInt getPInternal() {
        FIPS_140_2.assertReadyState();
        return this.p;
    }

    public BigInteger getQ() {
        return new BigInteger(this.getQInternal().toByteArray());
    }

    BigInt getQInternal() {
        FIPS_140_2.assertReadyState();
        return this.q;
    }

    public byte[] getSeed() {
        FIPS_140_2.assertReadyState();
        return this.seed;
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        FIPS_140_2.assertReadyState();
        this.contents = aSN1Sequence;
        this.seed = null;
        try {
            this.p = ((ASN1Integer)aSN1Sequence.elementAt(0)).getBigIntValue();
            this.q = ((ASN1Integer)aSN1Sequence.elementAt(1)).getBigIntValue();
            this.g = ((ASN1Integer)aSN1Sequence.elementAt(2)).getBigIntValue();
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
    }

    public void input(InputStream inputStream) throws IOException {
        this.input(new ASN1Sequence(inputStream));
    }

    public boolean isValidParams() {
        FIPS_140_2.assertReadyState();
        if (this.seed == null || this.counter == 0 || this.h == null) {
            throw new IllegalStateException("Missing validation parameters");
        }
        if (this.seed.length < 20) {
            return false;
        }
        if (this.counter >= 4096 || this.counter < 0) {
            return false;
        }
        MessageDigest messageDigest = null;
        RandomBitsSource randomBitsSource = RandomBitsSource.getDefault();
        if (this.q.bitLength() != 160 || !Prime.isProbablePrime(this.q, 100, randomBitsSource)) {
            return false;
        }
        if (this.g.compareTo(BigInt.ONE) == 0 || this.h.compareTo(BigInt.TWO) < 0 || this.h.compareTo(this.p.subtract(BigInt.TWO)) > 0 || this.g.compareTo(this.h.modPow(this.p.subtract(BigInt.ONE).divide(this.q), this.p)) != 0) {
            return false;
        }
        try {
            messageDigest = MessageDigest.getInstance(AlgID.sha_1);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new RuntimeException(algorithmIdentifierException.toString());
        }
        byte[] byArray = new byte[this.seed.length];
        System.arraycopy(this.seed, 0, byArray, 0, this.seed.length);
        BigInt bigInt = DSAKeyPairGenerator.generateQ(byArray, messageDigest);
        if (this.q.compareTo(bigInt) != 0) {
            return false;
        }
        BigInt bigInt2 = null;
        int n = 0;
        int n2 = this.p.bitLength();
        while (!((bigInt2 = DSAKeyPairGenerator.generateP(n2, this.q, byArray, messageDigest)).compareTo(BigInt.ONE.shiftLeft(n2 - 1)) > 0 && Prime.isProbablePrime(bigInt2, 100, randomBitsSource) || ++n > this.counter)) {
        }
        return n == this.counter && this.p.compareTo(bigInt2) == 0;
    }

    public int length() {
        return this.outputASN1().length();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.outputASN1().output(outputStream);
    }

    public ASN1Sequence outputASN1() {
        FIPS_140_2.assertReadyState();
        if (this.contents != null) {
            return this.contents;
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1Integer(this.p));
        aSN1Sequence.addElement(new ASN1Integer(this.q));
        aSN1Sequence.addElement(new ASN1Integer(this.g));
        this.contents = aSN1Sequence;
        return aSN1Sequence;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        FIPS_140_2.assertReadyState();
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    public String toString() {
        FIPS_140_2.assertReadyState();
        String string = "p = " + this.p + ", q = " + this.q + ", g = " + this.g;
        if (this.seed != null) {
            string = String.valueOf(string) + ",\nseed = " + Utils.toHexString(this.seed) + ", counter = " + this.counter;
        }
        return string;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }
}

