/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1GenericConstructed;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.DSA;
import com.phaos.crypto.DSAParams;
import com.phaos.crypto.PrivateKey;
import com.phaos.fips.FIPS_140_2;
import com.phaos.fips.KeyExportException;
import com.phaos.math.BigInt;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import com.phaos.utils.VersionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;

public class DSAPrivateKey
implements PrivateKey,
ASN1Object {
    private ASN1ObjectID algOID = DSA.dsaKeyOID;
    private DSAParams params;
    private BigInt x;
    private boolean allowExport = true;
    private byte[] pkiBytes;
    private ASN1Integer keyContents;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    public DSAPrivateKey() {
    }

    public DSAPrivateKey(ASN1Sequence aSN1Sequence) throws IOException {
        this(Utils.toStream(aSN1Sequence));
    }

    DSAPrivateKey(BigInt bigInt, DSAParams dSAParams) {
        FIPS_140_2.assertReadyState();
        this.x = bigInt;
        this.params = dSAParams;
    }

    public DSAPrivateKey(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public DSAPrivateKey(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public DSAPrivateKey(BigInteger bigInteger, DSAParams dSAParams) {
        this(BigInt.getInstance(bigInteger), dSAParams);
    }

    public DSAPrivateKey(byte[] byArray) throws IOException {
        this(new UnsyncByteArrayInputStream(byArray));
    }

    private void assertAllowExport() {
        if (!this.getAllowExport() || !FIPS_140_2.getAllowKeyExport()) {
            throw new KeyExportException("Plaintext key export not allowed");
        }
    }

    public Object clone() {
        FIPS_140_2.assertReadyState();
        DSAPrivateKey dSAPrivateKey = new DSAPrivateKey();
        try {
            if (this.algOID != null) {
                dSAPrivateKey.algOID = new ASN1ObjectID(Utils.toStream(this.algOID));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing algorithm identifier to stream");
        }
        try {
            if (this.params != null) {
                dSAPrivateKey.params = new DSAParams(Utils.toStream(this.params));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing key DSA parameters to stream");
        }
        if (this.x != null) {
            dSAPrivateKey.x = BigInt.getInstance(this.x);
        }
        dSAPrivateKey.allowExport = this.allowExport;
        return dSAPrivateKey;
    }

    public void erase() {
        this.params = null;
        if (this.x != null) {
            this.x.erase();
            this.x = null;
        }
        this.eraseCache();
    }

    private void eraseCache() {
        if (this.pkiBytes != null) {
            Utils.setArray(this.pkiBytes, (byte)0);
            this.pkiBytes = null;
        }
        if (this.keyContents != null) {
            this.keyContents.erase();
            this.keyContents = null;
        }
    }

    public void finalize() {
        this.erase();
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        return new AlgorithmIdentifier(this.algOID, this.params);
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public boolean getAllowExport() {
        return this.allowExport;
    }

    public int getBitLength() {
        FIPS_140_2.assertReadyState();
        if (this.params == null || this.params.getP() == null) {
            return 0;
        }
        return this.params.getP().bitLength();
    }

    public ASN1Object getContents() {
        this.assertAllowExport();
        FIPS_140_2.assertReadyState();
        return new ASN1Integer(this.x);
    }

    ASN1Object getContentsInternal() {
        FIPS_140_2.assertReadyState();
        if (this.keyContents == null) {
            this.keyContents = new ASN1Integer(this.x);
        }
        return this.keyContents;
    }

    public byte[] getEncoded() {
        this.assertAllowExport();
        return (byte[])this.getEncodedInternal().clone();
    }

    byte[] getEncodedInternal() {
        FIPS_140_2.assertReadyState();
        if (this.pkiBytes == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(new ASN1Integer(0L));
            aSN1Sequence.addElement(this.getAlgID());
            aSN1Sequence.addElement(new ASN1OctetString(Utils.toBytes(this.getContentsInternal())));
            this.pkiBytes = Utils.toBytes(aSN1Sequence);
        }
        return this.pkiBytes;
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public ASN1ObjectID getKeyAlgOID() {
        FIPS_140_2.assertReadyState();
        return this.algOID;
    }

    public DSAParams getParams() {
        FIPS_140_2.assertReadyState();
        return this.params;
    }

    public BigInteger getX() {
        this.assertAllowExport();
        FIPS_140_2.assertReadyState();
        return new BigInteger(this.x.toByteArray());
    }

    BigInt getXInternal() {
        FIPS_140_2.assertReadyState();
        return this.x;
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws AlgorithmIdentifierException, InvalidInputException {
        ASN1Object aSN1Object2;
        FIPS_140_2.assertReadyState();
        this.erase();
        this.algOID = algorithmIdentifier.getOID();
        try {
            aSN1Object2 = algorithmIdentifier.getParameters();
            this.params = aSN1Object2 instanceof DSAParams ? (DSAParams)aSN1Object2 : new DSAParams((ASN1Sequence)algorithmIdentifier.getParameters());
        }
        catch (IOException iOException) {
            this.params = null;
        }
        catch (ClassCastException classCastException) {
            this.params = null;
        }
        if ((this.algOID.equals(AlgID.dsaOld.getOID()) || this.algOID.equals(AlgID.dsaWithSHA1.getOID()) && ((ASN1Sequence)aSN1Object).size() == 5) && this.params == null) {
            aSN1Object2 = (ASN1Sequence)aSN1Object;
            try {
                this.params = new DSAParams(((ASN1Integer)((ASN1Sequence)aSN1Object2).elementAt(0)).getValue(), ((ASN1Integer)((ASN1Sequence)aSN1Object2).elementAt(1)).getValue(), ((ASN1Integer)((ASN1Sequence)aSN1Object2).elementAt(2)).getValue());
                this.x = ((ASN1Integer)((ASN1Sequence)aSN1Object2).elementAt(3)).getBigIntValue();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new AlgorithmIdentifierException("CDSA contents invalid.");
            }
            catch (ClassCastException classCastException) {
                throw new AlgorithmIdentifierException("CDSA contents invalid.");
            }
        } else if (this.params != null) {
            try {
                this.x = ((ASN1Integer)aSN1Object).getBigIntValue();
            }
            catch (ClassCastException classCastException) {
                throw new InvalidInputException("Contents invalid.");
            }
        } else {
            throw new AlgorithmIdentifierException("DSA parameters missing.");
        }
    }

    public void input(InputStream inputStream) throws IOException {
        FIPS_140_2.assertReadyState();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        ASN1Integer aSN1Integer = new ASN1Integer(aSN1SequenceInputStream);
        if (!aSN1Integer.equals(0)) {
            throw new VersionException(aSN1Integer.getValue(), 0);
        }
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(aSN1SequenceInputStream);
        ASN1Object aSN1Object = null;
        ASN1Object aSN1Object2 = ASN1Utils.inputASN1Object(aSN1SequenceInputStream);
        if (aSN1Object2 instanceof ASN1OctetString) {
            aSN1Object = ASN1Utils.inputASN1Object(new UnsyncByteArrayInputStream(((ASN1OctetString)aSN1Object2).getValue()));
        } else if (aSN1Object2 instanceof ASN1Sequence) {
            aSN1Object = aSN1Object2;
        } else {
            throw new IOException("Invalid private key contents");
        }
        if (aSN1SequenceInputStream.hasMoreData()) {
            new ASN1GenericConstructed(aSN1SequenceInputStream);
        }
        aSN1SequenceInputStream.terminate();
        try {
            this.initialize(algorithmIdentifier, aSN1Object);
            if (aSN1Object instanceof ASN1Sequence) {
                ((ASN1Integer)((ASN1Sequence)aSN1Object).elementAt(3)).erase();
            } else {
                ((ASN1Integer)aSN1Object).erase();
            }
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IOException(algorithmIdentifierException.toString());
        }
    }

    public int length() {
        return this.getEncodedInternal().length;
    }

    public void output(OutputStream outputStream) throws IOException {
        outputStream.write(this.getEncoded());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        FIPS_140_2.assertReadyState();
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    public void setAllowExport(boolean bl) {
        this.allowExport = bl;
    }

    public void setKeyAlgOID(ASN1ObjectID aSN1ObjectID) {
        FIPS_140_2.assertReadyState();
        this.algOID = aSN1ObjectID;
        this.eraseCache();
    }

    public void setParams(DSAParams dSAParams) {
        FIPS_140_2.assertReadyState();
        this.params = dSAParams;
        this.eraseCache();
    }

    public String toString() {
        FIPS_140_2.assertReadyState();
        return "params = {" + this.params + "}, bitLength = " + this.getBitLength();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getEncoded());
    }
}

