/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1BitString;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.DSA;
import com.phaos.crypto.DSAParams;
import com.phaos.crypto.PublicKey;
import com.phaos.fips.FIPS_140_2;
import com.phaos.math.BigInt;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;

public class DSAPublicKey
implements PublicKey,
ASN1Object {
    private ASN1ObjectID algOID = DSA.dsaKeyOID;
    private DSAParams params;
    private BigInt y;
    private byte[] spkiBytes;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    public DSAPublicKey() {
    }

    public DSAPublicKey(ASN1Sequence aSN1Sequence) throws IOException {
        this(Utils.toStream(aSN1Sequence));
    }

    DSAPublicKey(BigInt bigInt, DSAParams dSAParams) {
        FIPS_140_2.assertReadyState();
        this.y = bigInt;
        this.params = dSAParams;
    }

    public DSAPublicKey(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public DSAPublicKey(BigInteger bigInteger, DSAParams dSAParams) {
        this(BigInt.getInstance(bigInteger), dSAParams);
    }

    public DSAPublicKey(byte[] byArray) throws IOException {
        this(new UnsyncByteArrayInputStream(byArray));
    }

    public Object clone() {
        FIPS_140_2.assertReadyState();
        DSAPublicKey dSAPublicKey = new DSAPublicKey();
        try {
            if (this.algOID != null) {
                dSAPublicKey.algOID = new ASN1ObjectID(Utils.toStream(this.algOID));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing algorithm identifier to stream");
        }
        try {
            if (this.params != null) {
                dSAPublicKey.params = new DSAParams(Utils.toStream(this.params));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing key DSA parameters to stream");
        }
        if (this.y != null) {
            dSAPublicKey.y = BigInt.getInstance(this.y);
        }
        return dSAPublicKey;
    }

    public void erase() {
        this.params = null;
        this.y = null;
        this.spkiBytes = null;
    }

    public void finalize() {
        this.erase();
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        return new AlgorithmIdentifier(this.algOID, this.params);
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public boolean getAllowExport() {
        return true;
    }

    public int getBitLength() {
        FIPS_140_2.assertReadyState();
        if (this.params == null || this.params.getP() == null) {
            return 0;
        }
        return this.params.getP().bitLength();
    }

    public ASN1Object getContents() {
        FIPS_140_2.assertReadyState();
        return new ASN1Integer(this.y);
    }

    public byte[] getEncoded() {
        FIPS_140_2.assertReadyState();
        if (this.spkiBytes == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
            aSN1Sequence2.addElement(this.algOID);
            aSN1Sequence2.addElement(this.params);
            aSN1Sequence.addElement(aSN1Sequence2);
            aSN1Sequence.addElement(new ASN1BitString(Utils.toBytes(this.getContents())));
            this.spkiBytes = Utils.toBytes(aSN1Sequence);
        }
        return this.spkiBytes;
    }

    public String getFormat() {
        return "X.509";
    }

    public ASN1ObjectID getKeyAlgOID() {
        FIPS_140_2.assertReadyState();
        return this.algOID;
    }

    public DSAParams getParams() {
        FIPS_140_2.assertReadyState();
        return this.params;
    }

    public BigInteger getY() {
        return new BigInteger(this.getYInternal().toByteArray());
    }

    BigInt getYInternal() {
        FIPS_140_2.assertReadyState();
        return this.y;
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws AlgorithmIdentifierException, InvalidInputException {
        FIPS_140_2.assertReadyState();
        this.algOID = algorithmIdentifier.getOID();
        try {
            this.params = new DSAParams((ASN1Sequence)algorithmIdentifier.getParameters());
        }
        catch (IOException iOException) {
            throw new AlgorithmIdentifierException("Invalid DSA parameters.");
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Invalid DSA parameters.");
        }
        if (this.params == null) {
            throw new AlgorithmIdentifierException("DSA parameters missing.");
        }
        try {
            this.y = ((ASN1Integer)aSN1Object).getBigIntValue();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException("Contents invalid.");
        }
        this.spkiBytes = null;
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(Utils.toStream(aSN1Sequence));
    }

    public void input(InputStream inputStream) throws IOException {
        FIPS_140_2.assertReadyState();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(aSN1SequenceInputStream);
        ASN1Integer aSN1Integer = new ASN1Integer(new UnsyncByteArrayInputStream(ASN1BitString.inputValue(aSN1SequenceInputStream)));
        aSN1SequenceInputStream.terminate();
        try {
            this.initialize(algorithmIdentifier, aSN1Integer);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IOException(algorithmIdentifierException.toString());
        }
    }

    public int length() {
        return this.getEncoded().length;
    }

    public void output(OutputStream outputStream) throws IOException {
        outputStream.write(this.getEncoded());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        FIPS_140_2.assertReadyState();
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    public void setKeyAlgOID(ASN1ObjectID aSN1ObjectID) {
        FIPS_140_2.assertReadyState();
        this.algOID = aSN1ObjectID;
        this.spkiBytes = null;
    }

    public void setParams(DSAParams dSAParams) {
        FIPS_140_2.assertReadyState();
        this.params = dSAParams;
        this.spkiBytes = null;
    }

    public String toString() {
        FIPS_140_2.assertReadyState();
        return "y = " + this.y + ", params = {" + this.params + "}";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getEncoded());
    }
}

