/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.EntropySource;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.fips.FIPS_140_2;
import com.phaos.math.BigInt;
import com.phaos.utils.Utils;

public class DSARandomBitsSource
extends RandomBitsSource {
    private static final int DEFAULT_SEED_SIZE = 20;
    private static final int m = 2000000;
    private final byte[] current = new byte[40];
    private final BigInt[] w = new BigInt[2];
    private BigInt XKEY;
    private BigInt XVAL;
    private int b;
    private int j;
    private boolean seeded = false;
    private int index;
    private MessageDigest md;

    public DSARandomBitsSource() {
        this(true);
    }

    public DSARandomBitsSource(boolean bl) {
        try {
            this.md = MessageDigest.getInstance(AlgID.sha1);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IllegalStateException(algorithmIdentifierException.toString());
        }
        if (bl) {
            this.seed();
        }
    }

    private BigInt G(BigInt bigInt) {
        int n = (512 - this.b) / 8;
        byte[] byArray = new byte[64];
        Utils.toByteArray(bigInt, byArray, 0, n);
        return new BigInt(1, this.md.computeDigest(byArray));
    }

    public synchronized void clear() {
        if (this.XKEY != null) {
            this.XKEY.erase();
            this.XKEY = null;
        }
        if (this.XVAL != null) {
            this.XVAL.erase();
            this.XVAL = null;
        }
        this.b = 0;
        this.j = 0;
        this.erase(this.w);
        DSARandomBitsSource.erase(this.current);
        this.index = 0;
        this.seeded = false;
    }

    private void computeCurrent() {
        DSARandomBitsSource.erase(this.current);
        this.erase(this.w);
        if (this.j == 2000000) {
            this.clear();
            this.seed();
        }
        int n = 0;
        while (n < 2) {
            if (this.XVAL != null) {
                this.XVAL.erase();
            }
            this.XVAL = this.XKEY.mod(BigInt.TWO.pow(this.b));
            this.w[n] = this.G(this.XVAL);
            if (this.XKEY != null) {
                this.XKEY.erase();
            }
            this.XKEY = BigInt.ONE.add(this.XVAL).add(this.w[n]).mod(BigInt.TWO.pow(this.b));
            ++n;
        }
        int n2 = 0;
        int n3 = this.w.length;
        while (n2 < n3) {
            Utils.toByteArray(this.w[n2], this.current, n2 * 20, 20);
            ++n2;
        }
        ++this.j;
    }

    private static void erase(byte[] byArray) {
        if (byArray != null) {
            Utils.setArray(byArray, (byte)0);
        }
    }

    private void erase(BigInt[] bigIntArray) {
        if (bigIntArray != null) {
            int n = 0;
            int n2 = bigIntArray.length;
            while (n < n2) {
                if (bigIntArray[n] != null) {
                    bigIntArray[n].erase();
                    bigIntArray[n] = null;
                }
                ++n;
            }
        }
    }

    public synchronized byte randomByte() {
        if (!this.seeded) {
            throw new IllegalStateException("PRNG has not been seeded.");
        }
        FIPS_140_2.assertReadyState();
        if (this.XVAL == null || this.index == this.current.length) {
            this.computeCurrent();
            this.index = 0;
        }
        byte by = this.current[this.index++];
        this.getRNGTest().testRandomByte(by);
        return by;
    }

    public synchronized byte[] randomBytes(byte[] byArray) {
        if (!this.seeded) {
            throw new IllegalStateException("PRNG has not been seeded.");
        }
        FIPS_140_2.assertReadyState();
        if (this.XVAL == null) {
            this.computeCurrent();
        }
        int n = byArray.length;
        int n2 = Math.min(this.current.length - this.index, n);
        System.arraycopy(this.current, this.index, byArray, 0, n2);
        this.index += n2;
        int n3 = n;
        while (n2 < n3) {
            this.computeCurrent();
            this.index = Math.min(this.current.length, n - n2);
            System.arraycopy(this.current, 0, byArray, n2, this.index);
            n2 += this.current.length;
        }
        this.getRNGTest().testRandomBytes(byArray, 0, n);
        return byArray;
    }

    public synchronized void seed(EntropySource entropySource) {
        this.seed(entropySource.generateBytes(new byte[20]));
    }

    public synchronized void seed(byte[] byArray) {
        FIPS_140_2.assertReadyState();
        if (byArray.length < 20 || byArray.length > 64) {
            throw new IllegalArgumentException("Seed value must be between 20 bytes and 64 bytes in length.");
        }
        this.XKEY = new BigInt(1, byArray);
        this.b = byArray.length * 8;
        this.seeded = true;
        this.getRNGTest().initialize();
    }
}

