/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.fips.FIPS_140_2;
import com.phaos.math.BigInt;
import com.phaos.math.Prime;
import com.phaos.utils.OIDManager;
import java.math.BigInteger;

public class DiffieHellman {
    private BigInt p;
    private BigInt g;
    private BigInt x;
    private BigInt gx;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    public DiffieHellman() {
    }

    public DiffieHellman(RandomBitsSource randomBitsSource, int n) throws IllegalArgumentException {
        this();
        this.initialize(randomBitsSource, n);
    }

    public DiffieHellman(BigInteger bigInteger, BigInteger bigInteger2, RandomBitsSource randomBitsSource) {
        this();
        this.initialize(bigInteger, bigInteger2, randomBitsSource);
    }

    public void erase() {
        this.p = null;
        this.g = null;
        if (this.x != null) {
            this.x.erase();
            this.x = null;
        }
        if (this.gx != null) {
            this.gx.erase();
            this.gx = null;
        }
    }

    public void finalize() {
        this.erase();
    }

    protected void generatePandG(RandomBitsSource randomBitsSource, int n) {
        BigInt bigInt;
        do {
            bigInt = Prime.generateBigIntPrime(n, randomBitsSource);
            this.p = bigInt.shiftLeft(1).add(BigInt.ONE);
        } while (!this.p.isProbablePrime(100));
        this.g = BigInt.valueOf(4L);
        bigInt.erase();
    }

    protected void generateValues(RandomBitsSource randomBitsSource) {
        while (true) {
            this.x = randomBitsSource.randomBigInt(this.p.bitLength());
            if (this.x.compareTo(BigInt.ONE) <= 0 && this.x.compareTo(this.p) >= 0) continue;
            this.gx = this.g.modPow(this.x, this.p);
            if (!this.gx.equals(BigInt.ONE)) break;
        }
    }

    public BigInteger getGen() {
        FIPS_140_2.assertReadyState();
        return new BigInteger(this.g.toByteArray());
    }

    public static DiffieHellman getInstance() throws AlgorithmIdentifierException {
        DiffieHellman diffieHellman;
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(AlgID.dhKeyAgreement.getOID(), "cipher");
        if (clazz == null) {
            throw new AlgorithmIdentifierException("DiffieHellman algID not found");
        }
        try {
            diffieHellman = (DiffieHellman)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Class does not implement Cipher.");
        }
        return diffieHellman;
    }

    public static DiffieHellman getInstance(RandomBitsSource randomBitsSource, int n) throws IllegalArgumentException, AlgorithmIdentifierException {
        DiffieHellman diffieHellman = DiffieHellman.getInstance();
        diffieHellman.initialize(randomBitsSource, n);
        return diffieHellman;
    }

    public static DiffieHellman getInstance(BigInteger bigInteger, BigInteger bigInteger2, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException {
        DiffieHellman diffieHellman = DiffieHellman.getInstance();
        diffieHellman.initialize(bigInteger, bigInteger2, randomBitsSource);
        return diffieHellman;
    }

    public BigInteger getKey(BigInteger bigInteger) {
        FIPS_140_2.assertReadyState();
        return new BigInteger(BigInt.getInstance(bigInteger).modPow(this.x, this.p).toByteArray());
    }

    public BigInteger getPrime() {
        FIPS_140_2.assertReadyState();
        return new BigInteger(this.p.toByteArray());
    }

    public void initialize(RandomBitsSource randomBitsSource, int n) {
        FIPS_140_2.assertReadyState();
        this.generatePandG(randomBitsSource, n);
        this.generateValues(randomBitsSource);
    }

    public void initialize(BigInteger bigInteger, BigInteger bigInteger2, RandomBitsSource randomBitsSource) {
        FIPS_140_2.assertReadyState();
        this.p = BigInt.getInstance(bigInteger);
        this.g = BigInt.getInstance(bigInteger2);
        this.generateValues(randomBitsSource);
    }

    public BigInteger myValue() {
        FIPS_140_2.assertReadyState();
        return new BigInteger(this.gx.toByteArray());
    }

    public String toString() {
        FIPS_140_2.assertReadyState();
        return "p = " + this.p + ", g = " + this.g;
    }
}

