/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.MessageDigest;
import com.phaos.fips.FIPS_140_2;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DigestOutputStream
extends FilterOutputStream {
    protected MessageDigest messageDigest;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    public DigestOutputStream(OutputStream outputStream, MessageDigest messageDigest) {
        super(outputStream);
        this.messageDigest = messageDigest;
    }

    public byte[] computeCurrent() {
        this.messageDigest.computeCurrent();
        return this.messageDigest.getDigestBits();
    }

    public MessageDigest getMessageDigest() {
        return this.messageDigest;
    }

    public void setMessageDigest(MessageDigest messageDigest) {
        this.messageDigest = messageDigest;
    }

    public synchronized void write(int n) throws IOException {
        this.messageDigest.update((byte)n);
        this.out.write(n);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n;
        int n4 = n + n2;
        while (n3 < n4) {
            this.write(byArray[n3]);
            ++n3;
        }
    }
}

