/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.EntropySource;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.fips.FIPS_140_2;

public abstract class DigestRandomBitsSource
extends RandomBitsSource {
    private byte[] pool;
    private byte[] current = new byte[0];
    private long count;
    private int index;
    private MessageDigest md;
    private boolean seeded = false;
    private static final int DEFAULT_SEED_SIZE = 20;

    protected DigestRandomBitsSource() {
    }

    public synchronized void clear() {
        if (this.pool != null) {
            int n = 0;
            while (n < this.pool.length) {
                this.pool[n] = 0;
                ++n;
            }
        }
        if (this.md != null) {
            this.md.init();
        }
        this.current = null;
        this.index = 0;
        this.count = 0;
        this.seeded = false;
    }

    private byte[] computeCurrent() {
        this.md.init();
        this.md.update(this.pool);
        this.md.update(this.count++);
        this.md.computeCurrent();
        return this.md.getDigestBitsInternal();
    }

    protected synchronized void initialize(AlgorithmIdentifier algorithmIdentifier) {
        try {
            this.md = MessageDigest.getInstance(algorithmIdentifier);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new RuntimeException(algorithmIdentifierException.toString());
        }
        this.pool = new byte[this.md.blockSize()];
        this.seeded = false;
    }

    public synchronized byte randomByte() {
        if (!this.seeded) {
            throw new IllegalStateException("PRNG has not been seeded");
        }
        FIPS_140_2.assertReadyState();
        if (this.index == this.current.length) {
            this.current = this.computeCurrent();
            this.index = 0;
        }
        byte by = this.current[this.index++];
        this.getRNGTest().testRandomByte(by);
        return by;
    }

    public synchronized byte[] randomBytes(byte[] byArray) {
        if (!this.seeded) {
            throw new IllegalStateException("PRNG has not been seeded");
        }
        FIPS_140_2.assertReadyState();
        int n = byArray.length;
        int n2 = Math.min(this.current.length - this.index, n);
        System.arraycopy(this.current, this.index, byArray, 0, n2);
        this.index += n2;
        int n3 = n;
        while (n2 < n3) {
            this.current = this.computeCurrent();
            this.index = Math.min(this.current.length, n - n2);
            System.arraycopy(this.current, 0, byArray, n2, this.index);
            n2 += this.current.length;
        }
        this.getRNGTest().testRandomBytes(byArray, 0, n);
        return byArray;
    }

    public synchronized void seed() {
        this.seed(EntropySource.getDefault());
    }

    public synchronized void seed(EntropySource entropySource) {
        this.seed(entropySource.generateBytes(new byte[20]));
    }

    public synchronized void seed(Object object) {
        this.md.init();
        this.md.update(this.pool);
        this.md.update(object.hashCode());
        this.md.update(object.toString());
        this.md.computeCurrent();
        this.pool = this.md.getDigestBitsInternal();
        this.index = 0;
        this.current = new byte[0];
        this.seeded = true;
        this.getRNGTest().initialize();
    }

    public synchronized void seed(byte[] byArray) {
        this.md.init();
        this.md.update(this.pool);
        this.md.update(byArray);
        this.md.computeCurrent();
        this.pool = this.md.getDigestBitsInternal();
        this.index = 0;
        this.current = new byte[0];
        this.seeded = true;
        this.getRNGTest().initialize();
    }
}

