/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.ECParams;
import com.phaos.crypto.ECPrivateKey;
import com.phaos.crypto.ECPublicKey;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.KeyAgreement;
import com.phaos.crypto.KeyAgreementException;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PublicKey;
import com.phaos.fips.FIPS_140_2;
import com.phaos.math.ECPoint;

public class ECDHKeyAgreement
extends KeyAgreement {
    private ECPublicKey otherPartyPubKey;
    private ECPrivateKey localPartyPrivKey;

    public ECDHKeyAgreement() {
    }

    public ECDHKeyAgreement(ECPrivateKey eCPrivateKey) throws InvalidKeyException {
        this.setPrivateKey(eCPrivateKey);
    }

    public ECDHKeyAgreement(ECPrivateKey eCPrivateKey, ECPublicKey eCPublicKey) throws InvalidKeyException {
        this.setPrivateKey(eCPrivateKey);
        this.setPublicKey(eCPublicKey);
    }

    public ECDHKeyAgreement(ECPublicKey eCPublicKey) throws InvalidKeyException {
        this.setPublicKey(eCPublicKey);
    }

    public String algName() {
        return "ECDH";
    }

    public byte[] generateSecret() throws KeyAgreementException {
        FIPS_140_2.assertReadyState();
        if (this.localPartyPrivKey == null) {
            throw new IllegalStateException("Local party's private key is not set yet.");
        }
        if (this.otherPartyPubKey == null) {
            throw new IllegalStateException("Other party's public key is not set yet.");
        }
        ECParams eCParams = this.localPartyPrivKey.getParams();
        if (!eCParams.getBasePoint().equals(this.otherPartyPubKey.getParams().getBasePoint())) {
            throw new KeyAgreementException("Mismatch between local party's private key and other party's public key");
        }
        ECPoint eCPoint = this.otherPartyPubKey.getQ().multiply(eCParams.getCofactorInternal().multiply(this.localPartyPrivKey.getDInternal()));
        if (eCPoint.isPointZero()) {
            throw new KeyAgreementException("A trivial secret value was generated");
        }
        return eCPoint.getX().toByteArray();
    }

    public AlgorithmIdentifier getAlgID() {
        return null;
    }

    public PublicKey getPublicKey() {
        FIPS_140_2.assertReadyState();
        return this.otherPartyPubKey;
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
    }

    public void setPrivateKey(PrivateKey privateKey) throws InvalidKeyException {
        FIPS_140_2.assertReadyState();
        if (!(privateKey instanceof ECPrivateKey)) {
            throw new InvalidKeyException("The key is not a ECPrivateKey.");
        }
        ECParams eCParams = ((ECPrivateKey)privateKey).getParams();
        if (eCParams == null || eCParams.getBasePoint() == null || eCParams.getCofactor() == null) {
            throw new InvalidKeyException("Missing parameters in the private key");
        }
        this.localPartyPrivKey = (ECPrivateKey)privateKey;
    }

    public void setPublicKey(PublicKey publicKey) throws InvalidKeyException {
        FIPS_140_2.assertReadyState();
        if (!(publicKey instanceof ECPublicKey)) {
            throw new InvalidKeyException("The key is not a ECPublicKey.");
        }
        ECParams eCParams = ((ECPublicKey)publicKey).getParams();
        if (eCParams == null || eCParams.getBasePoint() == null || eCParams.getCofactor() == null) {
            throw new InvalidKeyException("Missing parameters in the public key");
        }
        this.otherPartyPubKey = (ECPublicKey)publicKey;
    }
}

