/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.AuthenticationException;
import com.phaos.crypto.ECC;
import com.phaos.crypto.ECParams;
import com.phaos.crypto.ECPrivateKey;
import com.phaos.crypto.ECPublicKey;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PublicKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.Signature;
import com.phaos.crypto.SignatureException;
import com.phaos.fips.FIPS_140_2;
import com.phaos.math.BigInt;
import com.phaos.math.ECException;
import com.phaos.math.ECPoint;
import com.phaos.utils.Streamable;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;

public final class ECDSA
extends Signature {
    private ECPublicKey pubKey;
    private ECPrivateKey privKey;
    private RandomBitsSource rbs;
    private MessageDigest sha;
    private byte[] hash;

    public ECDSA() {
    }

    public ECDSA(ECPrivateKey eCPrivateKey) {
        FIPS_140_2.assertReadyState();
        this.privKey = eCPrivateKey;
    }

    public ECDSA(ECPrivateKey eCPrivateKey, byte[] byArray) {
        this(eCPrivateKey);
        this.setDocument(byArray);
    }

    public ECDSA(ECPublicKey eCPublicKey) {
        FIPS_140_2.assertReadyState();
        this.pubKey = eCPublicKey;
    }

    public ECDSA(ECPublicKey eCPublicKey, byte[] byArray, byte[] byArray2) {
        this(eCPublicKey);
        this.setSigBytes(byArray);
        this.setDocument(byArray2);
    }

    public String algName() {
        return "ECDSA";
    }

    public AlgorithmIdentifier getAlgID() {
        return AlgID.ecdsaWithSHA1;
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        FIPS_140_2.assertReadyState();
        if (!algorithmIdentifier.getOID().equals(AlgID.ecdsaWithSHA1.getOID())) {
            throw new AlgorithmIdentifierException("Unknown ECDSA algorithm identifier" + algorithmIdentifier);
        }
    }

    public void setHash(byte[] byArray) {
        FIPS_140_2.assertReadyState();
        this.hash = byArray;
        this.document = null;
    }

    public void setPrivateKey(PrivateKey privateKey) throws InvalidKeyException {
        FIPS_140_2.assertReadyState();
        if (!(privateKey instanceof ECPrivateKey)) {
            throw new InvalidKeyException("Not an ECPrivateKey");
        }
        this.privKey = (ECPrivateKey)privateKey;
    }

    public void setPublicKey(PublicKey publicKey) throws InvalidKeyException {
        FIPS_140_2.assertReadyState();
        if (!(publicKey instanceof ECPublicKey)) {
            throw new InvalidKeyException("Not an ECPublicKey");
        }
        this.pubKey = (ECPublicKey)publicKey;
    }

    public void setRandomBitsSource(RandomBitsSource randomBitsSource) {
        FIPS_140_2.assertReadyState();
        this.rbs = randomBitsSource;
    }

    public byte[] sign() throws SignatureException {
        Object object;
        byte[] byArray;
        FIPS_140_2.assertReadyState();
        if (this.rbs == null) {
            this.rbs = RandomBitsSource.getDefault();
        }
        ECParams eCParams = this.privKey.getParams();
        BigInt bigInt = eCParams.getOrderInternal();
        if (this.hash != null) {
            byArray = this.hash;
        } else {
            if (this.sha == null) {
                try {
                    this.sha = MessageDigest.getInstance(AlgID.sha_1);
                }
                catch (AlgorithmIdentifierException algorithmIdentifierException) {
                    throw new RuntimeException("SHA1 class not found. " + algorithmIdentifierException.toString());
                }
            }
            if (this.getDocument() != null) {
                this.sha.init();
                this.sha.update(this.getDocument());
            }
            this.sha.computeCurrent();
            byArray = this.sha.getDigestBitsInternal();
        }
        BigInt bigInt2 = new BigInt(1, byArray);
        BigInt bigInt3 = ECC.ZERO;
        BigInt bigInt4 = ECC.ZERO;
        int n = bigInt.bitLength();
        while (bigInt4.signum() == 0) {
            BigInt bigInt5;
            while ((bigInt5 = this.rbs.randomBigInt(n)).compareTo(ECC.ONE) <= 0 || bigInt5.compareTo(bigInt) >= 0) {
            }
            object = eCParams.getBasePoint().multiply(bigInt5);
            bigInt3 = ((ECPoint)object).getX().toBigInt().mod(bigInt);
            if (bigInt3.signum() == 0) continue;
            BigInt bigInt6 = this.privKey.getDInternal();
            bigInt4 = bigInt5.modInverse(bigInt).multiply(bigInt2.add(bigInt6.multiply(bigInt3))).mod(bigInt);
        }
        object = new ASN1Sequence();
        ((ASN1Sequence)object).addElement(new ASN1Integer(bigInt3));
        ((ASN1Sequence)object).addElement(new ASN1Integer(bigInt4));
        this.setSigBytes(Utils.toBytes((Streamable)object));
        return this.getSigBytes();
    }

    public boolean verify() throws AuthenticationException {
        FIPS_140_2.assertReadyState();
        try {
            byte[] byArray;
            BigInt bigInt;
            BigInt bigInt2;
            ECParams eCParams = this.pubKey.getParams();
            BigInt bigInt3 = eCParams.getOrderInternal();
            ASN1Sequence aSN1Sequence = new ASN1Sequence(new UnsyncByteArrayInputStream(this.getSigBytes()));
            if (aSN1Sequence.size() != 2) {
                throw new AuthenticationException("Invalid signature value format");
            }
            try {
                bigInt2 = ((ASN1Integer)aSN1Sequence.elementAt(0)).getBigIntValue();
                bigInt = ((ASN1Integer)aSN1Sequence.elementAt(1)).getBigIntValue();
            }
            catch (ClassCastException classCastException) {
                throw new AuthenticationException("Invalid signature value format");
            }
            if (bigInt2.signum() <= 0 || bigInt2.compareTo(bigInt3) >= 0 || bigInt.signum() <= 0 || bigInt.compareTo(bigInt3) >= 0) {
                throw new AuthenticationException("Invalid signature format");
            }
            if (this.hash != null) {
                byArray = this.hash;
            } else {
                if (this.sha == null) {
                    try {
                        this.sha = MessageDigest.getInstance(AlgID.sha_1);
                    }
                    catch (AlgorithmIdentifierException algorithmIdentifierException) {
                        throw new RuntimeException("SHA1 class not found. " + algorithmIdentifierException.toString());
                    }
                }
                if (this.getDocument() != null) {
                    this.sha.init();
                    this.sha.update(this.getDocument());
                }
                this.sha.computeCurrent();
                byArray = this.sha.getDigestBitsInternal();
            }
            BigInt bigInt4 = bigInt.modInverse(bigInt3);
            BigInt bigInt5 = new BigInt(1, byArray).multiply(bigInt4).mod(bigInt3);
            BigInt bigInt6 = bigInt2.multiply(bigInt4).mod(bigInt3);
            ECPoint eCPoint = eCParams.getBasePoint().multiplyAndAdd(bigInt5, this.pubKey.getQ(), bigInt6);
            if (eCPoint.isPointZero()) {
                return false;
            }
            return eCPoint.getX().toBigInt().mod(bigInt3).compareTo(bigInt2) == 0;
        }
        catch (IOException iOException) {
            throw new AuthenticationException(iOException.toString());
        }
        catch (ECException eCException) {
            throw new AuthenticationException(eCException.toString());
        }
    }
}

