/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.crypto.ECParams;
import com.phaos.crypto.Key;
import com.phaos.fips.FIPS_140_2;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;

public abstract class ECKey
implements Key,
ASN1Object {
    protected ECParams params;
    protected ASN1ObjectID paramsOID;
    protected int paramsEncoding = 0;
    public static final int USE_PARAMS = 0;
    public static final int USE_PARAMS_OID = 1;
    public static final int USE_NULL = 2;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    protected ECKey() {
    }

    protected ECKey(ASN1ObjectID aSN1ObjectID) {
        this.paramsOID = aSN1ObjectID;
        this.params = ECParams.getECParams(aSN1ObjectID);
    }

    protected ECKey(ECParams eCParams) {
        this.params = eCParams;
    }

    protected ECKey(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public abstract Object clone();

    public abstract void erase();

    public String getAlgorithm() {
        return "ECC";
    }

    public abstract boolean getAllowExport();

    public int getBitLength() {
        FIPS_140_2.assertReadyState();
        if (this.params == null) {
            return 0;
        }
        return this.params.getField().getBitLength();
    }

    public abstract byte[] getEncoded();

    public abstract String getFormat();

    public ECParams getParams() {
        FIPS_140_2.assertReadyState();
        return this.params;
    }

    public ASN1ObjectID getParamsOID() {
        FIPS_140_2.assertReadyState();
        return this.paramsOID;
    }

    public abstract void input(InputStream var1) throws IOException;

    public abstract int length();

    public abstract void output(OutputStream var1) throws IOException;

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        FIPS_140_2.assertReadyState();
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    abstract void reset();

    public void setParams(ASN1ObjectID aSN1ObjectID) {
        FIPS_140_2.assertReadyState();
        this.paramsOID = aSN1ObjectID;
        this.params = ECParams.getECParams(aSN1ObjectID);
        this.reset();
    }

    public void setParams(ECParams eCParams) {
        FIPS_140_2.assertReadyState();
        this.params = eCParams;
        this.reset();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getEncoded());
    }
}

