/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.ECC;
import com.phaos.crypto.ECParams;
import com.phaos.crypto.ECPrivateKey;
import com.phaos.crypto.ECPublicKey;
import com.phaos.crypto.KeyPair;
import com.phaos.crypto.KeyPairGenerator;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.fips.FIPS_140_2;
import com.phaos.math.BigInt;
import com.phaos.math.ECPoint;

public class ECKeyPairGenerator
extends KeyPairGenerator {
    private ASN1ObjectID paramsOID;
    private ECParams params;
    private boolean initialized;

    public KeyPair generateKeyPair() {
        FIPS_140_2.assertReadyState();
        if (!this.initialized) {
            throw new IllegalStateException("The generator is not initialized.");
        }
        ECPoint eCPoint = this.params.getBasePoint();
        BigInt bigInt = this.params.getOrderInternal();
        BigInt bigInt2 = null;
        while ((bigInt2 = this.rbs.randomBigInt(bigInt.bitLength())).compareTo(ECC.ONE) <= 0 || bigInt2.compareTo(bigInt) >= 0) {
        }
        ECPoint eCPoint2 = eCPoint.multiply(bigInt2);
        ECPublicKey eCPublicKey = this.paramsOID != null ? new ECPublicKey(eCPoint2, this.paramsOID) : new ECPublicKey(eCPoint2, this.params);
        ECPrivateKey eCPrivateKey = this.paramsOID != null ? new ECPrivateKey(bigInt2, this.paramsOID) : new ECPrivateKey(bigInt2, this.params);
        FIPS_140_2.testKeyPair(eCPublicKey, eCPrivateKey);
        return new KeyPair(eCPublicKey, eCPrivateKey);
    }

    public String getAlgorithm() {
        return "ECC";
    }

    public void initialize(int n, RandomBitsSource randomBitsSource) {
        this.initialize(n, randomBitsSource, ECC.PRIME_FIELD);
    }

    public void initialize(int n, RandomBitsSource randomBitsSource, ASN1ObjectID aSN1ObjectID) {
        FIPS_140_2.assertReadyState();
        Object var4_4 = null;
        if (aSN1ObjectID.equals(ECC.PRIME_FIELD)) {
            if (n == 192) {
                this.paramsOID = ECC.prime192v1;
            } else if (n == 239) {
                this.paramsOID = ECC.prime239v1;
            } else if (n == 256) {
                this.paramsOID = ECC.prime256v1;
            }
        } else if (aSN1ObjectID == ECC.BINARY_FIELD) {
            if (n == 163) {
                this.paramsOID = ECC.c2pnb163v1;
            } else if (n == 176) {
                this.paramsOID = ECC.c2pnb176w1;
            } else if (n == 191) {
                this.paramsOID = ECC.c2tnb191v1;
            } else if (n == 208) {
                this.paramsOID = ECC.c2pnb208w1;
            } else if (n == 239) {
                this.paramsOID = ECC.c2tnb239v1;
            } else if (n == 272) {
                this.paramsOID = ECC.c2pnb272w1;
            } else if (n == 304) {
                this.paramsOID = ECC.c2pnb304w1;
            } else if (n == 359) {
                this.paramsOID = ECC.c2tnb359v1;
            } else if (n == 368) {
                this.paramsOID = ECC.c2pnb368w1;
            } else if (n == 431) {
                this.paramsOID = ECC.c2tnb431r1;
            }
        }
        if (this.paramsOID == null) {
            throw new IllegalArgumentException("Unsupported field type: " + aSN1ObjectID + " or key length " + n + " for the given type.");
        }
        this.initialize(this.paramsOID, randomBitsSource);
    }

    public void initialize(ASN1ObjectID aSN1ObjectID, RandomBitsSource randomBitsSource) {
        this.paramsOID = aSN1ObjectID;
        this.initialize(ECParams.getECParams(aSN1ObjectID), randomBitsSource);
    }

    public void initialize(ECParams eCParams, RandomBitsSource randomBitsSource) {
        FIPS_140_2.assertReadyState();
        this.params = eCParams;
        this.setRandomBitsSource(randomBitsSource);
        this.initialized = true;
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        FIPS_140_2.assertReadyState();
        if (!AlgID.ecKey.getOID().equals(algorithmIdentifier.getOID()) && !AlgID.ecdsaWithSHA1.getOID().equals(algorithmIdentifier.getOID())) {
            throw new AlgorithmIdentifierException("Unknown ECC key algorithm identifier");
        }
    }
}

