/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1BitString;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.crypto.ECC;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.fips.FIPS_140_2;
import com.phaos.math.BigInt;
import com.phaos.math.BinaryField;
import com.phaos.math.ECException;
import com.phaos.math.ECPoint;
import com.phaos.math.EllipticCurve;
import com.phaos.math.Field;
import com.phaos.math.Prime;
import com.phaos.math.PrimeField;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.Utils;
import com.phaos.utils.VersionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Hashtable;

public class ECParams
implements ASN1Object {
    private ECPoint G;
    private BigInt n;
    private BigInt h;
    private ASN1Sequence contents;
    private static Hashtable oidMap = new Hashtable();

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    ECParams(ECPoint eCPoint, BigInt bigInt, BigInt bigInt2) {
        FIPS_140_2.assertReadyState();
        this.G = eCPoint;
        this.n = bigInt;
        if (bigInt2 != null) {
            this.h = bigInt2;
        }
    }

    public ECParams(ECPoint eCPoint, BigInteger bigInteger, BigInteger bigInteger2) {
        this(eCPoint, BigInt.getInstance(bigInteger), bigInteger2 != null ? BigInt.getInstance(bigInteger2) : null);
    }

    ECParams(EllipticCurve ellipticCurve, BigInt bigInt, BigInt bigInt2, BigInt bigInt3, BigInt bigInt4) {
        this(ellipticCurve.createECPoint(bigInt, bigInt2), bigInt3, bigInt4);
    }

    public ECParams(EllipticCurve ellipticCurve, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        this(ellipticCurve.createECPoint(BigInt.getInstance(bigInteger), BigInt.getInstance(bigInteger2)), bigInteger3, bigInteger4);
    }

    ECParams(EllipticCurve ellipticCurve, byte[] byArray, BigInt bigInt, BigInt bigInt2) throws ECException {
        this(ellipticCurve.createECPoint(byArray), bigInt, bigInt2);
    }

    public ECParams(EllipticCurve ellipticCurve, byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) throws ECException {
        this(ellipticCurve.createECPoint(byArray), BigInt.getInstance(bigInteger), BigInt.getInstance(bigInteger2));
    }

    ECParams(EllipticCurve ellipticCurve, byte[] byArray, byte[] byArray2, BigInt bigInt, BigInt bigInt2) {
        this(ellipticCurve.createECPoint(byArray, byArray2), bigInt, bigInt2);
    }

    public ECParams(EllipticCurve ellipticCurve, byte[] byArray, byte[] byArray2, BigInteger bigInteger, BigInteger bigInteger2) {
        this(ellipticCurve.createECPoint(byArray, byArray2), BigInt.getInstance(bigInteger), BigInt.getInstance(bigInteger2));
    }

    ECParams(Field field, BigInt bigInt, BigInt bigInt2, byte[] byArray, BigInt bigInt3, BigInt bigInt4, BigInt bigInt5, BigInt bigInt6) throws ECException {
        this(EllipticCurve.getInstance(field, bigInt, bigInt2, byArray), bigInt3, bigInt4, bigInt5, bigInt6);
    }

    public ECParams(Field field, BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6) throws ECException {
        this(EllipticCurve.getInstance(field, BigInt.getInstance(bigInteger), BigInt.getInstance(bigInteger2), byArray), BigInt.getInstance(bigInteger3), BigInt.getInstance(bigInteger4), BigInt.getInstance(bigInteger5), BigInt.getInstance(bigInteger6));
    }

    ECParams(Field field, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, BigInt bigInt, BigInt bigInt2) throws ECException {
        this(EllipticCurve.getInstance(field, byArray, byArray2, byArray3), byArray4, bigInt, bigInt2);
    }

    public ECParams(Field field, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, BigInteger bigInteger, BigInteger bigInteger2) throws ECException {
        this(EllipticCurve.getInstance(field, byArray, byArray2, byArray3), byArray4, BigInt.getInstance(bigInteger), BigInt.getInstance(bigInteger2));
    }

    ECParams(Field field, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, BigInt bigInt, BigInt bigInt2) throws ECException {
        this(EllipticCurve.getInstance(field, byArray, byArray2, byArray3), byArray4, byArray5, bigInt, bigInt2);
    }

    public ECParams(Field field, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, BigInteger bigInteger, BigInteger bigInteger2) throws ECException {
        this(EllipticCurve.getInstance(field, byArray, byArray2, byArray3), byArray4, byArray5, BigInt.getInstance(bigInteger), BigInt.getInstance(bigInteger2));
    }

    public ECParams(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public static void addECParams(ASN1ObjectID aSN1ObjectID, ECParams eCParams) {
        FIPS_140_2.assertReadyState();
        oidMap.put(aSN1ObjectID, eCParams);
    }

    public ECPoint getBasePoint() {
        FIPS_140_2.assertReadyState();
        return this.G;
    }

    public BigInteger getCofactor() {
        return new BigInteger(this.getCofactorInternal().toByteArray());
    }

    BigInt getCofactorInternal() {
        FIPS_140_2.assertReadyState();
        return this.h;
    }

    public EllipticCurve getCurve() {
        FIPS_140_2.assertReadyState();
        return this.G.getCurve();
    }

    private static ECParams getDefaultECParams(ASN1ObjectID aSN1ObjectID) {
        ECParams eCParams = null;
        try {
            if (aSN1ObjectID.equals(ECC.prime192v1)) {
                eCParams = new ECParams((Field)new PrimeField(ECC.p_192), Utils.fromHexString("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFC"), Utils.fromHexString("64210519E59C80E70FA7E9AB72243049FEB8DEECC146B9B1"), Utils.fromHexString("3045AE6FC8422F64ED579528D38120EAE12196D5"), Utils.fromHexString("188da80eb03090f67cbf20eb43a18800f4ff0afd82ff1012"), Utils.fromHexString("07192b95ffc8da78631011ed6b24cdd573f977a11e794811"), new BigInt(1, Utils.fromHexString("FFFFFFFFFFFFFFFFFFFFFFFF99DEF836146BC9B1B4D22831")), new BigInt(1, Utils.fromHexString("01")));
            } else if (aSN1ObjectID.equals(ECC.prime192v2)) {
                eCParams = new ECParams((Field)new PrimeField(ECC.p_192), Utils.fromHexString("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFC"), Utils.fromHexString("CC22D6DFB95C6B25E49C0D6364A4E5980C393AA21668D953"), Utils.fromHexString("31A92EE2029FD10D901B113E990710F0D21AC6B6"), Utils.fromHexString("eea2bae7e1497842f2de7769cfe9c989c072ad696f48034a"), Utils.fromHexString("6574d11d69b6ec7a672bb82a083df2f2b0847de970b2de15"), new BigInt(1, Utils.fromHexString("FFFFFFFFFFFFFFFFFFFFFFFE5FB1A724DC80418648D8DD31")), new BigInt(1, Utils.fromHexString("01")));
            } else if (aSN1ObjectID.equals(ECC.prime192v3)) {
                eCParams = new ECParams((Field)new PrimeField(ECC.p_192), Utils.fromHexString("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFC"), Utils.fromHexString("22123DC2395A05CAA7423DAECCC94760A7D462256BD56916"), Utils.fromHexString("C469684435DEB378C4B65CA9591E2A5763059A2E"), Utils.fromHexString("7d29778100c65a1da1783716588dce2b8b4aee8e228f1896"), Utils.fromHexString("38a90f22637337334b49dcb66a6dc8f9978aca7648a943b0"), new BigInt(1, Utils.fromHexString("FFFFFFFFFFFFFFFFFFFFFFFF7A62D031C83F4294F640EC13")), new BigInt(1, Utils.fromHexString("01")));
            } else if (aSN1ObjectID.equals(ECC.prime239v1)) {
                eCParams = new ECParams((Field)new PrimeField(ECC.p_239), Utils.fromHexString("7FFFFFFFFFFFFFFFFFFFFFFF7FFFFFFFFFFF8000000000007FFFFFFFFFFC"), Utils.fromHexString("6B016C3BDCF18941D0D654921475CA71A9DB2FB27D1D37796185C2942C0A"), Utils.fromHexString("E43BB460F0B80CC0C0B075798E948060F8321B7D"), Utils.fromHexString("0ffa963cdca8816ccc33b8642bedf905c3d358573d3f27fbbd3b3cb9aaaf"), Utils.fromHexString("7debe8e4e90a5dae6e4054ca530ba04654b36818ce226b39fccb7b02f1ae"), new BigInt(1, Utils.fromHexString("7FFFFFFFFFFFFFFFFFFFFFFF7FFFFF9E5E9A9F5D9071FBD1522688909D0B")), new BigInt(1, Utils.fromHexString("01")));
            } else if (aSN1ObjectID.equals(ECC.prime239v2)) {
                eCParams = new ECParams((Field)new PrimeField(ECC.p_239), Utils.fromHexString("7FFFFFFFFFFFFFFFFFFFFFFF7FFFFFFFFFFF8000000000007FFFFFFFFFFC"), Utils.fromHexString("617FAB6832576CBBFED50D99F0249C3FEE58B94BA0038C7AE84C8C832F2C"), Utils.fromHexString("E8B4011604095303CA3B8099982BE09FCB9AE616"), Utils.fromHexString("38af09d98727705120c921bb5e9e26296a3cdcf2f35757a0eafd87b830e7"), Utils.fromHexString("5b0125e4dbea0ec7206da0fc01d9b081329fb555de6ef460237dff8be4ba"), new BigInt(1, Utils.fromHexString("7FFFFFFFFFFFFFFFFFFFFFFF800000CFA7E8594377D414C03821BC582063")), new BigInt(1, Utils.fromHexString("01")));
            } else if (aSN1ObjectID.equals(ECC.prime239v3)) {
                eCParams = new ECParams((Field)new PrimeField(ECC.p_239), Utils.fromHexString("7FFFFFFFFFFFFFFFFFFFFFFF7FFFFFFFFFFF8000000000007FFFFFFFFFFC"), Utils.fromHexString("255705FA2A306654B1F4CB03D6A750A30C250102D4988717D9BA15AB6D3E"), Utils.fromHexString("7D7374168FFE3471B60A857686A19475D3BFA2FF"), Utils.fromHexString("6768ae8e18bb92cfcf005c949aa2c6d94853d0e660bbf854b1c9505fe95a"), Utils.fromHexString("1607e6898f390c06bc1d552bad226f3b6fcfe48b6e818499af18e3ed6cf3"), new BigInt(1, Utils.fromHexString("7FFFFFFFFFFFFFFFFFFFFFFF7FFFFF975DEB41B3A6057C3C432146526551")), new BigInt(1, Utils.fromHexString("01")));
            } else if (aSN1ObjectID.equals(ECC.prime256v1)) {
                eCParams = new ECParams((Field)new PrimeField(ECC.p_256), Utils.fromHexString("FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFC"), Utils.fromHexString("5AC635D8AA3A93E7B3EBBD55769886BC651D06B0CC53B0F63BCE3C3E27D2604B"), Utils.fromHexString("C49D360886E704936A6678E1139D26B7819F7E90"), Utils.fromHexString("6b17d1f2e12c4247f8bce6e563a440f277037d812deb33a0f4a13945d898c296"), Utils.fromHexString("4fe342e2fe1a7f9b8ee7eb4a7c0f9e162bce33576b315ececbb6406837bf51f5"), new BigInt(1, Utils.fromHexString("FFFFFFFF00000000FFFFFFFFFFFFFFFFBCE6FAADA7179E84F3B9CAC2FC632551")), new BigInt(1, Utils.fromHexString("01")));
            } else if (aSN1ObjectID.equals(ECC.c2pnb163v1)) {
                eCParams = new ECParams((Field)new BinaryField(ECC.b_163), Utils.fromHexString("072546B5435234A422E0789675F432C89435DE5242"), Utils.fromHexString("00C9517D06D5240D3CFF38C74B20B6CD4D6F9DD4D9"), Utils.fromHexString("D2C0FB15760860DEF1EEF4D696E6768756151754"), Utils.fromHexString("07af69989546103d79329fcc3d74880f33bbe803cb"), Utils.fromHexString("01ec23211b5966adea1d3f87f7ea5848aef0b7ca9f"), new BigInt(1, Utils.fromHexString("0400000000000000000001E60FC8821CC74DAEAFC1")), new BigInt(1, Utils.fromHexString("02")));
            } else if (aSN1ObjectID.equals(ECC.c2pnb163v2)) {
                eCParams = new ECParams((Field)new BinaryField(ECC.b_163), Utils.fromHexString("0108B39E77C4B108BED981ED0E890E117C511CF072"), Utils.fromHexString("0667ACEB38AF4E488C407433FFAE4F1C811638DF20"), Utils.fromHexString("53814C050D44D696E67687561517580CA4E29FFD"), Utils.fromHexString("0024266e4eb5106d0a964d92c4860e2671db9b6cc5"), Utils.fromHexString("079f684ddf6684c5cd258b3890021b2386dfd19fc5"), new BigInt(1, Utils.fromHexString("03FFFFFFFFFFFFFFFFFFFDF64DE1151ADBB78F10A7")), new BigInt(1, Utils.fromHexString("02")));
            } else if (aSN1ObjectID.equals(ECC.c2pnb163v3)) {
                eCParams = new ECParams((Field)new BinaryField(ECC.b_163), Utils.fromHexString("07A526C63D3E25A256A007699F5447E32AE456B50E"), Utils.fromHexString("03F7061798EB99E238FD6F1BF95B48FEEB4854252B"), Utils.fromHexString("50CBF1D95CA94D696E676875615175F16A36A3B8"), Utils.fromHexString("02f9f87b7c574d0bdecf8a22e6524775f98cdebdcb"), Utils.fromHexString("05b935590c155e17ea48eb3ff3718b893df59a05d0"), new BigInt(1, Utils.fromHexString("03FFFFFFFFFFFFFFFFFFFE1AEE140F110AFF961309")), new BigInt(1, Utils.fromHexString("02")));
            } else if (aSN1ObjectID.equals(ECC.c2pnb176w1)) {
                eCParams = new ECParams((Field)new BinaryField(ECC.b_176), Utils.fromHexString("E4E6DB2995065C407D9D39B8D0967B96704BA8E9C90B"), Utils.fromHexString("5DDA470ABE6414DE8EC133AE28E9BBD7FCEC0AE0FFF2"), null, Utils.fromHexString("008d16c2866798b600f9f08bb4a8e860f3298ce04a5798"), Utils.fromHexString("006fa4539c2dadddd6bab5167d61b436e1d92bb16a562c"), new BigInt(1, Utils.fromHexString("010092537397ECA4F6145799D62B0A19CE06FE26AD")), new BigInt(1, Utils.fromHexString("FF6E")));
            } else if (aSN1ObjectID.equals(ECC.c2tnb191v1)) {
                eCParams = new ECParams((Field)new BinaryField(ECC.b_191), Utils.fromHexString("2866537B676752636A68F56554E12640276B649EF7526267"), Utils.fromHexString("2E45EF571F00786F67B0081B9495A3D95462F5DE0AA185EC"), Utils.fromHexString("4E13CA542744D696E67687561517552F279A8C84"), Utils.fromHexString("36b3daf8a23206f9c4f299d7b21a9c369137f2c84ae1aa0d"), Utils.fromHexString("765be73433b3f95e332932e70ea245ca2418ea0ef98018fb"), new BigInt(1, Utils.fromHexString("40000000000000000000000004A20E90C39067C893BBB9A5")), new BigInt(1, Utils.fromHexString("02")));
            } else if (aSN1ObjectID.equals(ECC.c2tnb191v2)) {
                eCParams = new ECParams((Field)new BinaryField(ECC.b_191), Utils.fromHexString("401028774D7777C7B7666D1366EA432071274F89FF01E718"), Utils.fromHexString("0620048D28BCBD03B6249C99182B7C8CD19700C362C46A01"), Utils.fromHexString("0871EF2FEF24D696E6768756151758BEE0D95C15"), Utils.fromHexString("3809b2b7cc1b28cc5a87926aad83fd28789e81e2c9e3bf10"), Utils.fromHexString("17434386626d14f3dbf01760d9213a3e1cf37aec437d668a"), new BigInt(1, Utils.fromHexString("20000000000000000000000050508CB89F652824E06B8173")), new BigInt(1, Utils.fromHexString("04")));
            } else if (aSN1ObjectID.equals(ECC.c2tnb191v3)) {
                eCParams = new ECParams((Field)new BinaryField(ECC.b_191), Utils.fromHexString("6C01074756099122221056911C77D77E77A777E7E7E77FCB"), Utils.fromHexString("71FE1AF926CF847989EFEF8DB459F66394D90F32AD3F15E8"), Utils.fromHexString("E053512DC684D696E676875615175067AE786D1F"), Utils.fromHexString("375d4ce24fde434489de8746e71786015009e66e38a926dd"), Utils.fromHexString("545a39176196575d985999366e6ad34ce0a77cd7127b06be"), new BigInt(1, Utils.fromHexString("155555555555555555555555610C0B196812BFB6288A3EA3")), new BigInt(1, Utils.fromHexString("06")));
            } else if (aSN1ObjectID.equals(ECC.c2pnb208w1)) {
                eCParams = new ECParams((Field)new BinaryField(ECC.b_208), Utils.fromHexString("0000000000000000000000000000000000000000000000000000"), Utils.fromHexString("C8619ED45A62E6212E1160349E2BFA844439FAFC2A3FD1638F9E"), null, Utils.fromHexString("0089fdfbe4abe193df9559ecf07ac0ce78554e2784eb8c1ed1a57a"), Utils.fromHexString("000f55b51a06e78e9ac38a035ff520d8b01781beb1a6bb08617de3"), new BigInt(1, Utils.fromHexString("0101BAF95C9723C57B6C21DA2EFF2D5ED588BDD5717E212F9D")), new BigInt(1, Utils.fromHexString("FE48")));
            } else if (aSN1ObjectID.equals(ECC.c2tnb239v1)) {
                eCParams = new ECParams((Field)new BinaryField(ECC.b_239), Utils.fromHexString("32010857077C5431123A46B808906756F543423E8D27877578125778AC76"), Utils.fromHexString("790408F2EEDAF392B012EDEFB3392F30F4327C0CA3F31FC383C422AA8C16"), Utils.fromHexString("D34B9A4D696E676875615175CA71B920BFEFB05D"), Utils.fromHexString("57927098fa932e7c0a96d3fd5b706ef7e5f5c156e16b7e7c86038552e91d"), Utils.fromHexString("61d8ee5077c33fecf6f1a16b268de469c3c7744ea9a971649fc7a9616305"), new BigInt(1, Utils.fromHexString("2000000000000000000000000000000F4D42FFE1492A4993F1CAD666E447")), new BigInt(1, Utils.fromHexString("04")));
            } else if (aSN1ObjectID.equals(ECC.c2tnb239v2)) {
                eCParams = new ECParams((Field)new BinaryField(ECC.b_239), Utils.fromHexString("4230017757A767FAE42398569B746325D45313AF0766266479B75654E65F"), Utils.fromHexString("5037EA654196CFF0CD82B2C14A2FCF2E3FF8775285B545722F03EACDB74B"), Utils.fromHexString("2AA6982FDFA4D696E676875615175D266727277D"), Utils.fromHexString("28f9d04e900069c8dc47a08534fe76d2b900b7d7ef31f5709f200c4ca205"), Utils.fromHexString("5667334c45aff3b5a03bad9dd75e2c71a99362567d5453f7fa6e227ec833"), new BigInt(1, Utils.fromHexString("1555555555555555555555555555553C6F2885259C31E3FCDF154624522D")), new BigInt(1, Utils.fromHexString("06")));
            } else if (aSN1ObjectID.equals(ECC.c2tnb239v3)) {
                eCParams = new ECParams((Field)new BinaryField(ECC.b_239), Utils.fromHexString("01238774666A67766D6676F778E676B66999176666E687666D8766C66A9F"), Utils.fromHexString("6A941977BA9F6A435199ACFC51067ED587F519C5ECB541B8E44111DE1D40"), Utils.fromHexString("9E076F4D696E676875615175E11E9FDD77F92041"), Utils.fromHexString("70f6e9d04d289c4e89913ce3530bfde903977d42b146d539bf1bde4e9c92"), Utils.fromHexString("2e5a0eaf6e5e1305b9004dce5c0ed7fe59a35608f33837c816d80b79f461"), new BigInt(1, Utils.fromHexString("0CCCCCCCCCCCCCCCCCCCCCCCCCCCCCAC4912D2D9DF903EF9888B8A0E4CFF")), new BigInt(1, Utils.fromHexString("0A")));
            } else if (aSN1ObjectID.equals(ECC.c2pnb272w1)) {
                eCParams = new ECParams((Field)new BinaryField(ECC.b_272), Utils.fromHexString("91A091F03B5FBA4AB2CCF49C4EDD220FB028712D42BE752B2C40094DBACDB586FB20"), Utils.fromHexString("7167EFC92BB2E3CE7C8AAAFF34E12A9C557003D7C73A6FAF003F99F6CC8482E540F7"), null, Utils.fromHexString("6108babb2ceebcf787058a056cbe0cfe622d7723a289e08a07ae13ef0d10d171dd8d"), Utils.fromHexString("10c7695716851eef6ba7f6872e6142fbd241b830ff5efcaceccab05e02005dde9d23"), new BigInt(1, Utils.fromHexString("0100FAF51354E0E39E4892DF6E319C72C8161603FA45AA7B998A167B8F1E629521")), new BigInt(1, Utils.fromHexString("FF06")));
            } else if (aSN1ObjectID.equals(ECC.c2pnb304w1)) {
                eCParams = new ECParams((Field)new BinaryField(ECC.b_304), Utils.fromHexString("FD0D693149A118F651E6DCE6802085377E5F882D1B510B44160074C1288078365A0396C8E681"), Utils.fromHexString("BDDB97E555A50A908E43B01C798EA5DAA6788F1EA2794EFCF57166B8C14039601E55827340BE"), null, Utils.fromHexString("04197b07845e9be2d96adb0f5f3c7f2cffbd7a3eb8b6fec35c7fd67f26ddf6285a644f740a2614e19fbeb76e0da171517ecf401b50289bf014103288527a9b416a105e80260b549fdc1b92c03b"), new BigInt(1, Utils.fromHexString("0101D556572AABAC800101D556572AABAC8001022D5C91DD173F8FB561DA6899164443051D")), new BigInt(1, Utils.fromHexString("FE2E")));
            } else if (aSN1ObjectID.equals(ECC.c2tnb359v1)) {
                eCParams = new ECParams((Field)new BinaryField(ECC.b_359), Utils.fromHexString("5667676A654B20754F356EA92017D946567C46675556F19556A04616B567D223A5E05656FB549016A96656A557"), Utils.fromHexString("2472E2D0197C49363F1FE7F5B6DB075D52B6947D135D8CA445805D39BC345626089687742B6329E70680231988"), Utils.fromHexString("2B354920B724D696E67687561517585BA1332DC6"), Utils.fromHexString("043c258ef3047767e7ede0f1fdaa79daee3841366a132e163aced4ed2401df9c6bdcde98e8e707c07a2239b1b09753d7e08529547048121e9c95f3791dd804963948f34fae7bf44ea82365dc7868fe57e4ae2de211305a407104bd"), new BigInt(1, Utils.fromHexString("01AF286BCA1AF286BCA1AF286BCA1AF286BCA1AF286BC9FB8F6B85C556892C20A7EB964FE7719E74F490758D3B")), new BigInt(1, Utils.fromHexString("4C")));
            } else if (aSN1ObjectID.equals(ECC.c2pnb368w1)) {
                eCParams = new ECParams((Field)new BinaryField(ECC.b_368), Utils.fromHexString("E0D2EE25095206F5E2A4F9ED229F1F256E79A0E2B455970D8D0D865BD94778C576D62F0AB7519CCD2A1A906AE30D"), Utils.fromHexString("FC1217D4320A90452C760A58EDCD30C8DD069B3C34453837A34ED50CB54917E1C2112D84D164F444F8F74786046A"), null, Utils.fromHexString("041085e2755381dccce3c1557afa10c2f0c0c2825646c5b34a394cbcfa8bc16b22e7e789e927be216f02e1fb136a5f7b3eb1bddcba62d5d8b2059b525797fc73822c59059c623a45ff3843cee8f87cd1855adaa81e2a0750b80fda2310"), new BigInt(1, Utils.fromHexString("010090512DA9AF72B08349D98A5DD4C7B0532ECA51CE03E2D10F3B7AC579BD87E909AE40A6F131E9CFCE5BD967")), new BigInt(1, Utils.fromHexString("FF70")));
            } else if (aSN1ObjectID.equals(ECC.c2tnb431r1)) {
                eCParams = new ECParams((Field)new BinaryField(ECC.b_431), Utils.fromHexString("1A827EF00DD6FC0E234CAF046C6A5D8A85395B236CC4AD2CF32A0CADBDC9DDF620B0EB9906D0957F6C6FEACD615468DF104DE296CD8F"), Utils.fromHexString("10D9B4A3D9047D8B154359ABFB1B7F5485B04CEB868237DDC9DEDA982A679A5A919B626D4E50A8DD731B107A9962381FB5D807BF2618"), null, Utils.fromHexString("04120fc05d3c67a99de161d2f4092622feca701be4f50f4758714e8a87bbf2a658ef8c21e7c5efe965361f6c2999c0c247b0dbd70ce6b720d0af8903a96f8d5fa2c255745d3c451b302c9346d9b7e485e7bce41f6b591f3e8f6addcbb0bc4c2f947a7de1a89b625d6a598b3760"), new BigInt(1, Utils.fromHexString("0340340340340340340340340340340340340340340340340340340323C313FAB50589703B5EC68D3587FEC60D161CC149C1AD4A91")), new BigInt(1, Utils.fromHexString("2760")));
            }
        }
        catch (ECException eCException) {
            throw new IllegalStateException(eCException.toString());
        }
        if (eCParams != null) {
            oidMap.put(aSN1ObjectID, eCParams);
        }
        return eCParams;
    }

    public static ECParams getECParams(ASN1ObjectID aSN1ObjectID) {
        FIPS_140_2.assertReadyState();
        ECParams eCParams = null;
        eCParams = oidMap.containsKey(aSN1ObjectID) ? (ECParams)oidMap.get(aSN1ObjectID) : ECParams.getDefaultECParams(aSN1ObjectID);
        if (eCParams == null) {
            throw new IllegalArgumentException("No EC parameter found for the OID." + aSN1ObjectID);
        }
        return eCParams;
    }

    public Field getField() {
        FIPS_140_2.assertReadyState();
        return this.G.getCurve().getField();
    }

    public BigInteger getOrder() {
        return new BigInteger(this.getOrderInternal().toByteArray());
    }

    BigInt getOrderInternal() {
        FIPS_140_2.assertReadyState();
        return this.n;
    }

    public void input(InputStream inputStream) throws IOException {
        FIPS_140_2.assertReadyState();
        try {
            ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
            ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.elementAt(0);
            if (!aSN1Integer.equals(1)) {
                throw new VersionException(aSN1Integer.getValue(), 0);
            }
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.elementAt(1);
            Field field = Field.getInstance(Utils.toStream(aSN1Sequence2));
            ASN1Sequence aSN1Sequence3 = (ASN1Sequence)aSN1Sequence.elementAt(2);
            byte[] byArray = ((ASN1OctetString)aSN1Sequence3.elementAt(0)).getValue();
            byte[] byArray2 = ((ASN1OctetString)aSN1Sequence3.elementAt(1)).getValue();
            byte[] byArray3 = null;
            if (aSN1Sequence3.size() == 3) {
                byArray3 = ((ASN1BitString)aSN1Sequence3.elementAt(2)).getValue();
            }
            EllipticCurve ellipticCurve = EllipticCurve.getInstance(field, byArray, byArray2, byArray3);
            this.G = ellipticCurve.createECPoint(((ASN1OctetString)aSN1Sequence.elementAt(3)).getValue());
            this.n = ((ASN1Integer)aSN1Sequence.elementAt(4)).getBigIntValue();
            if (aSN1Sequence.size() == 6) {
                this.h = ((ASN1Integer)aSN1Sequence.elementAt(5)).getBigIntValue();
            }
        }
        catch (ECException eCException) {
            throw new InvalidInputException(eCException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException.toString());
        }
    }

    public boolean isValidECParams() {
        FIPS_140_2.assertReadyState();
        Field field = this.getField();
        EllipticCurve ellipticCurve = this.getCurve();
        if (!field.isValidField()) {
            return false;
        }
        if (this.G.isPointZero()) {
            return false;
        }
        byte[] byArray = ellipticCurve.getSeed();
        if (!(byArray == null || byArray.length >= 20 && ellipticCurve.isEllipticCurveVR())) {
            return false;
        }
        if (!ellipticCurve.isNonsingular()) {
            return false;
        }
        BigInt bigInt = field.size();
        if (!Prime.isProbablePrime(this.n, 100, RandomBitsSource.getDefault()) || this.n.bitLength() < 160 || this.n.pow(2).compareTo(bigInt.shiftLeft(4)) <= 0) {
            return false;
        }
        if (!this.G.multiply(this.n).isPointZero()) {
            return false;
        }
        if (this.h != null && (this.n.multiply(this.h).subtract(bigInt.add(ECC.ONE)).pow(2).compareTo(bigInt.shiftLeft(2)) > 0 || this.n.multiply(this.h.add(ECC.ONE)).subtract(bigInt.add(ECC.ONE)).pow(2).compareTo(bigInt.shiftLeft(2)) <= 0)) {
            return false;
        }
        int n = 20;
        while (n > 0) {
            if (bigInt.pow(n).subtract(ECC.ONE).mod(this.n).signum() == 0) {
                return false;
            }
            --n;
        }
        return this.n.compareTo(bigInt) != 0;
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    public void output(OutputStream outputStream) throws IOException {
        this.toASN1Sequence().output(outputStream);
    }

    ASN1Sequence toASN1Sequence() {
        FIPS_140_2.assertReadyState();
        if (this.contents == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(new ASN1Integer(1L));
            aSN1Sequence.addElement(this.getField());
            EllipticCurve ellipticCurve = this.getCurve();
            ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
            aSN1Sequence2.addElement(new ASN1OctetString(ellipticCurve.getA().toByteArray()));
            aSN1Sequence2.addElement(new ASN1OctetString(ellipticCurve.getB().toByteArray()));
            byte[] byArray = ellipticCurve.getSeed();
            if (byArray != null) {
                aSN1Sequence2.addElement(new ASN1BitString(byArray));
            }
            aSN1Sequence.addElement(aSN1Sequence2);
            aSN1Sequence.addElement(new ASN1OctetString(this.G.toByteArray()));
            aSN1Sequence.addElement(new ASN1Integer(this.n));
            if (this.h != null) {
                aSN1Sequence.addElement(new ASN1Integer(this.h));
            }
            this.contents = aSN1Sequence;
        }
        return this.contents;
    }
}

