/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Null;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.ECC;
import com.phaos.crypto.ECKey;
import com.phaos.crypto.ECParams;
import com.phaos.crypto.PrivateKey;
import com.phaos.fips.FIPS_140_2;
import com.phaos.fips.KeyExportException;
import com.phaos.math.BigInt;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.Utils;
import com.phaos.utils.VersionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class ECPrivateKey
extends ECKey
implements PrivateKey {
    private BigInt d;
    private boolean allowExport = true;
    private byte[] pkiBytes;
    private ASN1Integer keyContents;

    public ECPrivateKey() {
    }

    ECPrivateKey(BigInt bigInt, ASN1ObjectID aSN1ObjectID) {
        super(aSN1ObjectID);
        this.d = bigInt;
    }

    ECPrivateKey(BigInt bigInt, ECParams eCParams) {
        super(eCParams);
        BigInt bigInt2 = eCParams.getOrderInternal();
        if (bigInt.compareTo(ECC.ONE) < 0 || bigInt.compareTo(bigInt2) >= 0) {
            throw new IllegalArgumentException("Invalid private key value");
        }
        this.d = bigInt;
    }

    public ECPrivateKey(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public ECPrivateKey(BigInteger bigInteger, ASN1ObjectID aSN1ObjectID) {
        this(BigInt.getInstance(bigInteger), aSN1ObjectID);
    }

    public ECPrivateKey(BigInteger bigInteger, ECParams eCParams) {
        this(BigInt.getInstance(bigInteger), eCParams);
    }

    private void assertAllowExport() {
        if (!this.getAllowExport() || !FIPS_140_2.getAllowKeyExport()) {
            throw new KeyExportException("Plaintext key export not allowed");
        }
    }

    public Object clone() {
        FIPS_140_2.assertReadyState();
        ECPrivateKey eCPrivateKey = new ECPrivateKey();
        try {
            if (this.paramsOID != null) {
                eCPrivateKey.paramsOID = new ASN1ObjectID(Utils.toStream(this.paramsOID));
            }
            if (this.params != null) {
                eCPrivateKey.params = new ECParams(Utils.toStream(this.params));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing key EC parameters to stream");
        }
        if (this.d != null) {
            eCPrivateKey.d = BigInt.getInstance(this.d);
        }
        eCPrivateKey.allowExport = this.allowExport;
        return eCPrivateKey;
    }

    public void erase() {
        this.params = null;
        if (this.d != null) {
            this.d.erase();
            this.d = null;
        }
        this.eraseCache();
    }

    private void eraseCache() {
        if (this.pkiBytes != null) {
            Utils.setArray(this.pkiBytes, (byte)0);
            this.pkiBytes = null;
        }
        if (this.keyContents != null) {
            this.keyContents.erase();
            this.keyContents = null;
        }
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        return new AlgorithmIdentifier(AlgID.ecKey.getOID(), this.params);
    }

    public boolean getAllowExport() {
        return this.allowExport;
    }

    public ASN1Object getContents() {
        this.assertAllowExport();
        FIPS_140_2.assertReadyState();
        return new ASN1Integer(this.d);
    }

    ASN1Object getContentsInternal() {
        FIPS_140_2.assertReadyState();
        if (this.keyContents == null) {
            this.keyContents = new ASN1Integer(this.d);
        }
        return this.keyContents;
    }

    public BigInteger getD() {
        this.assertAllowExport();
        return new BigInteger(this.getDInternal().toByteArray());
    }

    BigInt getDInternal() {
        FIPS_140_2.assertReadyState();
        return this.d;
    }

    public byte[] getEncoded() {
        this.assertAllowExport();
        return (byte[])this.getEncodedInternal().clone();
    }

    byte[] getEncodedInternal() {
        return this.privateKeyInfo(this.paramsEncoding);
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws AlgorithmIdentifierException, InvalidInputException {
        FIPS_140_2.assertReadyState();
        if (!AlgID.ecKey.getOID().equals(algorithmIdentifier.getOID())) {
            throw new AlgorithmIdentifierException("Wrong algorithm identifier for EC key");
        }
        try {
            ASN1Object aSN1Object2 = algorithmIdentifier.getParameters();
            if (aSN1Object2 != null || !(aSN1Object2 instanceof ASN1Null)) {
                if (aSN1Object2 instanceof ASN1ObjectID) {
                    this.paramsOID = (ASN1ObjectID)aSN1Object2;
                    this.params = ECParams.getECParams(this.paramsOID);
                } else {
                    this.params = aSN1Object2 instanceof ECParams ? (ECParams)aSN1Object2 : new ECParams(Utils.toStream((ASN1Sequence)aSN1Object2));
                }
            }
        }
        catch (IOException iOException) {
            throw new AlgorithmIdentifierException("Invalid EC parameters.");
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Invalid EC parameters.");
        }
        try {
            this.d = ((ASN1Integer)aSN1Object).getBigIntValue();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException("Contents invalid.");
        }
        this.reset();
    }

    public void input(InputStream inputStream) throws IOException {
        FIPS_140_2.assertReadyState();
        try {
            ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
            ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.elementAt(0);
            if (!aSN1Integer.equals(0)) {
                throw new VersionException(aSN1Integer.getValue(), 0);
            }
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.elementAt(1));
            ASN1Object aSN1Object = ASN1Utils.inputASN1Object(((ASN1OctetString)aSN1Sequence.elementAt(2)).getValue());
            this.initialize(algorithmIdentifier, aSN1Object);
            ((ASN1Integer)aSN1Object).erase();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new InvalidInputException(algorithmIdentifierException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException.toString());
        }
    }

    public int length() {
        return this.getEncodedInternal().length;
    }

    public void output(OutputStream outputStream) throws IOException {
        this.output(outputStream, 0);
    }

    public void output(OutputStream outputStream, int n) throws IOException {
        this.assertAllowExport();
        outputStream.write(this.privateKeyInfo(n));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] privateKeyInfo(int n) {
        void var3_6;
        FIPS_140_2.assertReadyState();
        if (this.pkiBytes != null && this.paramsEncoding == n) return this.pkiBytes;
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1Integer(0L));
        Object var3_3 = null;
        if (n == 0) {
            ASN1Sequence aSN1Sequence2 = this.params.toASN1Sequence();
        } else if (n == 1) {
            if (this.paramsOID == null) throw new IllegalArgumentException("No parameter OID set for the ECParams.");
            ASN1ObjectID aSN1ObjectID = this.paramsOID;
        } else if (n != 2) {
            throw new IllegalArgumentException("Unknown parameters encoding: " + n);
        }
        aSN1Sequence.addElement(new AlgorithmIdentifier(AlgID.ecKey.getOID(), (ASN1Object)var3_6));
        aSN1Sequence.addElement(new ASN1OctetString(Utils.toBytes(this.getContentsInternal())));
        this.paramsEncoding = n;
        this.pkiBytes = Utils.toBytes(aSN1Sequence);
        return this.pkiBytes;
    }

    void reset() {
        this.eraseCache();
    }

    public void setAllowExport(boolean bl) {
        this.allowExport = bl;
    }

    public String toString() {
        FIPS_140_2.assertReadyState();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        stringBuffer.append("params=");
        stringBuffer.append(String.valueOf(this.params));
        stringBuffer.append(", ");
        stringBuffer.append("bitLength=");
        stringBuffer.append(this.getBitLength());
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

