/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1BitString;
import com.phaos.ASN1.ASN1Null;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.ECKey;
import com.phaos.crypto.ECParams;
import com.phaos.crypto.PublicKey;
import com.phaos.fips.FIPS_140_2;
import com.phaos.math.ECPoint;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ECPublicKey
extends ECKey
implements PublicKey {
    private ECPoint Q;
    private byte[] spkiBytes;

    public ECPublicKey() {
    }

    public ECPublicKey(ECPoint eCPoint, ASN1ObjectID aSN1ObjectID) {
        super(aSN1ObjectID);
        this.Q = eCPoint;
    }

    public ECPublicKey(ECPoint eCPoint, ECParams eCParams) {
        super(eCParams);
        if (!eCPoint.getCurve().equals(eCParams.getCurve())) {
            throw new IllegalArgumentException("Q and params on different curves");
        }
        this.Q = eCPoint;
    }

    public ECPublicKey(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public Object clone() {
        FIPS_140_2.assertReadyState();
        ECPublicKey eCPublicKey = new ECPublicKey();
        try {
            if (this.paramsOID != null) {
                eCPublicKey.paramsOID = new ASN1ObjectID(Utils.toStream(this.paramsOID));
            }
            if (this.params != null) {
                eCPublicKey.params = new ECParams(Utils.toStream(this.params));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing key EC parameters to stream");
        }
        if (this.Q != null) {
            eCPublicKey.Q = this.params.getCurve().createECPoint(this.Q.toByteArray());
        }
        return eCPublicKey;
    }

    public void erase() {
        this.params = null;
        this.Q = null;
        this.reset();
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        return new AlgorithmIdentifier(AlgID.ecKey.getOID(), this.params);
    }

    public boolean getAllowExport() {
        return true;
    }

    public ASN1Object getContents() {
        FIPS_140_2.assertReadyState();
        return new ASN1OctetString(this.Q.toByteArray());
    }

    public byte[] getEncoded() {
        return this.subjectPublicKeyInfo(this.paramsEncoding);
    }

    public String getFormat() {
        return "X.509";
    }

    public ECPoint getQ() {
        FIPS_140_2.assertReadyState();
        return this.Q;
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws AlgorithmIdentifierException, InvalidInputException {
        FIPS_140_2.assertReadyState();
        if (!AlgID.ecKey.getOID().equals(algorithmIdentifier.getOID())) {
            throw new AlgorithmIdentifierException("Wrong algorithm identifier for EC key.");
        }
        try {
            ASN1Object aSN1Object2 = algorithmIdentifier.getParameters();
            if (aSN1Object2 != null || !(aSN1Object2 instanceof ASN1Null)) {
                if (aSN1Object2 instanceof ASN1ObjectID) {
                    this.paramsOID = (ASN1ObjectID)aSN1Object2;
                    this.params = ECParams.getECParams(this.paramsOID);
                } else {
                    this.params = aSN1Object2 instanceof ECParams ? (ECParams)aSN1Object2 : new ECParams(Utils.toStream((ASN1Sequence)aSN1Object2));
                }
            }
        }
        catch (IOException iOException) {
            throw new AlgorithmIdentifierException("Invalid EC parameters.");
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Invalid EC parameters.");
        }
        try {
            this.Q = this.params.getCurve().createECPoint(((ASN1OctetString)aSN1Object).getValue());
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException("Contents invalid.");
        }
        this.reset();
    }

    public void input(InputStream inputStream) throws IOException {
        FIPS_140_2.assertReadyState();
        ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.elementAt(0));
            ASN1Object aSN1Object = ASN1Utils.inputASN1Object(((ASN1BitString)aSN1Sequence.elementAt(1)).getValue());
            this.initialize(algorithmIdentifier, aSN1Object);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new InvalidInputException(algorithmIdentifierException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException.toString());
        }
    }

    public int length() {
        return this.getEncoded().length;
    }

    public void output(OutputStream outputStream) throws IOException {
        this.output(outputStream, 0);
    }

    public void output(OutputStream outputStream, int n) throws IOException {
        outputStream.write(this.subjectPublicKeyInfo(n));
    }

    void reset() {
        this.spkiBytes = null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] subjectPublicKeyInfo(int n) {
        void var3_6;
        FIPS_140_2.assertReadyState();
        if (this.spkiBytes != null && this.paramsEncoding == n) return this.spkiBytes;
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        Object var3_3 = null;
        if (n == 0) {
            ASN1Sequence aSN1Sequence2 = this.params.toASN1Sequence();
        } else if (n == 1) {
            if (this.paramsOID == null) throw new IllegalArgumentException("No parameter OID set for the ECParams.");
            ASN1ObjectID aSN1ObjectID = this.paramsOID;
        } else if (n != 2) {
            throw new IllegalArgumentException("Unknown parameters encoding: " + n);
        }
        aSN1Sequence.addElement(new AlgorithmIdentifier(AlgID.ecKey.getOID(), (ASN1Object)var3_6));
        aSN1Sequence.addElement(new ASN1BitString(Utils.toBytes(this.getContents())));
        this.paramsEncoding = n;
        this.spkiBytes = Utils.toBytes(aSN1Sequence);
        return this.spkiBytes;
    }

    public String toString() {
        FIPS_140_2.assertReadyState();
        return "params = {" + this.params + "}, Q = " + this.Q;
    }
}

