/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.SREntropySource;
import com.phaos.fips.FIPS_140_2;

public abstract class EntropySource {
    private static EntropySource defaultEntropySource;
    private static final Object obj;

    static {
        obj = new Object();
        FIPS_140_2.powerUpSelfTest();
    }

    protected EntropySource() {
    }

    public abstract void clear();

    public abstract byte generateByte();

    public synchronized byte[] generateBytes(byte[] byArray) {
        FIPS_140_2.assertReadyState();
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = this.generateByte();
            ++n;
        }
        return byArray;
    }

    public static EntropySource getDefault() {
        FIPS_140_2.assertReadyState();
        if (defaultEntropySource == null) {
            Object object = obj;
            synchronized (object) {
                if (defaultEntropySource == null) {
                    defaultEntropySource = new SREntropySource();
                }
            }
        }
        return defaultEntropySource;
    }

    public static void setDefault(EntropySource entropySource) {
        FIPS_140_2.assertReadyState();
        Object object = obj;
        synchronized (object) {
            defaultEntropySource = entropySource;
        }
    }
}

