/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.MAC;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.SymmetricKey;
import com.phaos.fips.FIPS_140_2;
import com.phaos.utils.Utils;

public final class HMAC
extends MAC {
    private AlgorithmIdentifier hashAlgID;
    private SymmetricKey symKey;
    private byte[] key;
    private byte[] ipad;
    private byte[] opad;
    private int keyOff;
    private int keyLen;
    private MessageDigest iHash;
    private MessageDigest oHash;
    private MessageDigest.MDState iState;
    private MessageDigest.MDState oState;

    public HMAC() {
    }

    public HMAC(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey) throws AlgorithmIdentifierException {
        this.symKey = symmetricKey;
        this.key = (byte[])symmetricKey.getBytesInternal().clone();
        this.keyOff = 0;
        this.keyLen = this.key.length;
        this.iHash = MessageDigest.getInstance(algorithmIdentifier);
        this.oHash = MessageDigest.getInstance(algorithmIdentifier);
        this.initialize();
    }

    public HMAC(AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws AlgorithmIdentifierException {
        this(algorithmIdentifier, byArray, 0, byArray.length);
    }

    public HMAC(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, int n, int n2) throws AlgorithmIdentifierException {
        this.key = (byte[])byArray.clone();
        this.keyOff = n;
        this.keyLen = n2;
        this.iHash = MessageDigest.getInstance(algorithmIdentifier);
        this.oHash = MessageDigest.getInstance(algorithmIdentifier);
        this.initialize();
    }

    private HMAC(byte[] byArray, int n, int n2) {
        FIPS_140_2.assertReadyState();
        this.key = (byte[])byArray.clone();
        this.keyOff = n;
        this.keyLen = n2;
    }

    public String algName() {
        return "HMAC-" + this.oHash.algName();
    }

    public int blockSize() {
        return this.iHash.blockSize();
    }

    public Object clone() {
        HMAC hMAC = new HMAC(this.key, this.keyOff, this.keyLen);
        hMAC.iHash = (MessageDigest)this.iHash.clone();
        hMAC.oHash = (MessageDigest)this.oHash.clone();
        hMAC.iState = (MessageDigest.MDState)this.iState.clone();
        hMAC.oState = (MessageDigest.MDState)this.oState.clone();
        hMAC.ipad = (byte[])this.ipad.clone();
        hMAC.opad = (byte[])this.opad.clone();
        hMAC.digestBits = (byte[])this.digestBits.clone();
        hMAC.digestValid = this.digestValid;
        return hMAC;
    }

    public void computeCurrent() {
        MessageDigest messageDigest = (MessageDigest)this.iHash.clone();
        this.iHash.computeCurrent();
        this.oHash.update(this.iHash.getDigestBitsInternal());
        this.oHash.computeCurrent();
        System.arraycopy(this.oHash.getDigestBitsInternal(), 0, this.digestBits, 0, this.digestBits.length);
        this.digestValid = true;
        this.iHash = messageDigest;
        this.oHash.setState(this.oState);
    }

    public void erase() {
        this.symKey = null;
        if (this.key != null) {
            Utils.setArray(this.key, (byte)0);
            this.key = null;
        }
    }

    public void finalize() {
        this.erase();
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        return this.algID;
    }

    public int getDigestLength() {
        return this.oHash.getDigestLength();
    }

    protected MessageDigest.MDState getState() {
        return null;
    }

    public void init() {
        this.iHash.setState(this.iState);
        this.oHash.setState(this.oState);
        this.digestValid = false;
    }

    private void initialize() {
        byte[] byArray;
        int n = this.iHash.blockSize();
        int n2 = this.oHash.getDigestLength();
        if (this.keyLen > n) {
            this.iHash.init();
            this.iHash.update(this.key, this.keyOff, this.keyLen);
            this.iHash.computeCurrent();
            byArray = this.iHash.getDigestBitsInternal();
            this.iHash.init();
        } else {
            byArray = new byte[this.keyLen];
            System.arraycopy(this.key, this.keyOff, byArray, 0, this.keyLen);
        }
        this.digestBits = new byte[n2];
        this.ipad = new byte[n];
        this.opad = new byte[n];
        Utils.setArray(this.ipad, (byte)54);
        Utils.setArray(this.opad, (byte)92);
        int n3 = 0;
        int n4 = 0;
        while (n3 < byArray.length) {
            int n5 = n3;
            this.ipad[n5] = (byte)(this.ipad[n5] ^ byArray[n4]);
            int n6 = n3++;
            this.opad[n6] = (byte)(this.opad[n6] ^ byArray[n4]);
            ++n4;
        }
        this.iHash.update(this.ipad);
        this.iHash.computeCurrent();
        this.oHash.update(this.opad);
        this.oHash.computeCurrent();
        this.iState = (MessageDigest.MDState)this.iHash.getState().clone();
        this.oState = (MessageDigest.MDState)this.oHash.getState().clone();
        this.digestValid = false;
        Utils.setArray(byArray, (byte)0);
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey) throws AlgorithmIdentifierException {
        FIPS_140_2.assertReadyState();
        if (algorithmIdentifier.getOID().equals(AlgID.hmacMD5.getOID())) {
            this.hashAlgID = AlgID.md5;
        } else if (algorithmIdentifier.getOID().equals(AlgID.hmacSHA.getOID())) {
            this.hashAlgID = AlgID.sha1;
        } else {
            throw new AlgorithmIdentifierException("Unrecognized algorithm identifier for HMAC: " + algorithmIdentifier.toString());
        }
        this.iHash = MessageDigest.getInstance(this.hashAlgID);
        this.oHash = MessageDigest.getInstance(this.hashAlgID);
        if (symmetricKey == null) {
            this.key = new byte[0];
            this.keyOff = 0;
            this.keyLen = 0;
        } else {
            this.key = (byte[])symmetricKey.getBytesInternal().clone();
            this.keyOff = 0;
            this.keyLen = this.key.length;
        }
        this.symKey = symmetricKey;
        this.initialize();
        this.algID = algorithmIdentifier;
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        FIPS_140_2.assertReadyState();
        if (algorithmIdentifier.getOID().equals(AlgID.hmacMD5.getOID())) {
            this.hashAlgID = AlgID.md5;
        } else if (algorithmIdentifier.getOID().equals(AlgID.hmacSHA.getOID())) {
            this.hashAlgID = AlgID.sha1;
        } else {
            throw new AlgorithmIdentifierException("Unrecognized algorithm identifier for HMAC: " + algorithmIdentifier.toString());
        }
        this.iHash = MessageDigest.getInstance(this.hashAlgID);
        this.oHash = MessageDigest.getInstance(this.hashAlgID);
        if (this.key == null) {
            this.key = new byte[0];
            this.keyOff = 0;
            this.keyLen = 0;
        } else {
            this.initialize();
        }
        this.algID = algorithmIdentifier;
    }

    public void setKey(byte[] byArray) {
        this.setKey(byArray, 0, byArray.length);
    }

    public void setKey(byte[] byArray, int n, int n2) {
        FIPS_140_2.assertReadyState();
        this.key = (byte[])byArray.clone();
        this.keyOff = n;
        this.keyLen = n2;
        this.initialize();
    }

    protected void setState(MessageDigest.MDState mDState) {
        throw new RuntimeException("setState not valid for HMAC class");
    }

    public void update(byte by) {
        this.iHash.update(by);
        this.digestValid = false;
    }

    public void update(byte[] byArray, int n, int n2) {
        this.iHash.update(byArray, n, n2);
        this.digestValid = false;
    }
}

