/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PublicKey;
import com.phaos.fips.FIPS_140_2;
import com.phaos.utils.CryptoUtils;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class KeyPair
implements Externalizable {
    private PublicKey publicKey;
    private PrivateKey privateKey;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    public KeyPair() {
    }

    public KeyPair(PublicKey publicKey, PrivateKey privateKey) {
        FIPS_140_2.assertReadyState();
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public PrivateKey getPrivate() {
        FIPS_140_2.assertReadyState();
        return this.privateKey;
    }

    public PublicKey getPublic() {
        FIPS_140_2.assertReadyState();
        return this.publicKey;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        FIPS_140_2.assertReadyState();
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(new UnsyncByteArrayInputStream(byArray));
        this.publicKey = CryptoUtils.inputSPKI(aSN1SequenceInputStream);
        this.privateKey = CryptoUtils.inputPrivateKey(aSN1SequenceInputStream);
        aSN1SequenceInputStream.terminate();
    }

    public void setPrivate(PrivateKey privateKey) {
        FIPS_140_2.assertReadyState();
        this.privateKey = privateKey;
    }

    public void setPublic(PublicKey publicKey) {
        FIPS_140_2.assertReadyState();
        this.publicKey = publicKey;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        FIPS_140_2.assertReadyState();
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(this.publicKey);
        aSN1Sequence.addElement(this.privateKey);
        objectOutput.writeObject(Utils.toBytes(aSN1Sequence));
    }
}

