/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.DHPrivateKey;
import com.phaos.crypto.DSAPrivateKey;
import com.phaos.crypto.ECPrivateKey;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PrivateKeyPKCS8;
import com.phaos.crypto.RSAPrivateKey;
import com.phaos.fips.FIPS_140_2;
import com.phaos.fips.KeyExportException;

final class KeyUtils {
    static {
        FIPS_140_2.powerUpSelfTest();
    }

    KeyUtils() {
    }

    public static byte[] getEncodedInternal(PrivateKey privateKey) {
        if (privateKey instanceof RSAPrivateKey) {
            return ((RSAPrivateKey)privateKey).getEncodedInternal();
        }
        if (privateKey instanceof DSAPrivateKey) {
            return ((DSAPrivateKey)privateKey).getEncodedInternal();
        }
        if (privateKey instanceof DHPrivateKey) {
            return ((DHPrivateKey)privateKey).getEncodedInternal();
        }
        if (privateKey instanceof ECPrivateKey) {
            return ((ECPrivateKey)privateKey).getEncodedInternal();
        }
        if (privateKey instanceof PrivateKeyPKCS8) {
            return ((PrivateKeyPKCS8)privateKey).getEncoded();
        }
        throw new KeyExportException("Unsupported private key type " + privateKey.getAlgorithm());
    }
}

