/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.SymmetricKey;
import com.phaos.fips.FIPS_140_2;
import com.phaos.utils.OIDManager;
import com.phaos.utils.Utils;

public abstract class MAC
extends MessageDigest {
    protected MAC() {
    }

    public byte[] computeMAC() {
        this.computeCurrent();
        return this.getDigestBits();
    }

    public byte[] computeMAC(byte[] byArray) {
        this.init();
        return this.computeDigest(byArray);
    }

    public abstract void erase();

    public static MAC getInstance(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey) throws AlgorithmIdentifierException {
        MAC mAC;
        FIPS_140_2.assertReadyState();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "mac");
        if (clazz == null) {
            throw new AlgorithmIdentifierException("No class found for " + algorithmIdentifier.getOID());
        }
        try {
            mAC = (MAC)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Class does not implement MAC.");
        }
        mAC.initialize(algorithmIdentifier, symmetricKey);
        return mAC;
    }

    public abstract void initialize(AlgorithmIdentifier var1, SymmetricKey var2) throws AlgorithmIdentifierException;

    public boolean verifyMAC(byte[] byArray) {
        this.computeCurrent();
        return Utils.areEqual(this.getDigestBits(), byArray);
    }

    public boolean verifyMAC(byte[] byArray, byte[] byArray2) {
        this.init();
        return Utils.areEqual(this.computeDigest(byArray), byArray2);
    }
}

