/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.MessageDigest;
import com.phaos.fips.FIPS_140_2;

public final class MD2
extends MessageDigest {
    private MD2State state = new MD2State();
    private static final byte[] INIT_BUF = new byte[16];
    private static final int[] S;

    static {
        int[] nArray = new int[256];
        nArray[0] = 41;
        nArray[1] = 46;
        nArray[2] = 67;
        nArray[3] = 201;
        nArray[4] = 162;
        nArray[5] = 216;
        nArray[6] = 124;
        nArray[7] = 1;
        nArray[8] = 61;
        nArray[9] = 54;
        nArray[10] = 84;
        nArray[11] = 161;
        nArray[12] = 236;
        nArray[13] = 240;
        nArray[14] = 6;
        nArray[15] = 19;
        nArray[16] = 98;
        nArray[17] = 167;
        nArray[18] = 5;
        nArray[19] = 243;
        nArray[20] = 192;
        nArray[21] = 199;
        nArray[22] = 115;
        nArray[23] = 140;
        nArray[24] = 152;
        nArray[25] = 147;
        nArray[26] = 43;
        nArray[27] = 217;
        nArray[28] = 188;
        nArray[29] = 76;
        nArray[30] = 130;
        nArray[31] = 202;
        nArray[32] = 30;
        nArray[33] = 155;
        nArray[34] = 87;
        nArray[35] = 60;
        nArray[36] = 253;
        nArray[37] = 212;
        nArray[38] = 224;
        nArray[39] = 22;
        nArray[40] = 103;
        nArray[41] = 66;
        nArray[42] = 111;
        nArray[43] = 24;
        nArray[44] = 138;
        nArray[45] = 23;
        nArray[46] = 229;
        nArray[47] = 18;
        nArray[48] = 190;
        nArray[49] = 78;
        nArray[50] = 196;
        nArray[51] = 214;
        nArray[52] = 218;
        nArray[53] = 158;
        nArray[54] = 222;
        nArray[55] = 73;
        nArray[56] = 160;
        nArray[57] = 251;
        nArray[58] = 245;
        nArray[59] = 142;
        nArray[60] = 187;
        nArray[61] = 47;
        nArray[62] = 238;
        nArray[63] = 122;
        nArray[64] = 169;
        nArray[65] = 104;
        nArray[66] = 121;
        nArray[67] = 145;
        nArray[68] = 21;
        nArray[69] = 178;
        nArray[70] = 7;
        nArray[71] = 63;
        nArray[72] = 148;
        nArray[73] = 194;
        nArray[74] = 16;
        nArray[75] = 137;
        nArray[76] = 11;
        nArray[77] = 34;
        nArray[78] = 95;
        nArray[79] = 33;
        nArray[80] = 128;
        nArray[81] = 127;
        nArray[82] = 93;
        nArray[83] = 154;
        nArray[84] = 90;
        nArray[85] = 144;
        nArray[86] = 50;
        nArray[87] = 39;
        nArray[88] = 53;
        nArray[89] = 62;
        nArray[90] = 204;
        nArray[91] = 231;
        nArray[92] = 191;
        nArray[93] = 247;
        nArray[94] = 151;
        nArray[95] = 3;
        nArray[96] = 255;
        nArray[97] = 25;
        nArray[98] = 48;
        nArray[99] = 179;
        nArray[100] = 72;
        nArray[101] = 165;
        nArray[102] = 181;
        nArray[103] = 209;
        nArray[104] = 215;
        nArray[105] = 94;
        nArray[106] = 146;
        nArray[107] = 42;
        nArray[108] = 172;
        nArray[109] = 86;
        nArray[110] = 170;
        nArray[111] = 198;
        nArray[112] = 79;
        nArray[113] = 184;
        nArray[114] = 56;
        nArray[115] = 210;
        nArray[116] = 150;
        nArray[117] = 164;
        nArray[118] = 125;
        nArray[119] = 182;
        nArray[120] = 118;
        nArray[121] = 252;
        nArray[122] = 107;
        nArray[123] = 226;
        nArray[124] = 156;
        nArray[125] = 116;
        nArray[126] = 4;
        nArray[127] = 241;
        nArray[128] = 69;
        nArray[129] = 157;
        nArray[130] = 112;
        nArray[131] = 89;
        nArray[132] = 100;
        nArray[133] = 113;
        nArray[134] = 135;
        nArray[135] = 32;
        nArray[136] = 134;
        nArray[137] = 91;
        nArray[138] = 207;
        nArray[139] = 101;
        nArray[140] = 230;
        nArray[141] = 45;
        nArray[142] = 168;
        nArray[143] = 2;
        nArray[144] = 27;
        nArray[145] = 96;
        nArray[146] = 37;
        nArray[147] = 173;
        nArray[148] = 174;
        nArray[149] = 176;
        nArray[150] = 185;
        nArray[151] = 246;
        nArray[152] = 28;
        nArray[153] = 70;
        nArray[154] = 97;
        nArray[155] = 105;
        nArray[156] = 52;
        nArray[157] = 64;
        nArray[158] = 126;
        nArray[159] = 15;
        nArray[160] = 85;
        nArray[161] = 71;
        nArray[162] = 163;
        nArray[163] = 35;
        nArray[164] = 221;
        nArray[165] = 81;
        nArray[166] = 175;
        nArray[167] = 58;
        nArray[168] = 195;
        nArray[169] = 92;
        nArray[170] = 249;
        nArray[171] = 206;
        nArray[172] = 186;
        nArray[173] = 197;
        nArray[174] = 234;
        nArray[175] = 38;
        nArray[176] = 44;
        nArray[177] = 83;
        nArray[178] = 13;
        nArray[179] = 110;
        nArray[180] = 133;
        nArray[181] = 40;
        nArray[182] = 132;
        nArray[183] = 9;
        nArray[184] = 211;
        nArray[185] = 223;
        nArray[186] = 205;
        nArray[187] = 244;
        nArray[188] = 65;
        nArray[189] = 129;
        nArray[190] = 77;
        nArray[191] = 82;
        nArray[192] = 106;
        nArray[193] = 220;
        nArray[194] = 55;
        nArray[195] = 200;
        nArray[196] = 108;
        nArray[197] = 193;
        nArray[198] = 171;
        nArray[199] = 250;
        nArray[200] = 36;
        nArray[201] = 225;
        nArray[202] = 123;
        nArray[203] = 8;
        nArray[204] = 12;
        nArray[205] = 189;
        nArray[206] = 177;
        nArray[207] = 74;
        nArray[208] = 120;
        nArray[209] = 136;
        nArray[210] = 149;
        nArray[211] = 139;
        nArray[212] = 227;
        nArray[213] = 99;
        nArray[214] = 232;
        nArray[215] = 109;
        nArray[216] = 233;
        nArray[217] = 203;
        nArray[218] = 213;
        nArray[219] = 254;
        nArray[220] = 59;
        nArray[222] = 29;
        nArray[223] = 57;
        nArray[224] = 242;
        nArray[225] = 239;
        nArray[226] = 183;
        nArray[227] = 14;
        nArray[228] = 102;
        nArray[229] = 88;
        nArray[230] = 208;
        nArray[231] = 228;
        nArray[232] = 166;
        nArray[233] = 119;
        nArray[234] = 114;
        nArray[235] = 248;
        nArray[236] = 235;
        nArray[237] = 117;
        nArray[238] = 75;
        nArray[239] = 10;
        nArray[240] = 49;
        nArray[241] = 68;
        nArray[242] = 80;
        nArray[243] = 180;
        nArray[244] = 143;
        nArray[245] = 237;
        nArray[246] = 31;
        nArray[247] = 26;
        nArray[248] = 219;
        nArray[249] = 153;
        nArray[250] = 141;
        nArray[251] = 51;
        nArray[252] = 159;
        nArray[253] = 17;
        nArray[254] = 131;
        nArray[255] = 20;
        S = nArray;
    }

    public MD2() {
        this.digestBits = new byte[16];
        this.digestValid = false;
    }

    public String algName() {
        return "MD2";
    }

    public int blockSize() {
        return 64;
    }

    public Object clone() {
        FIPS_140_2.assertReadyState();
        MD2 mD2 = new MD2();
        mD2.state = (MD2State)this.state.clone();
        System.arraycopy(this.digestBits, 0, mD2.digestBits, 0, this.digestBits.length);
        mD2.digestValid = this.digestValid;
        return mD2;
    }

    public void computeCurrent() {
        FIPS_140_2.assertReadyState();
        MD2State mD2State = (MD2State)this.state.clone();
        int n = 16 - this.state.count;
        int n2 = 0;
        while (n2 < n) {
            this.update((byte)n);
            ++n2;
        }
        byte[] byArray = new byte[16];
        System.arraycopy(this.state.checksum, 0, byArray, 0, 16);
        this.update(byArray);
        System.arraycopy(this.state.state, 0, this.digestBits, 0, 16);
        this.state = mD2State;
        this.digestValid = true;
    }

    public AlgorithmIdentifier getAlgID() {
        return AlgID.md2;
    }

    public int getDigestLength() {
        return 16;
    }

    protected MessageDigest.MDState getState() {
        return this.state;
    }

    public void init() {
        FIPS_140_2.assertReadyState();
        if (this.state != null) {
            this.state.init();
        }
        this.digestValid = false;
    }

    protected void setState(MessageDigest.MDState mDState) {
        mDState.copyTo(this.state);
        this.digestValid = false;
    }

    private void transform() {
        int n;
        byte[] byArray = new byte[48];
        System.arraycopy(this.state.state, 0, byArray, 0, 16);
        System.arraycopy(this.state.buffer, 0, byArray, 16, 16);
        int n2 = 0;
        while (n2 < 16) {
            byArray[n2 + 32] = (byte)(this.state.state[n2] ^ this.state.buffer[n2]);
            ++n2;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < 18) {
            n = 0;
            while (n < 48) {
                int n5 = n;
                byArray[n5] = (byte)(byArray[n5] ^ S[n3]);
                n3 = byArray[n] & 0xFF;
                ++n;
            }
            n3 = n3 + n4 & 0xFF;
            ++n4;
        }
        System.arraycopy(byArray, 0, this.state.state, 0, 16);
        n3 = this.state.checksum[15] & 0xFF;
        n = 0;
        while (n < 16) {
            int n6 = n;
            this.state.checksum[n6] = (byte)(this.state.checksum[n6] ^ S[this.state.buffer[n] & 0xFF ^ n3]);
            n3 = this.state.checksum[n] & 0xFF;
            ++n;
        }
    }

    public void update(byte by) {
        FIPS_140_2.assertReadyState();
        int n = this.state.count;
        this.state.count = n + 1 & 0xF;
        this.state.buffer[n] = by;
        if (this.state.count == 0) {
            this.transform();
        }
        this.digestValid = false;
    }

    final class MD2State
    extends MessageDigest.MDState {
        byte[] state = new byte[16];
        byte[] checksum = new byte[16];
        byte[] buffer = new byte[16];
        int count;

        MD2State() {
        }

        public Object clone() {
            FIPS_140_2.assertReadyState();
            MD2State mD2State = new MD2State();
            this.copyTo(mD2State);
            return mD2State;
        }

        public void copyTo(MessageDigest.MDState mDState) {
            FIPS_140_2.assertReadyState();
            if (this.getClass() != mDState.getClass()) {
                throw new IllegalArgumentException("MD2State required");
            }
            MD2State mD2State = (MD2State)mDState;
            mD2State.count = this.count;
            System.arraycopy(this.state, 0, mD2State.state, 0, 16);
            System.arraycopy(this.checksum, 0, mD2State.checksum, 0, 16);
            System.arraycopy(this.buffer, 0, mD2State.buffer, 0, 16);
        }

        public void init() {
            FIPS_140_2.assertReadyState();
            System.arraycopy(INIT_BUF, 0, this.state, 0, this.state.length);
            System.arraycopy(INIT_BUF, 0, this.checksum, 0, this.checksum.length);
            System.arraycopy(INIT_BUF, 0, this.buffer, 0, this.buffer.length);
            this.count = 0;
        }
    }
}

