/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.MessageDigest;
import com.phaos.fips.FIPS_140_2;

public final class MD5
extends MessageDigest {
    private MD5State state = new MD5State();
    private MD5State old = new MD5State();

    public MD5() {
        this.digestBits = new byte[16];
        this.digestValid = false;
    }

    private static int FF(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6, int n7) {
        return n2 + MD5.rotl(n + (n2 & n3 | ~n2 & n4) + nArray[n5] + n7, n6);
    }

    private static int GG(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6, int n7) {
        return n2 + MD5.rotl(n + (n2 & n4 | n3 & ~n4) + nArray[n5] + n7, n6);
    }

    private static int HH(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6, int n7) {
        return n2 + MD5.rotl(n + (n2 ^ n3 ^ n4) + nArray[n5] + n7, n6);
    }

    private static int II(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6, int n7) {
        return n2 + MD5.rotl(n + (n3 ^ (n2 | ~n4)) + nArray[n5] + n7, n6);
    }

    public String algName() {
        return "MD5";
    }

    public int blockSize() {
        return 64;
    }

    private int bytesToWord(byte by, byte by2, byte by3, byte by4) {
        return by & 0xFF | (by2 & 0xFF) << 8 | (by3 & 0xFF) << 16 | (by4 & 0xFF) << 24;
    }

    private void bytesToWords(byte[] byArray, int[] nArray) {
        int n = nArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            nArray[n2] = byArray[n3++] & 0xFF | (byArray[n3++] & 0xFF) << 8 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 24;
            ++n2;
        }
    }

    public Object clone() {
        FIPS_140_2.assertReadyState();
        MD5 mD5 = new MD5();
        this.state.copyTo(mD5.state);
        System.arraycopy(this.digestBits, 0, mD5.digestBits, 0, this.digestBits.length);
        mD5.digestValid = this.digestValid;
        return mD5;
    }

    public void computeCurrent() {
        FIPS_140_2.assertReadyState();
        this.state.copyTo(this.old);
        byte[] byArray = this.state.buf;
        int[] nArray = this.state.M;
        this.pad();
        this.update((byte)this.old.length);
        this.update((byte)(this.old.length >> 8));
        this.update((byte)(this.old.length >> 16));
        this.update((byte)(this.old.length >> 24));
        this.update((byte)(this.old.length >> 32));
        this.update((byte)(this.old.length >> 40));
        this.update((byte)(this.old.length >> 48));
        this.update((byte)(this.old.length >> 56));
        this.bytesToWords(byArray, nArray);
        this.transform();
        this.wordsToBytes(this.state.D, this.digestBits);
        this.digestValid = true;
        MD5State mD5State = this.state;
        this.state = this.old;
        this.old = mD5State;
    }

    public AlgorithmIdentifier getAlgID() {
        return AlgID.md5;
    }

    public int getDigestLength() {
        return 16;
    }

    protected MessageDigest.MDState getState() {
        return this.state;
    }

    public void init() {
        FIPS_140_2.assertReadyState();
        if (this.state != null) {
            this.state.init();
        }
        this.digestValid = false;
    }

    private void pad() {
        this.update((byte)-128);
        if (this.state.count > 56) {
            this.update(new byte[64 - this.state.count + 56]);
        } else if (this.state.count < 56) {
            this.update(new byte[56 - this.state.count]);
        }
    }

    private static int rotl(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    protected void setState(MessageDigest.MDState mDState) {
        mDState.copyTo(this.state);
        this.digestValid = false;
    }

    private void transform() {
        int n = this.state.D[0];
        int n2 = this.state.D[1];
        int n3 = this.state.D[2];
        int n4 = this.state.D[3];
        int[] nArray = this.state.M;
        n = MD5.FF(n, n2, n3, n4, nArray, 0, 7, -680876936);
        n4 = MD5.FF(n4, n, n2, n3, nArray, 1, 12, -389564586);
        n3 = MD5.FF(n3, n4, n, n2, nArray, 2, 17, 606105819);
        n2 = MD5.FF(n2, n3, n4, n, nArray, 3, 22, -1044525330);
        n = MD5.FF(n, n2, n3, n4, nArray, 4, 7, -176418897);
        n4 = MD5.FF(n4, n, n2, n3, nArray, 5, 12, 1200080426);
        n3 = MD5.FF(n3, n4, n, n2, nArray, 6, 17, -1473231341);
        n2 = MD5.FF(n2, n3, n4, n, nArray, 7, 22, -45705983);
        n = MD5.FF(n, n2, n3, n4, nArray, 8, 7, 1770035416);
        n4 = MD5.FF(n4, n, n2, n3, nArray, 9, 12, -1958414417);
        n3 = MD5.FF(n3, n4, n, n2, nArray, 10, 17, -42063);
        n2 = MD5.FF(n2, n3, n4, n, nArray, 11, 22, -1990404162);
        n = MD5.FF(n, n2, n3, n4, nArray, 12, 7, 1804603682);
        n4 = MD5.FF(n4, n, n2, n3, nArray, 13, 12, -40341101);
        n3 = MD5.FF(n3, n4, n, n2, nArray, 14, 17, -1502002290);
        n2 = MD5.FF(n2, n3, n4, n, nArray, 15, 22, 1236535329);
        n = MD5.GG(n, n2, n3, n4, nArray, 1, 5, -165796510);
        n4 = MD5.GG(n4, n, n2, n3, nArray, 6, 9, -1069501632);
        n3 = MD5.GG(n3, n4, n, n2, nArray, 11, 14, 643717713);
        n2 = MD5.GG(n2, n3, n4, n, nArray, 0, 20, -373897302);
        n = MD5.GG(n, n2, n3, n4, nArray, 5, 5, -701558691);
        n4 = MD5.GG(n4, n, n2, n3, nArray, 10, 9, 38016083);
        n3 = MD5.GG(n3, n4, n, n2, nArray, 15, 14, -660478335);
        n2 = MD5.GG(n2, n3, n4, n, nArray, 4, 20, -405537848);
        n = MD5.GG(n, n2, n3, n4, nArray, 9, 5, 568446438);
        n4 = MD5.GG(n4, n, n2, n3, nArray, 14, 9, -1019803690);
        n3 = MD5.GG(n3, n4, n, n2, nArray, 3, 14, -187363961);
        n2 = MD5.GG(n2, n3, n4, n, nArray, 8, 20, 1163531501);
        n = MD5.GG(n, n2, n3, n4, nArray, 13, 5, -1444681467);
        n4 = MD5.GG(n4, n, n2, n3, nArray, 2, 9, -51403784);
        n3 = MD5.GG(n3, n4, n, n2, nArray, 7, 14, 1735328473);
        n2 = MD5.GG(n2, n3, n4, n, nArray, 12, 20, -1926607734);
        n = MD5.HH(n, n2, n3, n4, nArray, 5, 4, -378558);
        n4 = MD5.HH(n4, n, n2, n3, nArray, 8, 11, -2022574463);
        n3 = MD5.HH(n3, n4, n, n2, nArray, 11, 16, 1839030562);
        n2 = MD5.HH(n2, n3, n4, n, nArray, 14, 23, -35309556);
        n = MD5.HH(n, n2, n3, n4, nArray, 1, 4, -1530992060);
        n4 = MD5.HH(n4, n, n2, n3, nArray, 4, 11, 1272893353);
        n3 = MD5.HH(n3, n4, n, n2, nArray, 7, 16, -155497632);
        n2 = MD5.HH(n2, n3, n4, n, nArray, 10, 23, -1094730640);
        n = MD5.HH(n, n2, n3, n4, nArray, 13, 4, 681279174);
        n4 = MD5.HH(n4, n, n2, n3, nArray, 0, 11, -358537222);
        n3 = MD5.HH(n3, n4, n, n2, nArray, 3, 16, -722521979);
        n2 = MD5.HH(n2, n3, n4, n, nArray, 6, 23, 76029189);
        n = MD5.HH(n, n2, n3, n4, nArray, 9, 4, -640364487);
        n4 = MD5.HH(n4, n, n2, n3, nArray, 12, 11, -421815835);
        n3 = MD5.HH(n3, n4, n, n2, nArray, 15, 16, 530742520);
        n2 = MD5.HH(n2, n3, n4, n, nArray, 2, 23, -995338651);
        n = MD5.II(n, n2, n3, n4, nArray, 0, 6, -198630844);
        n4 = MD5.II(n4, n, n2, n3, nArray, 7, 10, 1126891415);
        n3 = MD5.II(n3, n4, n, n2, nArray, 14, 15, -1416354905);
        n2 = MD5.II(n2, n3, n4, n, nArray, 5, 21, -57434055);
        n = MD5.II(n, n2, n3, n4, nArray, 12, 6, 1700485571);
        n4 = MD5.II(n4, n, n2, n3, nArray, 3, 10, -1894986606);
        n3 = MD5.II(n3, n4, n, n2, nArray, 10, 15, -1051523);
        n2 = MD5.II(n2, n3, n4, n, nArray, 1, 21, -2054922799);
        n = MD5.II(n, n2, n3, n4, nArray, 8, 6, 1873313359);
        n4 = MD5.II(n4, n, n2, n3, nArray, 15, 10, -30611744);
        n3 = MD5.II(n3, n4, n, n2, nArray, 6, 15, -1560198380);
        n2 = MD5.II(n2, n3, n4, n, nArray, 13, 21, 1309151649);
        n = MD5.II(n, n2, n3, n4, nArray, 4, 6, -145523070);
        n4 = MD5.II(n4, n, n2, n3, nArray, 11, 10, -1120210379);
        n3 = MD5.II(n3, n4, n, n2, nArray, 2, 15, 718787259);
        n2 = MD5.II(n2, n3, n4, n, nArray, 9, 21, -343485551);
        this.state.D[0] = this.state.D[0] + n;
        this.state.D[1] = this.state.D[1] + n2;
        this.state.D[2] = this.state.D[2] + n3;
        this.state.D[3] = this.state.D[3] + n4;
    }

    public void update(byte by) {
        FIPS_140_2.assertReadyState();
        byte[] byArray = this.state.buf;
        int[] nArray = this.state.M;
        if (this.state.count == 64) {
            this.bytesToWords(byArray, nArray);
            this.transform();
            this.state.count = 0;
        }
        byArray[this.state.count++] = by;
        this.state.length += 8L;
        this.digestValid = false;
    }

    public void update(byte[] byArray, int n, int n2) {
        FIPS_140_2.assertReadyState();
        this.digestValid = false;
        byte[] byArray2 = this.state.buf;
        int[] nArray = this.state.M;
        this.state.length += (long)(n2 << 3);
        while (n2 > 0) {
            int n3 = 64 - this.state.count;
            if (n2 < n3) {
                System.arraycopy(byArray, n, byArray2, this.state.count, n2);
                this.state.count += n2;
                n2 = 0;
                continue;
            }
            System.arraycopy(byArray, n, byArray2, this.state.count, n3);
            n2 -= n3;
            n += n3;
            this.bytesToWords(byArray2, nArray);
            this.transform();
            this.state.count = 0;
        }
    }

    private void wordsToBytes(int[] nArray, byte[] byArray) {
        int n = nArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byArray[n3++] = (byte)nArray[n2];
            byArray[n3++] = (byte)(nArray[n2] >> 8);
            byArray[n3++] = (byte)(nArray[n2] >> 16);
            byArray[n3++] = (byte)(nArray[n2] >> 24);
            ++n2;
        }
    }

    final class MD5State
    extends MessageDigest.MDState {
        byte[] buf = new byte[64];
        int[] M = new int[16];
        int[] D = new int[4];
        long length;
        int count;

        MD5State() {
            this.init();
        }

        public Object clone() {
            FIPS_140_2.assertReadyState();
            MD5State mD5State = new MD5State();
            this.copyTo(mD5State);
            return mD5State;
        }

        public void copyTo(MessageDigest.MDState mDState) {
            FIPS_140_2.assertReadyState();
            if (this.getClass() != mDState.getClass()) {
                throw new IllegalArgumentException("MD5State required");
            }
            MD5State mD5State = (MD5State)mDState;
            mD5State.length = this.length;
            mD5State.count = this.count;
            System.arraycopy(this.buf, 0, mD5State.buf, 0, 64);
            System.arraycopy(this.D, 0, mD5State.D, 0, 4);
        }

        public void init() {
            FIPS_140_2.assertReadyState();
            this.D[0] = 1732584193;
            this.D[1] = -271733879;
            this.D[2] = -1732584194;
            this.D[3] = 271733878;
            this.count = 0;
            this.length = 0;
        }
    }
}

