/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.MGF1;
import com.phaos.crypto.MaskException;
import com.phaos.fips.FIPS_140_2;

abstract class MaskGenerator {
    static {
        FIPS_140_2.powerUpSelfTest();
    }

    MaskGenerator() {
    }

    abstract void erase();

    abstract byte[] generateMask(byte[] var1, int var2) throws MaskException;

    abstract AlgorithmIdentifier getAlgID();

    static MaskGenerator getInstance(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        FIPS_140_2.assertReadyState();
        MGF1 mGF1 = new MGF1();
        ((MaskGenerator)mGF1).initialize(algorithmIdentifier);
        return mGF1;
    }

    abstract void initialize(AlgorithmIdentifier var1) throws AlgorithmIdentifierException;

    abstract void reset();
}

