/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.PBEAlgorithmIdentifier;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.SymmetricKey;
import com.phaos.fips.FIPS_140_2;
import com.phaos.utils.OIDManager;
import java.io.IOException;

public abstract class PBE {
    protected PBEAlgorithmIdentifier algID;
    protected AlgorithmIdentifier mdAlgID;
    protected AlgorithmIdentifier cipherAlgID;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    protected PBE() {
    }

    public abstract byte[] decrypt(String var1, byte[] var2) throws CipherException;

    public abstract PrivateKey decryptPrivateKey(String var1, byte[] var2) throws CipherException, IOException;

    public abstract SymmetricKey decryptSymmetricKey(String var1, byte[] var2) throws CipherException;

    public abstract byte[] encrypt(String var1, byte[] var2) throws CipherException;

    public abstract byte[] encryptPrivateKey(String var1, PrivateKey var2) throws CipherException;

    public abstract byte[] encryptSymmetricKey(String var1, SymmetricKey var2) throws CipherException;

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        return this.algID;
    }

    public static PBE getInstance(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        PBE pBE;
        FIPS_140_2.assertReadyState();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "pbe");
        if (clazz == null) {
            throw new AlgorithmIdentifierException("No class found for " + algorithmIdentifier.getOID());
        }
        try {
            pBE = (PBE)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Class does not implement PBE.");
        }
        pBE.initialize(algorithmIdentifier);
        return pBE;
    }

    public abstract void initialize(int var1) throws AlgorithmIdentifierException;

    public abstract void initialize(int var1, byte[] var2, int var3) throws AlgorithmIdentifierException;

    public abstract void initialize(AlgorithmIdentifier var1) throws AlgorithmIdentifierException;
}

