/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.BlockCipher;
import com.phaos.crypto.CBCAlgorithmIdentifier;
import com.phaos.crypto.Cipher;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.KeyUtils;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.PBE;
import com.phaos.crypto.PBEAlgorithmIdentifier;
import com.phaos.crypto.Padding;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PrivateKeyPKCS8;
import com.phaos.crypto.RC2AlgorithmIdentifier;
import com.phaos.crypto.SymmetricKey;
import com.phaos.fips.FIPS_140_2;
import com.phaos.math.BigInt;
import com.phaos.utils.CryptoUtils;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;

public final class PKCS12PBE
extends PBE {
    public static final int SHA_128RC4 = 1;
    public static final int SHA_40RC4 = 2;
    public static final int SHA_3_3DES_CBC = 3;
    public static final int SHA_2_3DES_CBC = 4;
    public static final int SHA_128RC2_CBC = 5;
    public static final int SHA_40RC2_CBC = 6;
    private int keyLength;

    private SymmetricKey createPBES12(String string) throws CipherException {
        SymmetricKey symmetricKey;
        byte[] byArray = PKCS12PBE.pbkdf12(this.mdAlgID, string, this.algID.getSalt(), this.algID.getIterationCount(), (byte)1, this.keyLength);
        if (this.cipherAlgID.getOID().equals(AlgID.RC4.getOID())) {
            symmetricKey = new SymmetricKey(byArray, AlgID.RC4);
        } else {
            byte[] byArray2 = PKCS12PBE.pbkdf12(this.mdAlgID, string, this.algID.getSalt(), this.algID.getIterationCount(), (byte)2, 8);
            if (this.cipherAlgID.getOID().equals(AlgID.RC2_CBC.getOID())) {
                symmetricKey = new SymmetricKey(byArray, new RC2AlgorithmIdentifier(byArray2, this.keyLength * 8));
            }
            if (this.algID.getOID().equals(PBEAlgorithmIdentifier.pbeWithSHAAnd2_KeyTripleDES_CBC)) {
                byte[] byArray3 = new byte[24];
                System.arraycopy(byArray, 0, byArray3, 0, 16);
                System.arraycopy(byArray, 0, byArray3, 16, 8);
                Utils.setArray(byArray, (byte)0);
                byArray = byArray3;
            }
            symmetricKey = new SymmetricKey(byArray, new CBCAlgorithmIdentifier(this.cipherAlgID.getOID(), byArray2));
        }
        Utils.setArray(byArray, (byte)0);
        return symmetricKey;
    }

    public static byte[] createPKCS12MacKey(AlgorithmIdentifier algorithmIdentifier, String string, byte[] byArray, int n, int n2) throws CipherException {
        FIPS_140_2.assertReadyState();
        return PKCS12PBE.pbkdf12(algorithmIdentifier, string, byArray, n, (byte)3, n2);
    }

    public byte[] decrypt(String string, byte[] byArray) throws CipherException {
        FIPS_140_2.assertReadyState();
        return this.processPBES12(string, byArray, false);
    }

    public PrivateKey decryptPrivateKey(String string, byte[] byArray) throws CipherException, IOException {
        byte[] byArray2 = this.processPBES12(string, byArray, false);
        PrivateKey privateKey = CryptoUtils.inputPrivateKey(new UnsyncByteArrayInputStream(byArray2));
        Utils.setArray(byArray2, (byte)0);
        return privateKey;
    }

    public SymmetricKey decryptSymmetricKey(String string, byte[] byArray) throws CipherException {
        byte[] byArray2 = this.processPBES12(string, byArray, false);
        SymmetricKey symmetricKey = new SymmetricKey(byArray2);
        Utils.setArray(byArray2, (byte)0);
        return symmetricKey;
    }

    public byte[] encrypt(String string, byte[] byArray) throws CipherException {
        FIPS_140_2.assertReadyState();
        return this.processPBES12(string, byArray, true);
    }

    public byte[] encryptPrivateKey(String string, PrivateKey privateKey) throws CipherException {
        if (privateKey instanceof PrivateKeyPKCS8) {
            throw new CipherException("Cannot encrypt encrypted key");
        }
        return this.processPBES12(string, KeyUtils.getEncodedInternal(privateKey), true);
    }

    public byte[] encryptSymmetricKey(String string, SymmetricKey symmetricKey) throws CipherException {
        return this.processPBES12(string, symmetricKey.getEncodedInternal(), true);
    }

    public void initialize(int n) throws AlgorithmIdentifierException {
        this.initialize(new PBEAlgorithmIdentifier(new ASN1ObjectID(PBEAlgorithmIdentifier.pkcs12PBEids, n)));
    }

    public void initialize(int n, byte[] byArray, int n2) throws AlgorithmIdentifierException {
        this.initialize(new PBEAlgorithmIdentifier(new ASN1ObjectID(PBEAlgorithmIdentifier.pkcs12PBEids, n), byArray, n2));
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        FIPS_140_2.assertReadyState();
        if (algorithmIdentifier instanceof PBEAlgorithmIdentifier) {
            this.algID = (PBEAlgorithmIdentifier)algorithmIdentifier;
        } else {
            try {
                this.algID = new PBEAlgorithmIdentifier(Utils.toStream(algorithmIdentifier));
            }
            catch (IOException iOException) {
                throw new AlgorithmIdentifierException(iOException.toString());
            }
        }
        ASN1ObjectID aSN1ObjectID = this.algID.getOID();
        this.mdAlgID = AlgID.sha_1;
        if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHAAnd128BitRC4)) {
            this.cipherAlgID = AlgID.RC4;
            this.keyLength = 16;
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHAAnd40BitRC4)) {
            this.cipherAlgID = AlgID.RC4;
            this.keyLength = 5;
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHAAnd3_KeyTripleDES_CBC)) {
            this.cipherAlgID = AlgID.DES_EDE3_CBC;
            this.keyLength = 24;
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHAAnd2_KeyTripleDES_CBC)) {
            this.cipherAlgID = AlgID.DES_EDE3_CBC;
            this.keyLength = 16;
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHAAnd128BitRC2_CBC)) {
            this.cipherAlgID = AlgID.RC2_CBC;
            this.keyLength = 16;
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHAAnd40BitRC2_CBC)) {
            this.cipherAlgID = AlgID.RC2_CBC;
            this.keyLength = 5;
        } else {
            throw new AlgorithmIdentifierException("Unknown algorithm identifier: " + algorithmIdentifier);
        }
    }

    private static byte[] pbkdf12(AlgorithmIdentifier algorithmIdentifier, String string, byte[] byArray, int n, byte by, int n2) throws CipherException {
        MessageDigest messageDigest;
        if (string == null) {
            throw new CipherException("Password not set");
        }
        try {
            messageDigest = MessageDigest.getInstance(algorithmIdentifier);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new CipherException(algorithmIdentifierException.toString());
        }
        int n3 = messageDigest.getDigestLength();
        int n4 = messageDigest.blockSize();
        byte[] byArray2 = new byte[n4];
        Utils.setArray(byArray2, by);
        byte[] byArray3 = Utils.unicodeToBytes(string);
        byte[] byArray4 = new byte[byArray3.length + 2];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        byArray4[byArray4.length - 1] = 0;
        byArray4[byArray4.length - 2] = 0;
        int n5 = byArray.length == 0 ? 0 : ((byArray.length - 1) / n4 + 1) * n4;
        int n6 = byArray4.length == 0 ? 0 : ((byArray4.length - 1) / n4 + 1) * n4;
        byte[] byArray5 = new byte[n5 + n6];
        int n7 = 0;
        while (n7 < n5) {
            System.arraycopy(byArray, 0, byArray5, n7, Math.min(n5 - n7, byArray.length));
            n7 += byArray.length;
        }
        int n8 = n5;
        int n9 = byArray5.length;
        while (n8 < n9) {
            System.arraycopy(byArray4, 0, byArray5, n8, Math.min(byArray5.length - n8, byArray4.length));
            n8 += byArray4.length;
        }
        Utils.setArray(byArray4, (byte)0);
        Utils.setArray(byArray3, (byte)0);
        byte[] byArray6 = new byte[n2];
        int n10 = 0;
        while (n10 < n2) {
            messageDigest.init();
            messageDigest.update(byArray2);
            messageDigest.update(byArray5);
            messageDigest.computeCurrent();
            int n11 = 0;
            int n12 = n - 1;
            while (n11 < n12) {
                messageDigest.init();
                messageDigest.update(messageDigest.getDigestBitsInternal());
                messageDigest.computeCurrent();
                ++n11;
            }
            byte[] byArray7 = new byte[n4];
            int n13 = 0;
            while (n13 < n4) {
                System.arraycopy(messageDigest.getDigestBitsInternal(), 0, byArray7, n13, Math.min(n4 - n13, n3));
                n13 += n3;
            }
            BigInt bigInt = new BigInt(1, byArray7).add(BigInt.ONE);
            BigInt bigInt2 = BigInt.ONE.shiftLeft(n4 * 8).subtract(BigInt.ONE);
            int n14 = 0;
            int n15 = byArray5.length;
            while (n14 < n15) {
                byte[] byArray8 = new byte[n4];
                System.arraycopy(byArray5, n14, byArray8, 0, n4);
                BigInt bigInt3 = new BigInt(1, byArray8).add(bigInt).and(bigInt2);
                Utils.toByteArray(bigInt3, byArray5, n14, n4);
                n14 += n4;
            }
            System.arraycopy(messageDigest.getDigestBitsInternal(), 0, byArray6, n10, Math.min(n2 - n10, n3));
            n10 += n3;
        }
        Utils.setArray(messageDigest.getDigestBitsInternal(), (byte)0);
        return byArray6;
    }

    private byte[] processPBES12(String string, byte[] byArray, boolean bl) throws CipherException {
        try {
            byte[] byArray2;
            Cipher cipher;
            SymmetricKey symmetricKey;
            block11: {
                symmetricKey = this.createPBES12(string);
                cipher = null;
                try {
                    if (!this.cipherAlgID.getOID().equals(AlgID.RC4.getOID())) {
                        cipher = Cipher.getInstance(symmetricKey.getAlgID(), symmetricKey, Padding.PKCS5);
                        byArray2 = bl ? ((BlockCipher)cipher).encrypt(byArray, 0, byArray.length, true) : ((BlockCipher)cipher).decrypt(byArray, 0, byArray.length, true);
                        break block11;
                    }
                    cipher = Cipher.getInstance(symmetricKey.getAlgID(), symmetricKey);
                    if (bl) {
                        byArray2 = cipher.encrypt(byArray);
                        break block11;
                    }
                    byArray2 = cipher.decrypt(byArray);
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    if (cipher != null) {
                        cipher.erase();
                    }
                    if (symmetricKey != null) {
                        symmetricKey.erase();
                    }
                    throw throwable;
                }
            }
            Object var8_9 = null;
            if (cipher != null) {
                cipher.erase();
            }
            if (symmetricKey != null) {
                symmetricKey.erase();
            }
            return byArray2;
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new CipherException(algorithmIdentifierException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CipherException(invalidKeyException.toString());
        }
    }
}

