/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.BlockCipher;
import com.phaos.crypto.CBCAlgorithmIdentifier;
import com.phaos.crypto.Cipher;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.KeyUtils;
import com.phaos.crypto.MAC;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.PBE;
import com.phaos.crypto.PBEAlgorithmIdentifier;
import com.phaos.crypto.Padding;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PrivateKeyPKCS8;
import com.phaos.crypto.RC2AlgorithmIdentifier;
import com.phaos.crypto.SymmetricKey;
import com.phaos.fips.FIPS_140_2;
import com.phaos.utils.CryptoUtils;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public final class PKCS5PBE
extends PBE {
    private static final long MAX_LENGTH_PBKDF2 = 0x100000001L;
    public static final int MD2_DES = 1;
    public static final int MD2_RC2 = 4;
    public static final int MD5_DES = 3;
    public static final int MD5_RC2 = 6;
    public static final int SHA1_DES = 10;
    public static final int SHA1_RC2 = 11;
    private int mode;

    private static byte[] F(MAC mAC, byte[] byArray, int n, int n2) {
        byte[] byArray2;
        mAC.init();
        mAC.update(byArray);
        mAC.update(Utils.wordToBytes(n2));
        mAC.computeCurrent();
        byte[] byArray3 = byArray2 = mAC.getDigestBits();
        int n3 = 1;
        while (n3 < n) {
            mAC.init();
            mAC.update(byArray3);
            mAC.computeCurrent();
            byArray3 = mAC.getDigestBits();
            int n4 = 0;
            while (n4 < byArray2.length) {
                byArray2[n4] = (byte)((byArray2[n4] & 0xFF ^ byArray3[n4] & 0xFF) & 0xFF);
                ++n4;
            }
            Utils.setArray(byArray3, (byte)0);
            Utils.setArray(mAC.getDigestBitsInternal(), (byte)0);
            ++n3;
        }
        return byArray2;
    }

    private SymmetricKey createPBES1(byte[] byArray) throws CipherException {
        try {
            byte[] byArray2 = PKCS5PBE.pbkdf1(this.mdAlgID, byArray, this.algID.getSalt(), this.algID.getIterationCount(), 16);
            byte[] byArray3 = new byte[8];
            System.arraycopy(byArray2, 0, byArray3, 0, 8);
            byte[] byArray4 = new byte[8];
            System.arraycopy(byArray2, 8, byArray4, 0, 8);
            Utils.setArray(byArray2, (byte)0);
            AlgorithmIdentifier algorithmIdentifier = this.cipherAlgID.getOID().equals(AlgID.RC2_CBC.getOID()) ? new RC2AlgorithmIdentifier(byArray4, 64) : (!this.cipherAlgID.getOID().equals(AlgID.RC4.getOID()) ? new CBCAlgorithmIdentifier(this.cipherAlgID.getOID(), byArray4) : AlgID.RC4);
            SymmetricKey symmetricKey = new SymmetricKey(byArray3, algorithmIdentifier);
            Utils.setArray(byArray3, (byte)0);
            return symmetricKey;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CipherException(invalidKeyException.toString());
        }
    }

    private SymmetricKey createPBES2(byte[] byArray) throws CipherException {
        try {
            byte[] byArray2 = PKCS5PBE.pbkdf2(this.mdAlgID, byArray, this.algID.getSalt(), this.algID.getIterationCount(), this.algID.getKeyLength());
            SymmetricKey symmetricKey = new SymmetricKey(byArray2, this.cipherAlgID);
            Utils.setArray(byArray2, (byte)0);
            return symmetricKey;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CipherException(invalidKeyException.toString());
        }
    }

    public byte[] decrypt(String string, byte[] byArray) throws CipherException {
        byte[] byArray2;
        byte[] byArray3;
        FIPS_140_2.assertReadyState();
        boolean bl = false;
        try {
            byArray3 = string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray3 = string.getBytes();
            bl = true;
        }
        try {
            byArray2 = this.mode == 1 ? this.processPBES1(byArray3, byArray, false) : this.processPBES2(byArray3, byArray, false);
        }
        catch (Exception exception) {
            if (!bl) {
                Utils.setArray(byArray3, (byte)0);
                byArray3 = string.getBytes();
                byArray2 = this.mode == 1 ? this.processPBES1(byArray3, byArray, false) : this.processPBES2(byArray3, byArray, false);
            }
            if (exception instanceof CipherException) {
                throw (CipherException)exception;
            }
            throw new CipherException(exception.toString());
        }
        Utils.setArray(byArray3, (byte)0);
        return byArray2;
    }

    public PrivateKey decryptPrivateKey(String string, byte[] byArray) throws CipherException, IOException {
        PrivateKey privateKey;
        byte[] byArray2 = null;
        try {
            byArray2 = this.decrypt(string, byArray);
            privateKey = CryptoUtils.inputPrivateKey(new UnsyncByteArrayInputStream(byArray2));
        }
        catch (Exception exception) {
            if (byArray2 != null) {
                Utils.setArray(byArray2, (byte)0);
            }
            byte[] byArray3 = string.getBytes();
            byArray2 = this.mode == 1 ? this.processPBES1(byArray3, byArray, false) : this.processPBES2(byArray3, byArray, false);
            Utils.setArray(byArray3, (byte)0);
            privateKey = CryptoUtils.inputPrivateKey(new UnsyncByteArrayInputStream(byArray2));
        }
        Utils.setArray(byArray2, (byte)0);
        return privateKey;
    }

    public SymmetricKey decryptSymmetricKey(String string, byte[] byArray) throws CipherException {
        byte[] byArray2 = this.decrypt(string, byArray);
        SymmetricKey symmetricKey = new SymmetricKey(byArray2);
        Utils.setArray(byArray2, (byte)0);
        return symmetricKey;
    }

    public byte[] encrypt(String string, byte[] byArray) throws CipherException {
        byte[] byArray2;
        FIPS_140_2.assertReadyState();
        try {
            byArray2 = string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray2 = string.getBytes();
        }
        byte[] byArray3 = this.mode == 1 ? this.processPBES1(byArray2, byArray, true) : this.processPBES2(byArray2, byArray, true);
        Utils.setArray(byArray2, (byte)0);
        return byArray3;
    }

    public byte[] encryptPrivateKey(String string, PrivateKey privateKey) throws CipherException {
        if (privateKey instanceof PrivateKeyPKCS8) {
            throw new CipherException("Cannot encrypt encrypted key");
        }
        return this.encrypt(string, KeyUtils.getEncodedInternal(privateKey));
    }

    public byte[] encryptSymmetricKey(String string, SymmetricKey symmetricKey) throws CipherException {
        return this.encrypt(string, symmetricKey.getEncodedInternal());
    }

    public void initialize(int n) throws AlgorithmIdentifierException {
        this.initialize(new PBEAlgorithmIdentifier(new ASN1ObjectID(PBEAlgorithmIdentifier.pkcs5, n)));
    }

    public void initialize(int n, byte[] byArray, int n2) throws AlgorithmIdentifierException {
        this.initialize(new PBEAlgorithmIdentifier(new ASN1ObjectID(PBEAlgorithmIdentifier.pkcs5, n), byArray, n2));
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        FIPS_140_2.assertReadyState();
        if (algorithmIdentifier instanceof PBEAlgorithmIdentifier) {
            this.algID = (PBEAlgorithmIdentifier)algorithmIdentifier;
        } else {
            try {
                this.algID = new PBEAlgorithmIdentifier(Utils.toStream(algorithmIdentifier));
            }
            catch (IOException iOException) {
                throw new AlgorithmIdentifierException(iOException.toString());
            }
        }
        ASN1ObjectID aSN1ObjectID = this.algID.getOID();
        if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithMD2AndDES_CBC)) {
            this.mdAlgID = AlgID.md2;
            this.cipherAlgID = AlgID.desCBC;
            this.mode = 1;
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithMD2AndRC2_CBC)) {
            this.mdAlgID = AlgID.md2;
            this.cipherAlgID = AlgID.RC2_CBC;
            this.mode = 1;
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithMD5AndDES_CBC)) {
            this.mdAlgID = AlgID.md5;
            this.cipherAlgID = AlgID.desCBC;
            this.mode = 1;
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithMD5AndRC2_CBC)) {
            this.mdAlgID = AlgID.md5;
            this.cipherAlgID = AlgID.RC2_CBC;
            this.mode = 1;
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHA1AndDES_CBC)) {
            this.mdAlgID = AlgID.sha_1;
            this.cipherAlgID = AlgID.desCBC;
            this.mode = 1;
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHA1AndRC2_CBC)) {
            this.mdAlgID = AlgID.sha_1;
            this.cipherAlgID = AlgID.RC2_CBC;
            this.mode = 1;
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.id_PBES2)) {
            if (this.algID.getPseudorandomFunc().getOID().equals(AlgID.hmacWithSHA1.getOID()) || this.algID.getPseudorandomFunc().getOID().equals(AlgID.hmacSHA.getOID())) {
                this.mdAlgID = AlgID.sha_1;
            } else if (this.algID.getPseudorandomFunc().getOID().equals(AlgID.hmacMD5.getOID())) {
                this.mdAlgID = AlgID.md5;
            } else {
                throw new AlgorithmIdentifierException("Unknown key derivation algorithm identifier");
            }
            this.cipherAlgID = this.algID.getEncryptionScheme();
            this.mode = 2;
        } else {
            throw new AlgorithmIdentifierException("Unknown algorithm identifier: " + algorithmIdentifier);
        }
    }

    private static byte[] pbkdf1(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2, int n, int n2) throws InvalidKeyException {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(algorithmIdentifier);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new InvalidKeyException(algorithmIdentifierException.toString());
        }
        if (n2 > messageDigest.getDigestLength()) {
            throw new InvalidKeyException("Derived key too long");
        }
        messageDigest.init();
        messageDigest.update(byArray);
        messageDigest.update(byArray2);
        messageDigest.computeCurrent();
        byte[] byArray3 = messageDigest.getDigestBitsInternal();
        int n3 = 1;
        while (n3 < n) {
            messageDigest.init();
            messageDigest.update(byArray3);
            messageDigest.computeCurrent();
            byArray3 = messageDigest.getDigestBitsInternal();
            ++n3;
        }
        if (byArray3.length == n2) {
            return byArray3;
        }
        byte[] byArray4 = new byte[n2];
        System.arraycopy(byArray3, 0, byArray4, 0, n2);
        Utils.setArray(byArray3, (byte)0);
        return byArray4;
    }

    private static byte[] pbkdf2(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2, int n, int n2) throws InvalidKeyException {
        byte[] byArray3;
        MAC mAC;
        SymmetricKey symmetricKey = new SymmetricKey(byArray);
        try {
            try {
                mAC = MAC.getInstance(algorithmIdentifier, symmetricKey);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new InvalidKeyException(algorithmIdentifierException.toString());
            }
            Object var8_9 = null;
            if (symmetricKey != null) {
                symmetricKey.erase();
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (symmetricKey != null) {
                symmetricKey.erase();
            }
            throw throwable;
        }
        int n3 = mAC.getDigestLength();
        if (((long)n2 & 0xFFFFL) > 0x100000001L * (long)n3) {
            throw new InvalidKeyException("Derived key too long");
        }
        int n4 = n2 / n3;
        byte[] byArray4 = new byte[n2];
        int n5 = 1;
        while (n5 < n4 + 1) {
            byArray3 = PKCS5PBE.F(mAC, byArray2, n, n5);
            System.arraycopy(byArray3, 0, byArray4, (n5 - 1) * n3, n3);
            Utils.setArray(byArray3, (byte)0);
            ++n5;
        }
        if (n2 > n4 * n3) {
            byArray3 = PKCS5PBE.F(mAC, byArray2, n, n4 + 1);
            System.arraycopy(byArray3, 0, byArray4, n4 * n3, n2 - n4 * n3);
            Utils.setArray(byArray3, (byte)0);
        }
        mAC.erase();
        return byArray4;
    }

    private byte[] processPBES1(byte[] byArray, byte[] byArray2, boolean bl) throws CipherException {
        byte[] byArray3;
        SymmetricKey symmetricKey = this.createPBES1(byArray);
        Cipher cipher = null;
        try {
            try {
                cipher = Cipher.getInstance(symmetricKey.getAlgID(), symmetricKey, Padding.PKCS5);
                byArray3 = bl ? ((BlockCipher)cipher).encrypt(byArray2, 0, byArray2.length, true) : ((BlockCipher)cipher).decrypt(byArray2, 0, byArray2.length, true);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new CipherException(algorithmIdentifierException.toString());
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CipherException(invalidKeyException.toString());
            }
            Object var8_9 = null;
            if (cipher != null) {
                cipher.erase();
            }
            if (symmetricKey != null) {
                symmetricKey.erase();
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (cipher != null) {
                cipher.erase();
            }
            if (symmetricKey != null) {
                symmetricKey.erase();
            }
            throw throwable;
        }
        return byArray3;
    }

    private byte[] processPBES2(byte[] byArray, byte[] byArray2, boolean bl) throws CipherException {
        byte[] byArray3;
        SymmetricKey symmetricKey = this.createPBES2(byArray);
        Cipher cipher = null;
        try {
            try {
                cipher = Cipher.getInstance(this.cipherAlgID, symmetricKey, Padding.PKCS5);
                byArray3 = bl ? ((BlockCipher)cipher).encrypt(byArray2, 0, byArray2.length, true) : ((BlockCipher)cipher).decrypt(byArray2, 0, byArray2.length, true);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new CipherException(algorithmIdentifierException.toString());
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CipherException(invalidKeyException.toString());
            }
            Object var8_9 = null;
            if (cipher != null) {
                cipher.erase();
            }
            if (symmetricKey != null) {
                symmetricKey.erase();
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (cipher != null) {
                cipher.erase();
            }
            if (symmetricKey != null) {
                symmetricKey.erase();
            }
            throw throwable;
        }
        return byArray3;
    }
}

