/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.PBE;
import com.phaos.crypto.PBEAlgorithmIdentifier;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.fips.FIPS_140_2;
import com.phaos.fips.KeyExportException;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.OIDManager;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;

public class PrivateKeyPKCS8
implements ASN1Object,
PrivateKey {
    private PBE pbe;
    private final Object PBE_LOCK = new Object();
    private byte[] encKey;
    private PrivateKey key;
    private String password;
    private RandomBitsSource rbs;
    private boolean allowExport = true;
    private byte[] contents;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    public PrivateKeyPKCS8() {
        this.deprecatedInitialization(null, null, 3, null);
    }

    public PrivateKeyPKCS8(int n) {
        FIPS_140_2.assertReadyState();
        this.deprecatedInitialization(null, null, n, null);
    }

    public PrivateKeyPKCS8(int n, RandomBitsSource randomBitsSource) {
        FIPS_140_2.assertReadyState();
        this.deprecatedInitialization(null, null, n, randomBitsSource);
    }

    public PrivateKeyPKCS8(ASN1ObjectID aSN1ObjectID) throws AlgorithmIdentifierException {
        this(new PBEAlgorithmIdentifier(aSN1ObjectID, RandomBitsSource.getDefault()));
    }

    public PrivateKeyPKCS8(ASN1ObjectID aSN1ObjectID, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException {
        this(new PBEAlgorithmIdentifier(aSN1ObjectID, randomBitsSource));
    }

    public PrivateKeyPKCS8(ASN1Sequence aSN1Sequence) throws IOException {
        this(Utils.toStream(aSN1Sequence));
    }

    public PrivateKeyPKCS8(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        this.pbe = PBE.getInstance(algorithmIdentifier);
    }

    public PrivateKeyPKCS8(PrivateKey privateKey) {
        FIPS_140_2.assertReadyState();
        this.deprecatedInitialization(privateKey, null, 3, null);
    }

    public PrivateKeyPKCS8(PrivateKey privateKey, int n) {
        FIPS_140_2.assertReadyState();
        this.deprecatedInitialization(privateKey, null, n, null);
    }

    public PrivateKeyPKCS8(PrivateKey privateKey, int n, RandomBitsSource randomBitsSource) {
        FIPS_140_2.assertReadyState();
        this.deprecatedInitialization(privateKey, null, n, randomBitsSource);
    }

    public PrivateKeyPKCS8(PrivateKey privateKey, RandomBitsSource randomBitsSource) {
        FIPS_140_2.assertReadyState();
        this.deprecatedInitialization(privateKey, null, 3, randomBitsSource);
    }

    public PrivateKeyPKCS8(PrivateKey privateKey, String string) throws AlgorithmIdentifierException {
        this(privateKey, string, new PBEAlgorithmIdentifier(PBEAlgorithmIdentifier.pbeWithSHAAnd3_KeyTripleDES_CBC, RandomBitsSource.getDefault()));
    }

    public PrivateKeyPKCS8(PrivateKey privateKey, String string, int n) {
        FIPS_140_2.assertReadyState();
        this.deprecatedInitialization(privateKey, string, n, null);
    }

    public PrivateKeyPKCS8(PrivateKey privateKey, String string, int n, RandomBitsSource randomBitsSource) {
        FIPS_140_2.assertReadyState();
        this.deprecatedInitialization(privateKey, string, n, randomBitsSource);
    }

    public PrivateKeyPKCS8(PrivateKey privateKey, String string, ASN1ObjectID aSN1ObjectID, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException {
        this(privateKey, string, new PBEAlgorithmIdentifier(aSN1ObjectID, randomBitsSource));
    }

    public PrivateKeyPKCS8(PrivateKey privateKey, String string, AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        this(algorithmIdentifier);
        this.key = privateKey;
        this.password = string;
    }

    public PrivateKeyPKCS8(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public PrivateKeyPKCS8(String string, ASN1Sequence aSN1Sequence) throws IOException {
        this(string, Utils.toStream(aSN1Sequence));
    }

    public PrivateKeyPKCS8(String string, PrivateKey privateKey) {
        FIPS_140_2.assertReadyState();
        this.deprecatedInitialization(privateKey, string, 3, null);
    }

    public PrivateKeyPKCS8(String string, PrivateKey privateKey, RandomBitsSource randomBitsSource) {
        FIPS_140_2.assertReadyState();
        this.deprecatedInitialization(privateKey, string, 3, randomBitsSource);
    }

    public PrivateKeyPKCS8(String string, File file) throws IOException, FileNotFoundException {
        this(string, new FileInputStream(file));
    }

    public PrivateKeyPKCS8(String string, InputStream inputStream) throws IOException {
        this.password = string;
        this.input(inputStream);
    }

    protected void assertAllowExport() {
        if (!this.getAllowExport() || !FIPS_140_2.getAllowKeyExport()) {
            throw new KeyExportException("Plaintext key export not allowed");
        }
    }

    public Object clone() {
        FIPS_140_2.assertReadyState();
        PrivateKeyPKCS8 privateKeyPKCS8 = new PrivateKeyPKCS8();
        if (this.key != null) {
            privateKeyPKCS8.key = (PrivateKey)this.key.clone();
        }
        if (this.encKey != null) {
            privateKeyPKCS8.encKey = (byte[])this.encKey.clone();
        }
        if (this.password != null) {
            privateKeyPKCS8.password = this.password;
        }
        if (this.pbe != null) {
            try {
                privateKeyPKCS8.pbe = PBE.getInstance(this.pbe.getAlgID());
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new IllegalStateException(algorithmIdentifierException.toString());
            }
        } else {
            privateKeyPKCS8.pbe = null;
        }
        privateKeyPKCS8.rbs = this.getRBS();
        privateKeyPKCS8.allowExport = this.allowExport;
        return privateKeyPKCS8;
    }

    private void deprecatedInitialization(PrivateKey privateKey, String string, int n, RandomBitsSource randomBitsSource) {
        block5: {
            this.rbs = randomBitsSource == null ? RandomBitsSource.getDefault() : randomBitsSource;
            try {
                if (n > 0) {
                    this.pbe = PBE.getInstance(new PBEAlgorithmIdentifier(new ASN1ObjectID(PBEAlgorithmIdentifier.pkcs12PBEids, n), this.rbs));
                    break block5;
                }
                if (n == 0) {
                    this.pbe = PBE.getInstance(new PBEAlgorithmIdentifier(PBEAlgorithmIdentifier.pbeWithMD5AndDES_CBC, this.rbs));
                    break block5;
                }
                if (n == -1) {
                    this.pbe = PBE.getInstance(new PBEAlgorithmIdentifier(PBEAlgorithmIdentifier.pbeWithMD2AndDES_CBC, this.rbs));
                    break block5;
                }
                throw new IllegalStateException("Unknown mode");
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new IllegalStateException(algorithmIdentifierException.toString());
            }
        }
        this.key = privateKey;
        this.password = string;
    }

    public void erase() {
        this.key = null;
        this.pbe = null;
        this.encKey = null;
        this.contents = null;
        this.rbs = null;
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        try {
            return this.getKeyNoCheck().getAlgID();
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public String getAlgorithm() {
        FIPS_140_2.assertReadyState();
        try {
            return this.getKeyNoCheck().getAlgorithm();
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public boolean getAllowExport() {
        return this.allowExport;
    }

    public int getBitLength() {
        FIPS_140_2.assertReadyState();
        try {
            return this.getKeyNoCheck().getBitLength();
        }
        catch (RuntimeException runtimeException) {
            return 0;
        }
    }

    public ASN1Object getContents() {
        FIPS_140_2.assertReadyState();
        if (this.pbe == null) {
            throw new StreamableOutputException("No Password Based Encryption created");
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(this.pbe.getAlgID());
        try {
            aSN1Sequence.addElement(new ASN1OctetString(this.getEncryptedKey()));
        }
        catch (CipherException cipherException) {
            throw new StreamableOutputException(cipherException.toString());
        }
        return aSN1Sequence;
    }

    public byte[] getEncoded() {
        if (this.contents == null) {
            this.contents = Utils.toBytes(this.getContents());
        }
        return this.contents;
    }

    private byte[] getEncryptedKey() throws CipherException {
        if (this.encKey == null) {
            Object object = this.PBE_LOCK;
            synchronized (object) {
                if (this.encKey == null) {
                    if (this.key == null) {
                        throw new CipherException("Private key not found for encryption");
                    }
                    if (this.password == null) {
                        throw new CipherException("The password was not set");
                    }
                    this.encKey = this.pbe.encryptPrivateKey(this.password, this.key);
                }
            }
        }
        return this.encKey;
    }

    public String getFormat() {
        FIPS_140_2.assertReadyState();
        try {
            return this.getKeyNoCheck().getFormat();
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public PrivateKey getKey() {
        return this.getKey(this.password);
    }

    public PrivateKey getKey(String string) {
        this.assertAllowExport();
        return this.getKeyNoCheck(string);
    }

    PrivateKey getKeyNoCheck() {
        return this.getKeyNoCheck(this.password);
    }

    PrivateKey getKeyNoCheck(String string) {
        FIPS_140_2.assertReadyState();
        if (this.key == null) {
            Object object = this.PBE_LOCK;
            synchronized (object) {
                if (this.key == null) {
                    try {
                        if (this.encKey == null) {
                            throw new IllegalStateException("Encrypted private key not found");
                        }
                        if (string == null) {
                            throw new IllegalStateException("Invalid password: the password is null");
                        }
                        this.key = this.pbe.decryptPrivateKey(string, this.encKey);
                    }
                    catch (CipherException cipherException) {
                        throw new IllegalStateException(cipherException.toString());
                    }
                    catch (IOException iOException) {
                        throw new IllegalStateException(iOException.toString());
                    }
                }
            }
        }
        return this.key;
    }

    public int getMode() {
        FIPS_140_2.assertReadyState();
        if (this.pbe == null || this.pbe.getAlgID() == null) {
            return 3;
        }
        ASN1ObjectID aSN1ObjectID = this.pbe.getAlgID().getOID();
        if (((Object)aSN1ObjectID).equals(PBEAlgorithmIdentifier.pbeWithMD2AndDES_CBC)) {
            return -1;
        }
        if (((Object)aSN1ObjectID).equals(PBEAlgorithmIdentifier.pbeWithMD5AndDES_CBC)) {
            return 0;
        }
        if (((Object)aSN1ObjectID).equals(PBEAlgorithmIdentifier.pbeWithSHAAnd128BitRC4)) {
            return 1;
        }
        if (((Object)aSN1ObjectID).equals(PBEAlgorithmIdentifier.pbeWithSHAAnd40BitRC4)) {
            return 2;
        }
        if (((Object)aSN1ObjectID).equals(PBEAlgorithmIdentifier.pbeWithSHAAnd3_KeyTripleDES_CBC)) {
            return 3;
        }
        if (((Object)aSN1ObjectID).equals(PBEAlgorithmIdentifier.pbeWithSHAAnd2_KeyTripleDES_CBC)) {
            return 4;
        }
        if (((Object)aSN1ObjectID).equals(PBEAlgorithmIdentifier.pbeWithSHAAnd128BitRC2_CBC)) {
            return 5;
        }
        if (((Object)aSN1ObjectID).equals(PBEAlgorithmIdentifier.pbeWithSHAAnd40BitRC2_CBC)) {
            return 6;
        }
        throw new IllegalStateException("The mode value does exist for this PBE Alg ID:" + this.pbe.getAlgID());
    }

    public AlgorithmIdentifier getPBEAlgID() {
        FIPS_140_2.assertReadyState();
        if (this.pbe != null) {
            return this.pbe.getAlgID();
        }
        return null;
    }

    private RandomBitsSource getRBS() {
        if (this.rbs == null) {
            this.rbs = RandomBitsSource.getDefault();
        }
        return this.rbs;
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws InvalidInputException, AlgorithmIdentifierException {
        FIPS_140_2.assertReadyState();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "privateKey");
        if (clazz == null) {
            throw new AlgorithmIdentifierException("Unrecognized algorithm OID " + algorithmIdentifier.getOID());
        }
        try {
            PrivateKey privateKey = (PrivateKey)clazz.newInstance();
            privateKey.initialize(algorithmIdentifier, aSN1Object);
            this.key = privateKey;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ": " + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ": " + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Class does not implement PrivateKey.");
        }
        this.encKey = null;
        this.contents = null;
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(Utils.toStream(aSN1Sequence));
    }

    public void input(InputStream inputStream) throws IOException {
        FIPS_140_2.assertReadyState();
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        PBEAlgorithmIdentifier pBEAlgorithmIdentifier = new PBEAlgorithmIdentifier(aSN1SequenceInputStream);
        try {
            this.pbe = PBE.getInstance(pBEAlgorithmIdentifier);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IOException(algorithmIdentifierException.toString());
        }
        this.encKey = ASN1OctetString.inputValue(aSN1SequenceInputStream);
        aSN1SequenceInputStream.terminate();
        this.key = null;
        this.contents = null;
    }

    public int length() {
        return this.getEncoded().length;
    }

    public void output(OutputStream outputStream) throws IOException {
        this.assertAllowExport();
        try {
            outputStream.write(this.getEncoded());
        }
        catch (StreamableOutputException streamableOutputException) {
            throw new IOException(streamableOutputException.toString());
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        FIPS_140_2.assertReadyState();
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    public void setAllowExport(boolean bl) {
        this.allowExport = bl;
    }

    public void setCount(int n) {
        FIPS_140_2.assertReadyState();
        try {
            PBEAlgorithmIdentifier pBEAlgorithmIdentifier = new PBEAlgorithmIdentifier(((PBEAlgorithmIdentifier)this.pbe.getAlgID()).getOID(), ((PBEAlgorithmIdentifier)this.pbe.getAlgID()).getSalt(), n);
            this.pbe.initialize(pBEAlgorithmIdentifier);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IllegalStateException(algorithmIdentifierException.toString());
        }
        if (this.key != null) {
            this.encKey = null;
        }
        this.contents = null;
    }

    public void setKey(PrivateKey privateKey) {
        this.setPrivateKey(privateKey);
    }

    public void setMode(int n) {
        block6: {
            FIPS_140_2.assertReadyState();
            try {
                if (n > 0) {
                    this.pbe = PBE.getInstance(new PBEAlgorithmIdentifier(new ASN1ObjectID(PBEAlgorithmIdentifier.pkcs12PBEids, n), this.getRBS()));
                    break block6;
                }
                if (n == 0) {
                    this.pbe = PBE.getInstance(new PBEAlgorithmIdentifier(PBEAlgorithmIdentifier.pbeWithMD5AndDES_CBC, this.getRBS()));
                    break block6;
                }
                if (n == -1) {
                    this.pbe = PBE.getInstance(new PBEAlgorithmIdentifier(PBEAlgorithmIdentifier.pbeWithMD2AndDES_CBC, this.getRBS()));
                    break block6;
                }
                throw new AlgorithmIdentifierException("Unknown mode");
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new IllegalStateException(algorithmIdentifierException.toString());
            }
        }
        if (this.key != null) {
            this.encKey = null;
        }
        this.contents = null;
    }

    public void setPassword(String string) {
        FIPS_140_2.assertReadyState();
        this.password = string;
        if (this.key != null) {
            this.encKey = null;
        }
        this.contents = null;
    }

    public PrivateKey setPrivateKey(PrivateKey privateKey) {
        FIPS_140_2.assertReadyState();
        PrivateKey privateKey2 = this.key;
        this.key = privateKey;
        this.encKey = null;
        this.contents = null;
        return privateKey2;
    }

    public void setSalt(byte[] byArray) {
        FIPS_140_2.assertReadyState();
        try {
            PBEAlgorithmIdentifier pBEAlgorithmIdentifier = new PBEAlgorithmIdentifier(((PBEAlgorithmIdentifier)this.pbe.getAlgID()).getOID(), byArray, ((PBEAlgorithmIdentifier)this.pbe.getAlgID()).getIterationCount());
            this.pbe.initialize(pBEAlgorithmIdentifier);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IllegalStateException(algorithmIdentifierException.toString());
        }
        if (this.key != null) {
            this.encKey = null;
        }
        this.contents = null;
    }

    public String toString() {
        FIPS_140_2.assertReadyState();
        return "pbeAlgID = {" + this.getPBEAlgID() + "}, keyAlgID = {" + this.getAlgID() + "}";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getEncoded());
    }
}

