/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.BlockCipher;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.Padding;
import com.phaos.crypto.RC2AlgorithmIdentifier;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.SymmetricKey;
import com.phaos.fips.FIPS_140_2;
import com.phaos.utils.Utils;

public final class RC2
extends BlockCipher {
    private static final int BLOCK_SIZE = 8;
    private static final byte[] sBox;
    private int effectiveKeyLength;
    private boolean effectiveKeyLength_specified = false;
    private short[] expKey;

    static {
        byte[] byArray = new byte[256];
        byArray[0] = -39;
        byArray[1] = 120;
        byArray[2] = -7;
        byArray[3] = -60;
        byArray[4] = 25;
        byArray[5] = -35;
        byArray[6] = -75;
        byArray[7] = -19;
        byArray[8] = 40;
        byArray[9] = -23;
        byArray[10] = -3;
        byArray[11] = 121;
        byArray[12] = 74;
        byArray[13] = -96;
        byArray[14] = -40;
        byArray[15] = -99;
        byArray[16] = -58;
        byArray[17] = 126;
        byArray[18] = 55;
        byArray[19] = -125;
        byArray[20] = 43;
        byArray[21] = 118;
        byArray[22] = 83;
        byArray[23] = -114;
        byArray[24] = 98;
        byArray[25] = 76;
        byArray[26] = 100;
        byArray[27] = -120;
        byArray[28] = 68;
        byArray[29] = -117;
        byArray[30] = -5;
        byArray[31] = -94;
        byArray[32] = 23;
        byArray[33] = -102;
        byArray[34] = 89;
        byArray[35] = -11;
        byArray[36] = -121;
        byArray[37] = -77;
        byArray[38] = 79;
        byArray[39] = 19;
        byArray[40] = 97;
        byArray[41] = 69;
        byArray[42] = 109;
        byArray[43] = -115;
        byArray[44] = 9;
        byArray[45] = -127;
        byArray[46] = 125;
        byArray[47] = 50;
        byArray[48] = -67;
        byArray[49] = -113;
        byArray[50] = 64;
        byArray[51] = -21;
        byArray[52] = -122;
        byArray[53] = -73;
        byArray[54] = 123;
        byArray[55] = 11;
        byArray[56] = -16;
        byArray[57] = -107;
        byArray[58] = 33;
        byArray[59] = 34;
        byArray[60] = 92;
        byArray[61] = 107;
        byArray[62] = 78;
        byArray[63] = -126;
        byArray[64] = 84;
        byArray[65] = -42;
        byArray[66] = 101;
        byArray[67] = -109;
        byArray[68] = -50;
        byArray[69] = 96;
        byArray[70] = -78;
        byArray[71] = 28;
        byArray[72] = 115;
        byArray[73] = 86;
        byArray[74] = -64;
        byArray[75] = 20;
        byArray[76] = -89;
        byArray[77] = -116;
        byArray[78] = -15;
        byArray[79] = -36;
        byArray[80] = 18;
        byArray[81] = 117;
        byArray[82] = -54;
        byArray[83] = 31;
        byArray[84] = 59;
        byArray[85] = -66;
        byArray[86] = -28;
        byArray[87] = -47;
        byArray[88] = 66;
        byArray[89] = 61;
        byArray[90] = -44;
        byArray[91] = 48;
        byArray[92] = -93;
        byArray[93] = 60;
        byArray[94] = -74;
        byArray[95] = 38;
        byArray[96] = 111;
        byArray[97] = -65;
        byArray[98] = 14;
        byArray[99] = -38;
        byArray[100] = 70;
        byArray[101] = 105;
        byArray[102] = 7;
        byArray[103] = 87;
        byArray[104] = 39;
        byArray[105] = -14;
        byArray[106] = 29;
        byArray[107] = -101;
        byArray[108] = -68;
        byArray[109] = -108;
        byArray[110] = 67;
        byArray[111] = 3;
        byArray[112] = -8;
        byArray[113] = 17;
        byArray[114] = -57;
        byArray[115] = -10;
        byArray[116] = -112;
        byArray[117] = -17;
        byArray[118] = 62;
        byArray[119] = -25;
        byArray[120] = 6;
        byArray[121] = -61;
        byArray[122] = -43;
        byArray[123] = 47;
        byArray[124] = -56;
        byArray[125] = 102;
        byArray[126] = 30;
        byArray[127] = -41;
        byArray[128] = 8;
        byArray[129] = -24;
        byArray[130] = -22;
        byArray[131] = -34;
        byArray[132] = -128;
        byArray[133] = 82;
        byArray[134] = -18;
        byArray[135] = -9;
        byArray[136] = -124;
        byArray[137] = -86;
        byArray[138] = 114;
        byArray[139] = -84;
        byArray[140] = 53;
        byArray[141] = 77;
        byArray[142] = 106;
        byArray[143] = 42;
        byArray[144] = -106;
        byArray[145] = 26;
        byArray[146] = -46;
        byArray[147] = 113;
        byArray[148] = 90;
        byArray[149] = 21;
        byArray[150] = 73;
        byArray[151] = 116;
        byArray[152] = 75;
        byArray[153] = -97;
        byArray[154] = -48;
        byArray[155] = 94;
        byArray[156] = 4;
        byArray[157] = 24;
        byArray[158] = -92;
        byArray[159] = -20;
        byArray[160] = -62;
        byArray[161] = -32;
        byArray[162] = 65;
        byArray[163] = 110;
        byArray[164] = 15;
        byArray[165] = 81;
        byArray[166] = -53;
        byArray[167] = -52;
        byArray[168] = 36;
        byArray[169] = -111;
        byArray[170] = -81;
        byArray[171] = 80;
        byArray[172] = -95;
        byArray[173] = -12;
        byArray[174] = 112;
        byArray[175] = 57;
        byArray[176] = -103;
        byArray[177] = 124;
        byArray[178] = 58;
        byArray[179] = -123;
        byArray[180] = 35;
        byArray[181] = -72;
        byArray[182] = -76;
        byArray[183] = 122;
        byArray[184] = -4;
        byArray[185] = 2;
        byArray[186] = 54;
        byArray[187] = 91;
        byArray[188] = 37;
        byArray[189] = 85;
        byArray[190] = -105;
        byArray[191] = 49;
        byArray[192] = 45;
        byArray[193] = 93;
        byArray[194] = -6;
        byArray[195] = -104;
        byArray[196] = -29;
        byArray[197] = -118;
        byArray[198] = -110;
        byArray[199] = -82;
        byArray[200] = 5;
        byArray[201] = -33;
        byArray[202] = 41;
        byArray[203] = 16;
        byArray[204] = 103;
        byArray[205] = 108;
        byArray[206] = -70;
        byArray[207] = -55;
        byArray[208] = -45;
        byArray[210] = -26;
        byArray[211] = -49;
        byArray[212] = -31;
        byArray[213] = -98;
        byArray[214] = -88;
        byArray[215] = 44;
        byArray[216] = 99;
        byArray[217] = 22;
        byArray[218] = 1;
        byArray[219] = 63;
        byArray[220] = 88;
        byArray[221] = -30;
        byArray[222] = -119;
        byArray[223] = -87;
        byArray[224] = 13;
        byArray[225] = 56;
        byArray[226] = 52;
        byArray[227] = 27;
        byArray[228] = -85;
        byArray[229] = 51;
        byArray[230] = -1;
        byArray[231] = -80;
        byArray[232] = -69;
        byArray[233] = 72;
        byArray[234] = 12;
        byArray[235] = 95;
        byArray[236] = -71;
        byArray[237] = -79;
        byArray[238] = -51;
        byArray[239] = 46;
        byArray[240] = -59;
        byArray[241] = -13;
        byArray[242] = -37;
        byArray[243] = 71;
        byArray[244] = -27;
        byArray[245] = -91;
        byArray[246] = -100;
        byArray[247] = 119;
        byArray[248] = 10;
        byArray[249] = -90;
        byArray[250] = 32;
        byArray[251] = 104;
        byArray[252] = -2;
        byArray[253] = 127;
        byArray[254] = -63;
        byArray[255] = -83;
        sBox = byArray;
    }

    public RC2() {
        super(8);
        this.mode = 1;
    }

    public String algName() {
        return "RC2";
    }

    protected void decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        short s = (short)(byArray[n++] & 0xFF | byArray[n++] << 8);
        short s2 = (short)(byArray[n++] & 0xFF | byArray[n++] << 8);
        short s3 = (short)(byArray[n++] & 0xFF | byArray[n++] << 8);
        short s4 = (short)(byArray[n++] & 0xFF | byArray[n++] << 8);
        int n3 = 63;
        while (n3 >= 0) {
            if (n3 == 19 | n3 == 43) {
                s4 = (short)(s4 - this.expKey[s3 & 0x3F]);
                s3 = (short)(s3 - this.expKey[s2 & 0x3F]);
                s2 = (short)(s2 - this.expKey[s & 0x3F]);
                s = (short)(s - this.expKey[s4 & 0x3F]);
            }
            s4 = (short)(Utils.rotrShort(s4, 5) - (s & ~s3) - (s2 & s3) - this.expKey[n3--]);
            s3 = (short)(Utils.rotrShort(s3, 3) - (s4 & ~s2) - (s & s2) - this.expKey[n3--]);
            s2 = (short)(Utils.rotrShort(s2, 2) - (s3 & ~s) - (s4 & s) - this.expKey[n3--]);
            s = (short)(Utils.rotrShort(s, 1) - (s2 & ~s4) - (s3 & s4) - this.expKey[n3--]);
        }
        byArray2[n2++] = (byte)s;
        byArray2[n2++] = (byte)(s >>> 8);
        byArray2[n2++] = (byte)s2;
        byArray2[n2++] = (byte)(s2 >>> 8);
        byArray2[n2++] = (byte)s3;
        byArray2[n2++] = (byte)(s3 >>> 8);
        byArray2[n2++] = (byte)s4;
        byArray2[n2++] = (byte)(s4 >>> 8);
    }

    protected void encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        short s = (short)(byArray[n++] & 0xFF | byArray[n++] << 8);
        short s2 = (short)(byArray[n++] & 0xFF | byArray[n++] << 8);
        short s3 = (short)(byArray[n++] & 0xFF | byArray[n++] << 8);
        short s4 = (short)(byArray[n++] & 0xFF | byArray[n++] << 8);
        int n3 = 0;
        while (n3 < 64) {
            s = Utils.rotlShort(s + (s2 & ~s4) + (s3 & s4) + this.expKey[n3++], 1);
            s2 = Utils.rotlShort(s2 + (s3 & ~s) + (s4 & s) + this.expKey[n3++], 2);
            s3 = Utils.rotlShort(s3 + (s4 & ~s2) + (s & s2) + this.expKey[n3++], 3);
            s4 = Utils.rotlShort(s4 + (s & ~s3) + (s2 & s3) + this.expKey[n3++], 5);
            if (!(n3 == 20 | n3 == 44)) continue;
            s = (short)(s + this.expKey[s4 & 0x3F]);
            s2 = (short)(s2 + this.expKey[s & 0x3F]);
            s3 = (short)(s3 + this.expKey[s2 & 0x3F]);
            s4 = (short)(s4 + this.expKey[s3 & 0x3F]);
        }
        byArray2[n2++] = (byte)s;
        byArray2[n2++] = (byte)(s >>> 8);
        byArray2[n2++] = (byte)s2;
        byArray2[n2++] = (byte)(s2 >>> 8);
        byArray2[n2++] = (byte)s3;
        byArray2[n2++] = (byte)(s3 >>> 8);
        byArray2[n2++] = (byte)s4;
        byArray2[n2++] = (byte)(s4 >>> 8);
    }

    public void erase() {
        super.erase();
        Utils.setArray(this.expKey, (short)0);
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        return new RC2AlgorithmIdentifier(this.getIV(), this.effectiveKeyLength);
    }

    public int getEffectiveKeyLength() {
        FIPS_140_2.assertReadyState();
        return this.effectiveKeyLength;
    }

    private void init(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        this.effectiveKeyLength_specified = false;
        this.effectiveKeyLength = 0;
        if (algorithmIdentifier.getOID().equals(AlgID.RC2_CBC.getOID())) {
            byte[] byArray = null;
            RC2AlgorithmIdentifier rC2AlgorithmIdentifier = null;
            rC2AlgorithmIdentifier = !(algorithmIdentifier instanceof RC2AlgorithmIdentifier) ? new RC2AlgorithmIdentifier(algorithmIdentifier.getOID(), algorithmIdentifier.getParameters()) : (RC2AlgorithmIdentifier)algorithmIdentifier;
            byArray = rC2AlgorithmIdentifier.getIV();
            int n = rC2AlgorithmIdentifier.getEffectiveKeyLength();
            if (n > 0) {
                this.effectiveKeyLength_specified = true;
                this.effectiveKeyLength = n;
            }
            if (byArray == null) {
                byArray = new byte[this.blockSize];
                this.getRBS().randomBytes(byArray);
            }
            try {
                this.setIV(byArray);
            }
            catch (CipherException cipherException) {
                throw new AlgorithmIdentifierException(cipherException.toString());
            }
        } else {
            throw new AlgorithmIdentifierException("Unknown AlgorithmIdentifier " + algorithmIdentifier + " for RC2");
        }
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey, Padding.ID iD, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        FIPS_140_2.assertReadyState();
        if (symmetricKey == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        if (iD == null) {
            throw new CipherException("The paddingID parameter cannot be null");
        }
        this.key = symmetricKey;
        this.rbs = randomBitsSource;
        this.init(algorithmIdentifier);
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
        this.paddingID = iD;
    }

    private void setKeyMaterial(SymmetricKey symmetricKey) throws InvalidKeyException {
        int n = Math.min(symmetricKey.getBytesInternal().length, 128);
        if (n < 1) {
            throw new InvalidKeyException("Invalid RC2 key.");
        }
        if (!this.effectiveKeyLength_specified) {
            this.effectiveKeyLength = n * 8;
        }
        int n2 = (this.effectiveKeyLength + 7) / 8;
        int n3 = 255 >> 8 * n2 - this.effectiveKeyLength;
        byte[] byArray = new byte[128];
        System.arraycopy(symmetricKey.getBytesInternal(), 0, byArray, 0, n);
        int n4 = n;
        while (n4 < 128) {
            byArray[n4] = sBox[byArray[n4 - 1] + byArray[n4 - n] & 0xFF];
            ++n4;
        }
        byArray[128 - n2] = sBox[byArray[128 - n2] & n3 & 0xFF];
        int n5 = 127 - n2;
        while (n5 >= 0) {
            byArray[n5] = sBox[(byArray[n5 + 1] ^ byArray[n5 + n2]) & 0xFF];
            --n5;
        }
        this.expKey = new short[64];
        int n6 = 0;
        while (n6 < 128) {
            this.expKey[n6 / 2] = (short)(byArray[n6 + 1] << 8 | byArray[n6] & 0xFF);
            n6 += 2;
        }
    }

    public String toString() {
        return this.algName();
    }
}

