/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Null;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import java.io.IOException;
import java.io.InputStream;

public class RC2AlgorithmIdentifier
extends AlgorithmIdentifier {
    private static final byte[] EKL_TO_VERSION_MAP;
    private static final ASN1ObjectID defaultOID;
    private byte[] iv;
    private int effectiveKeyLength;

    static {
        byte[] byArray = new byte[256];
        byArray[0] = -67;
        byArray[1] = 86;
        byArray[2] = -22;
        byArray[3] = -14;
        byArray[4] = -94;
        byArray[5] = -15;
        byArray[6] = -84;
        byArray[7] = 42;
        byArray[8] = -80;
        byArray[9] = -109;
        byArray[10] = -47;
        byArray[11] = -100;
        byArray[12] = 27;
        byArray[13] = 51;
        byArray[14] = -3;
        byArray[15] = -48;
        byArray[16] = 48;
        byArray[17] = 4;
        byArray[18] = -74;
        byArray[19] = -36;
        byArray[20] = 125;
        byArray[21] = -33;
        byArray[22] = 50;
        byArray[23] = 75;
        byArray[24] = -9;
        byArray[25] = -53;
        byArray[26] = 69;
        byArray[27] = -101;
        byArray[28] = 49;
        byArray[29] = -69;
        byArray[30] = 33;
        byArray[31] = 90;
        byArray[32] = 65;
        byArray[33] = -97;
        byArray[34] = -31;
        byArray[35] = -39;
        byArray[36] = 74;
        byArray[37] = 77;
        byArray[38] = -98;
        byArray[39] = -38;
        byArray[40] = -96;
        byArray[41] = 104;
        byArray[42] = 44;
        byArray[43] = -61;
        byArray[44] = 39;
        byArray[45] = 95;
        byArray[46] = -128;
        byArray[47] = 54;
        byArray[48] = 62;
        byArray[49] = -18;
        byArray[50] = -5;
        byArray[51] = -107;
        byArray[52] = 26;
        byArray[53] = -2;
        byArray[54] = -50;
        byArray[55] = -88;
        byArray[56] = 52;
        byArray[57] = -87;
        byArray[58] = 19;
        byArray[59] = -16;
        byArray[60] = -90;
        byArray[61] = 63;
        byArray[62] = -40;
        byArray[63] = 12;
        byArray[64] = 120;
        byArray[65] = 36;
        byArray[66] = -81;
        byArray[67] = 35;
        byArray[68] = 82;
        byArray[69] = -63;
        byArray[70] = 103;
        byArray[71] = 23;
        byArray[72] = -11;
        byArray[73] = 102;
        byArray[74] = -112;
        byArray[75] = -25;
        byArray[76] = -24;
        byArray[77] = 7;
        byArray[78] = -72;
        byArray[79] = 96;
        byArray[80] = 72;
        byArray[81] = -26;
        byArray[82] = 30;
        byArray[83] = 83;
        byArray[84] = -13;
        byArray[85] = -110;
        byArray[86] = -92;
        byArray[87] = 114;
        byArray[88] = -116;
        byArray[89] = 8;
        byArray[90] = 21;
        byArray[91] = 110;
        byArray[92] = -122;
        byArray[94] = -124;
        byArray[95] = -6;
        byArray[96] = -12;
        byArray[97] = 127;
        byArray[98] = -118;
        byArray[99] = 66;
        byArray[100] = 25;
        byArray[101] = -10;
        byArray[102] = -37;
        byArray[103] = -51;
        byArray[104] = 20;
        byArray[105] = -115;
        byArray[106] = 80;
        byArray[107] = 18;
        byArray[108] = -70;
        byArray[109] = 60;
        byArray[110] = 6;
        byArray[111] = 78;
        byArray[112] = -20;
        byArray[113] = -77;
        byArray[114] = 53;
        byArray[115] = 17;
        byArray[116] = -95;
        byArray[117] = -120;
        byArray[118] = -114;
        byArray[119] = 43;
        byArray[120] = -108;
        byArray[121] = -103;
        byArray[122] = -73;
        byArray[123] = 113;
        byArray[124] = 116;
        byArray[125] = -45;
        byArray[126] = -28;
        byArray[127] = -65;
        byArray[128] = 58;
        byArray[129] = -34;
        byArray[130] = -106;
        byArray[131] = 14;
        byArray[132] = -68;
        byArray[133] = 10;
        byArray[134] = -19;
        byArray[135] = 119;
        byArray[136] = -4;
        byArray[137] = 55;
        byArray[138] = 107;
        byArray[139] = 3;
        byArray[140] = 121;
        byArray[141] = -119;
        byArray[142] = 98;
        byArray[143] = -58;
        byArray[144] = -41;
        byArray[145] = -64;
        byArray[146] = -46;
        byArray[147] = 124;
        byArray[148] = 106;
        byArray[149] = -117;
        byArray[150] = 34;
        byArray[151] = -93;
        byArray[152] = 91;
        byArray[153] = 5;
        byArray[154] = 93;
        byArray[155] = 2;
        byArray[156] = 117;
        byArray[157] = -43;
        byArray[158] = 97;
        byArray[159] = -29;
        byArray[160] = 24;
        byArray[161] = -113;
        byArray[162] = 85;
        byArray[163] = 81;
        byArray[164] = -83;
        byArray[165] = 31;
        byArray[166] = 11;
        byArray[167] = 94;
        byArray[168] = -123;
        byArray[169] = -27;
        byArray[170] = -62;
        byArray[171] = 87;
        byArray[172] = 99;
        byArray[173] = -54;
        byArray[174] = 61;
        byArray[175] = 108;
        byArray[176] = -76;
        byArray[177] = -59;
        byArray[178] = -52;
        byArray[179] = 112;
        byArray[180] = -78;
        byArray[181] = -111;
        byArray[182] = 89;
        byArray[183] = 13;
        byArray[184] = 71;
        byArray[185] = 32;
        byArray[186] = -56;
        byArray[187] = 79;
        byArray[188] = 88;
        byArray[189] = -32;
        byArray[190] = 1;
        byArray[191] = -30;
        byArray[192] = 22;
        byArray[193] = 56;
        byArray[194] = -60;
        byArray[195] = 111;
        byArray[196] = 59;
        byArray[197] = 15;
        byArray[198] = 101;
        byArray[199] = 70;
        byArray[200] = -66;
        byArray[201] = 126;
        byArray[202] = 45;
        byArray[203] = 123;
        byArray[204] = -126;
        byArray[205] = -7;
        byArray[206] = 64;
        byArray[207] = -75;
        byArray[208] = 29;
        byArray[209] = 115;
        byArray[210] = -8;
        byArray[211] = -21;
        byArray[212] = 38;
        byArray[213] = -57;
        byArray[214] = -121;
        byArray[215] = -105;
        byArray[216] = 37;
        byArray[217] = 84;
        byArray[218] = -79;
        byArray[219] = 40;
        byArray[220] = -86;
        byArray[221] = -104;
        byArray[222] = -99;
        byArray[223] = -91;
        byArray[224] = 100;
        byArray[225] = 109;
        byArray[226] = 122;
        byArray[227] = -44;
        byArray[228] = 16;
        byArray[229] = -127;
        byArray[230] = 68;
        byArray[231] = -17;
        byArray[232] = 73;
        byArray[233] = -42;
        byArray[234] = -82;
        byArray[235] = 46;
        byArray[236] = -35;
        byArray[237] = 118;
        byArray[238] = 92;
        byArray[239] = 47;
        byArray[240] = -89;
        byArray[241] = 28;
        byArray[242] = -55;
        byArray[243] = 9;
        byArray[244] = 105;
        byArray[245] = -102;
        byArray[246] = -125;
        byArray[247] = -49;
        byArray[248] = 41;
        byArray[249] = 57;
        byArray[250] = -71;
        byArray[251] = -23;
        byArray[252] = 76;
        byArray[253] = -1;
        byArray[254] = 67;
        byArray[255] = -85;
        EKL_TO_VERSION_MAP = byArray;
        defaultOID = AlgID.RC2_CBC.getOID();
    }

    public RC2AlgorithmIdentifier(int n) {
        this(null, n);
    }

    public RC2AlgorithmIdentifier(ASN1ObjectID aSN1ObjectID, ASN1Object aSN1Object) throws AlgorithmIdentifierException {
        super(defaultOID, aSN1Object);
        if (!aSN1ObjectID.equals(defaultOID)) {
            throw new AlgorithmIdentifierException("Unacceptable OID for RC2ALgorithmIdentifier: " + aSN1ObjectID.toString());
        }
        this.decodeParameters();
    }

    public RC2AlgorithmIdentifier(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public RC2AlgorithmIdentifier(byte[] byArray, int n) {
        super(defaultOID, RC2AlgorithmIdentifier.makeParameters(byArray, n));
        this.iv = byArray;
        this.effectiveKeyLength = n;
    }

    public Object clone() {
        byte[] byArray = null;
        if (this.iv != null) {
            byArray = (byte[])this.iv.clone();
        }
        return new RC2AlgorithmIdentifier(byArray, this.effectiveKeyLength);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void decodeParameters() throws AlgorithmIdentifierException {
        ASN1Object aSN1Object = this.getParameters();
        if (aSN1Object == null || aSN1Object instanceof ASN1Null) {
            this.effectiveKeyLength = 0;
            this.iv = null;
            return;
        }
        if (aSN1Object instanceof ASN1OctetString) {
            this.effectiveKeyLength = 0;
            this.iv = ((ASN1OctetString)aSN1Object).getValue();
            return;
        }
        if (!(aSN1Object instanceof ASN1Sequence)) return;
        try {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Object;
            int n = ((ASN1Integer)aSN1Sequence.elementAt(0)).intValue();
            if (n < 0) {
                n &= 0xFF;
            }
            if (n >= 256 && n <= 1024) {
                this.effectiveKeyLength = n;
            } else {
                if (n < 0 || n > 256) throw new AlgorithmIdentifierException("Unknown RC2 parameter version: " + n);
                int n2 = 0;
                while (n2 < 256 && (EKL_TO_VERSION_MAP[n2] & 0xFF) != n) {
                    ++n2;
                }
                if (n2 >= 256) throw new AlgorithmIdentifierException("Unknown RC2 parameter version: " + n);
                this.effectiveKeyLength = n2;
            }
            if (aSN1Sequence.elementAt(1) instanceof ASN1OctetString) {
                this.iv = ((ASN1OctetString)aSN1Sequence.elementAt(1)).getValue();
                return;
            } else {
                if (!(aSN1Sequence.elementAt(1) instanceof ASN1Null) && aSN1Sequence.elementAt(1) != null) return;
                this.iv = null;
            }
            return;
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException(classCastException.toString());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new AlgorithmIdentifierException(arrayIndexOutOfBoundsException.toString());
        }
    }

    public int getEffectiveKeyLength() {
        return this.effectiveKeyLength;
    }

    public byte[] getIV() {
        return this.iv;
    }

    public void input(InputStream inputStream) throws IOException {
        super.input(inputStream);
        try {
            this.decodeParameters();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IOException(algorithmIdentifierException.toString());
        }
    }

    private static ASN1Object makeParameters(byte[] byArray, int n) {
        if (n == 32 || n == 0) {
            if (byArray == null) {
                return new ASN1Null();
            }
            return new ASN1OctetString(byArray);
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        if (n >= 0 && n < 256) {
            aSN1Sequence.addElement(new ASN1Integer(EKL_TO_VERSION_MAP[n] & 0xFF));
        } else if (n >= 256 && n <= 1024) {
            aSN1Sequence.addElement(new ASN1Integer(n));
        } else {
            throw new IllegalArgumentException("Invalid RC2 effective key length: " + n);
        }
        if (byArray == null) {
            aSN1Sequence.addElement(new ASN1Null());
        } else {
            aSN1Sequence.addElement(new ASN1OctetString(byArray));
        }
        return aSN1Sequence;
    }
}

