/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.RSAKey;
import com.phaos.crypto.RSAPrivateKey;
import com.phaos.crypto.RSAPublicKey;
import com.phaos.fips.FIPS_140_2;
import com.phaos.math.BigInt;
import java.math.BigInteger;

public final class RSA {
    private RSAKey key;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    BigInt performOp(BigInt bigInt) {
        FIPS_140_2.assertReadyState();
        if (this.key instanceof RSAPublicKey) {
            return bigInt.modPow(this.key.getExponentInternal(), this.key.getModulusInternal());
        }
        if (this.key instanceof RSAPrivateKey) {
            BigInt bigInt2;
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)this.key;
            BigInt bigInt3 = rSAPrivateKey.getModulusInternal();
            BigInt bigInt4 = rSAPrivateKey.getPrimePInternal();
            BigInt bigInt5 = rSAPrivateKey.getPrimeQInternal();
            BigInt bigInt6 = rSAPrivateKey.getPrimeExponentPInternal();
            BigInt bigInt7 = rSAPrivateKey.getPrimeExponentQInternal();
            BigInt bigInt8 = rSAPrivateKey.getCrtCoefficientInternal();
            if (bigInt4 == null || bigInt5 == null || bigInt6 == null || bigInt7 == null || bigInt8 == null) {
                return bigInt.modPow(rSAPrivateKey.getExponentInternal(), bigInt3);
            }
            BigInt bigInt9 = bigInt.mod(bigInt4).modPow(bigInt6, bigInt4);
            BigInt bigInt10 = bigInt9.subtract(bigInt2 = bigInt.mod(bigInt5).modPow(bigInt7, bigInt5));
            if (bigInt10.signum() == -1) {
                bigInt10 = bigInt10.add(bigInt4);
            }
            bigInt10 = (bigInt10 = bigInt10.multiply(bigInt8)).signum() >= 0 ? bigInt10.mod(bigInt4) : bigInt4.subtract(bigInt10.negate().mod(bigInt4));
            if ((bigInt10 = bigInt10.multiply(bigInt5).add(bigInt2)).compareTo(bigInt3) >= 0) {
                bigInt10 = bigInt10.subtract(bigInt3);
            }
            return bigInt10;
        }
        throw new IllegalStateException("Unknown key class");
    }

    public BigInteger performOp(BigInteger bigInteger) {
        return new BigInteger(this.performOp(BigInt.getInstance(bigInteger)).toByteArray());
    }

    public void setKey(RSAKey rSAKey) {
        FIPS_140_2.assertReadyState();
        this.key = rSAKey;
    }
}

