/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.crypto.Key;
import com.phaos.fips.FIPS_140_2;
import com.phaos.fips.KeyExportException;
import com.phaos.math.BigInt;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;

public abstract class RSAKey
implements Key,
ASN1Object {
    private BigInt modulus;
    private BigInt exponent;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    protected RSAKey() {
    }

    protected RSAKey(ASN1Sequence aSN1Sequence) throws IOException {
        this(Utils.toBytes(aSN1Sequence));
    }

    RSAKey(BigInt bigInt, BigInt bigInt2) {
        this.setModulusExponent(bigInt, bigInt2);
    }

    protected RSAKey(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    protected RSAKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this.setModulusExponent(bigInteger, bigInteger2);
    }

    protected RSAKey(byte[] byArray) throws IOException {
        this.setBytes(byArray);
    }

    protected void assertAllowExport() {
        if (!this.getAllowExport() || !FIPS_140_2.getAllowKeyExport()) {
            throw new KeyExportException("Plaintext key export not allowed");
        }
    }

    public abstract Object clone();

    public void erase() {
        if (this.exponent != null && !this.isPublic()) {
            this.exponent.erase();
        }
        this.exponent = null;
        this.modulus = null;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public abstract boolean getAllowExport();

    public int getBitLength() {
        FIPS_140_2.assertReadyState();
        if (this.modulus == null) {
            return 0;
        }
        return this.modulus.bitLength();
    }

    public abstract byte[] getEncoded();

    public BigInteger getExponent() {
        this.assertAllowExport();
        return new BigInteger(this.getExponentInternal().toByteArray());
    }

    BigInt getExponentInternal() {
        FIPS_140_2.assertReadyState();
        return this.exponent;
    }

    public abstract String getFormat();

    public BigInteger getModulus() {
        this.assertAllowExport();
        return new BigInteger(this.getModulusInternal().toByteArray());
    }

    BigInt getModulusInternal() {
        FIPS_140_2.assertReadyState();
        return this.modulus;
    }

    public abstract void input(InputStream var1) throws IOException;

    public abstract boolean isPublic();

    public abstract int length();

    public int modulusLength() {
        FIPS_140_2.assertReadyState();
        return Utils.length(this.modulus);
    }

    public abstract void output(OutputStream var1) throws IOException;

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        FIPS_140_2.assertReadyState();
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    public void setBytes(byte[] byArray) throws IOException {
        FIPS_140_2.assertReadyState();
        if (byArray.length != 0) {
            this.input(new UnsyncByteArrayInputStream(byArray));
        }
    }

    void setModulusExponent(BigInt bigInt, BigInt bigInt2) {
        FIPS_140_2.assertReadyState();
        this.erase();
        this.exponent = bigInt2;
        this.modulus = bigInt;
    }

    public void setModulusExponent(BigInteger bigInteger, BigInteger bigInteger2) {
        this.setModulusExponent(BigInt.getInstance(bigInteger), BigInt.getInstance(bigInteger2));
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.getEncoded());
    }
}

