/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.KeyPair;
import com.phaos.crypto.KeyPairGenerator;
import com.phaos.crypto.RSAPrivateKey;
import com.phaos.crypto.RSAPublicKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.fips.FIPS_140_2;
import com.phaos.math.BigInt;
import com.phaos.math.Prime;

public class RSAKeyPairGenerator
extends KeyPairGenerator {
    private int bits;
    private boolean initialized = false;

    public KeyPair generateKeyPair() {
        BigInt bigInt;
        BigInt bigInt2;
        BigInt bigInt3;
        BigInt bigInt4;
        BigInt bigInt5;
        BigInt bigInt6;
        BigInt bigInt7;
        if (!this.initialized) {
            throw new IllegalStateException("The generator is not initialized.");
        }
        FIPS_140_2.assertReadyState();
        BigInt bigInt8 = BigInt.valueOf(65537L);
        while (true) {
            if ((bigInt7 = Prime.generateBigIntPrime(this.bits / 2, this.rbs)).compareTo(bigInt6 = Prime.generateBigIntPrime(this.bits - bigInt7.bitLength(), this.rbs)) == 0) {
                continue;
            }
            bigInt5 = bigInt7.multiply(bigInt6);
            bigInt4 = bigInt7.subtract(BigInt.ONE);
            bigInt3 = bigInt6.subtract(BigInt.ONE);
            bigInt2 = bigInt4.multiply(bigInt3);
            if (bigInt5.bitLength() >= this.bits && bigInt5.gcd(bigInt2).compareTo(BigInt.ONE) == 0 && bigInt2.remainder(bigInt8).signum() != 0) break;
        }
        if (bigInt7.compareTo(bigInt6) < 0) {
            bigInt = bigInt7;
            bigInt7 = bigInt6;
            bigInt6 = bigInt;
            bigInt = bigInt4;
            bigInt4 = bigInt3;
            bigInt3 = bigInt;
        }
        bigInt = bigInt8.modInverse(bigInt2);
        BigInt bigInt9 = bigInt.remainder(bigInt4);
        BigInt bigInt10 = bigInt.remainder(bigInt3);
        BigInt bigInt11 = bigInt6.modInverse(bigInt7);
        RSAPublicKey rSAPublicKey = new RSAPublicKey(bigInt5, bigInt8);
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(bigInt5, bigInt, bigInt8, bigInt7, bigInt6, bigInt9, bigInt10, bigInt11);
        FIPS_140_2.testKeyPair(rSAPublicKey, rSAPrivateKey);
        bigInt4.erase();
        bigInt3.erase();
        return new KeyPair(rSAPublicKey, rSAPrivateKey);
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public void initialize(int n, RandomBitsSource randomBitsSource) {
        FIPS_140_2.assertReadyState();
        this.bits = n;
        this.setRandomBitsSource(randomBitsSource);
        this.initialized = true;
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        FIPS_140_2.assertReadyState();
        if (!algorithmIdentifier.getOID().equals(AlgID.rsaEncryption.getOID())) {
            throw new AlgorithmIdentifierException("Unknown RSA key algorithm identifier");
        }
    }
}

