/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.AuthenticationException;
import com.phaos.crypto.Cipher;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.DigestInfo;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PublicKey;
import com.phaos.crypto.RSAPrivateKey;
import com.phaos.crypto.RSAPublicKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.Signature;
import com.phaos.crypto.SignatureException;
import com.phaos.fips.FIPS_140_2;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;

public final class RSAMDSignature
extends Signature {
    public static final ASN1ObjectID rsaKeyOID = new ASN1ObjectID(ASN1Utils.pkcsID, 1, 1);
    public static final ASN1ObjectID rsaMD2SigOID = new ASN1ObjectID(ASN1Utils.pkcsID, 1, 2);
    public static final ASN1ObjectID rsaMD5SigOID = new ASN1ObjectID(ASN1Utils.pkcsID, 1, 4);
    public static final ASN1ObjectID rsaSHASigOID = new ASN1ObjectID(ASN1Utils.pkcsID, 1, 5);
    public static final ASN1ObjectID rsaSHASigOldOID = new ASN1ObjectID(ASN1Utils.oiwAlgID, 29);
    private RSAPublicKey publicKey;
    private RSAPrivateKey privateKey;
    private AlgorithmIdentifier messageDigestAlgID;
    private static AlgorithmIdentifier defaultAlgID = AlgID.md5;
    private RandomBitsSource rbs;
    private byte[] hash = null;

    public RSAMDSignature() {
        this.messageDigestAlgID = defaultAlgID;
    }

    public RSAMDSignature(RSAPrivateKey rSAPrivateKey) {
        this(rSAPrivateKey, defaultAlgID);
    }

    public RSAMDSignature(RSAPrivateKey rSAPrivateKey, AlgorithmIdentifier algorithmIdentifier) {
        this.privateKey = rSAPrivateKey;
        this.setMessageDigestAlgID(algorithmIdentifier);
    }

    public RSAMDSignature(RSAPrivateKey rSAPrivateKey, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws SignatureException {
        this(rSAPrivateKey, algorithmIdentifier);
        this.setDocument(byArray);
        this.sign();
    }

    public RSAMDSignature(RSAPrivateKey rSAPrivateKey, byte[] byArray) throws SignatureException {
        this(rSAPrivateKey, defaultAlgID, byArray);
    }

    public RSAMDSignature(RSAPublicKey rSAPublicKey) {
        this(rSAPublicKey, defaultAlgID);
    }

    public RSAMDSignature(RSAPublicKey rSAPublicKey, AlgorithmIdentifier algorithmIdentifier) {
        this.publicKey = rSAPublicKey;
        this.setMessageDigestAlgID(algorithmIdentifier);
    }

    public RSAMDSignature(RSAPublicKey rSAPublicKey, byte[] byArray, byte[] byArray2) {
        this(rSAPublicKey);
        this.setSigBytes(byArray);
        this.setDocument(byArray2);
    }

    public String algName() {
        if (this.messageDigestAlgID.equals(AlgID.md2)) {
            return "RSA/MD2";
        }
        if (this.messageDigestAlgID.equals(AlgID.md5)) {
            return "RSA/MD5";
        }
        if (this.messageDigestAlgID.equals(AlgID.sha_1)) {
            return "RSA/SHA";
        }
        throw new IllegalStateException("No appropriate algorithm identifier.");
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        if (this.messageDigestAlgID.equals(AlgID.md2)) {
            return AlgID.md2WithRSAEncryption;
        }
        if (this.messageDigestAlgID.equals(AlgID.md5)) {
            return AlgID.md5WithRSAEncryption;
        }
        if (this.messageDigestAlgID.equals(AlgID.sha_1)) {
            return AlgID.sha_1WithRSAEncryption;
        }
        throw new IllegalStateException("No appropriate algorithm identifier.");
    }

    public AlgorithmIdentifier getDigestEncryptionAlgID() {
        FIPS_140_2.assertReadyState();
        return AlgID.rsaEncryption;
    }

    public AlgorithmIdentifier getMessageDigestAlgID() {
        FIPS_140_2.assertReadyState();
        return this.messageDigestAlgID;
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        FIPS_140_2.assertReadyState();
        if (algorithmIdentifier.equals(AlgID.md2WithRSAEncryption)) {
            this.messageDigestAlgID = AlgID.md2;
        } else if (algorithmIdentifier.equals(AlgID.md5WithRSAEncryption)) {
            this.messageDigestAlgID = AlgID.md5;
        } else if (algorithmIdentifier.equals(AlgID.sha_1WithRSAEncryption)) {
            this.messageDigestAlgID = AlgID.sha_1;
        } else {
            throw new AlgorithmIdentifierException("Invalid AlgorithmIdentifier for RSAMDSignature");
        }
    }

    public void setHash(byte[] byArray) {
        FIPS_140_2.assertReadyState();
        this.hash = byArray;
        this.document = null;
    }

    public void setMessageDigestAlgID(AlgorithmIdentifier algorithmIdentifier) {
        FIPS_140_2.assertReadyState();
        this.messageDigestAlgID = algorithmIdentifier;
    }

    public void setPrivateKey(PrivateKey privateKey) throws InvalidKeyException {
        FIPS_140_2.assertReadyState();
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException();
        }
        this.privateKey = (RSAPrivateKey)privateKey;
    }

    public void setPublicKey(PublicKey publicKey) throws InvalidKeyException {
        FIPS_140_2.assertReadyState();
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException();
        }
        this.publicKey = (RSAPublicKey)publicKey;
    }

    public void setRandomBitsSource(RandomBitsSource randomBitsSource) {
        FIPS_140_2.assertReadyState();
        this.rbs = randomBitsSource;
    }

    public byte[] sign() throws SignatureException {
        FIPS_140_2.assertReadyState();
        try {
            Object object;
            byte[] byArray = null;
            if (this.hash != null) {
                byArray = this.hash;
            } else {
                object = MessageDigest.getInstance(this.messageDigestAlgID);
                ((MessageDigest)object).computeDigest(this.getDocument());
                byArray = Utils.toBytes(new DigestInfo(((MessageDigest)object).getAlgID(), ((MessageDigest)object).getDigestBitsInternal()));
            }
            object = Cipher.getInstance(AlgID.rsaEncryption, this.privateKey, this.rbs);
            this.setSigBytes(((Cipher)object).encrypt(byArray));
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new SignatureException(algorithmIdentifierException.toString());
        }
        catch (CipherException cipherException) {
            throw new SignatureException(cipherException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException(invalidKeyException.toString());
        }
        return this.getSigBytes();
    }

    public boolean verify() throws AuthenticationException {
        FIPS_140_2.assertReadyState();
        try {
            Object object;
            Object object2;
            Cipher cipher = Cipher.getInstance(AlgID.rsaEncryption, this.publicKey);
            byte[] byArray = null;
            byte[] byArray2 = null;
            if (this.hash != null) {
                byArray = this.hash;
                byArray2 = cipher.decrypt(this.getSigBytes());
            } else {
                MessageDigest messageDigest = MessageDigest.getInstance(this.messageDigestAlgID);
                messageDigest.update(this.getDocument());
                messageDigest.computeCurrent();
                byArray = messageDigest.getDigestBitsInternal();
                object2 = cipher.decrypt(this.getSigBytes());
                object = new UnsyncByteArrayInputStream((byte[])object2);
                DigestInfo digestInfo = new DigestInfo((InputStream)object);
                if (!digestInfo.getDigestAlgID().equals(this.messageDigestAlgID)) {
                    throw new AuthenticationException("Signature has unexpected MD type");
                }
                byArray2 = digestInfo.getDigest();
            }
            cipher.erase();
            boolean bl = Utils.areEqual(byArray, byArray2);
            if (bl || this.hash == null) {
                return bl;
            }
            try {
                object2 = new DigestInfo(new UnsyncByteArrayInputStream(this.hash));
                object = new DigestInfo(new UnsyncByteArrayInputStream(byArray2));
                if (!((DigestInfo)object2).getDigestAlgID().equals(((DigestInfo)object).getDigestAlgID())) {
                    return false;
                }
                return Utils.areEqual(((DigestInfo)object2).getDigest(), ((DigestInfo)object).getDigest());
            }
            catch (IOException iOException) {
                return false;
            }
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new AuthenticationException(algorithmIdentifierException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new AuthenticationException(classCastException.toString());
        }
        catch (CipherException cipherException) {
            throw new AuthenticationException(cipherException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AuthenticationException(invalidKeyException.toString());
        }
        catch (IOException iOException) {
            throw new AuthenticationException(iOException.toString());
        }
    }
}

