/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Null;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.RSAKey;
import com.phaos.crypto.RSAPublicKey;
import com.phaos.fips.FIPS_140_2;
import com.phaos.math.BigInt;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import com.phaos.utils.VersionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class RSAPrivateKey
extends RSAKey
implements PrivateKey {
    private AlgorithmIdentifier algID;
    private BigInt publicExponent;
    private BigInt prime1;
    private BigInt prime2;
    private BigInt exponent1;
    private BigInt exponent2;
    private BigInt coefficient;
    private boolean allowExport = true;
    private ASN1Sequence keyContents;
    private ASN1Sequence keyContentsInternal;
    private byte[] pkiBytes;

    public RSAPrivateKey() {
    }

    RSAPrivateKey(BigInt bigInt, BigInt bigInt2) {
        super(bigInt, bigInt2);
    }

    RSAPrivateKey(BigInt bigInt, BigInt bigInt2, BigInt bigInt3, BigInt bigInt4, BigInt bigInt5, BigInt bigInt6, BigInt bigInt7, BigInt bigInt8) {
        super(bigInt, bigInt2);
        this.publicExponent = bigInt3;
        this.prime1 = bigInt4;
        this.prime2 = bigInt5;
        this.exponent1 = bigInt6;
        this.exponent2 = bigInt7;
        this.coefficient = bigInt8;
        this.getContentsInternal();
        this.checkPandQ();
    }

    public RSAPrivateKey(File file) throws FileNotFoundException, IOException {
        this(new FileInputStream(file));
    }

    public RSAPrivateKey(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) {
        super(bigInteger, bigInteger2);
    }

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        this(BigInt.getInstance(bigInteger), BigInt.getInstance(bigInteger2), BigInt.getInstance(bigInteger3), BigInt.getInstance(bigInteger4), BigInt.getInstance(bigInteger5), BigInt.getInstance(bigInteger6), BigInt.getInstance(bigInteger7), BigInt.getInstance(bigInteger8));
    }

    public RSAPrivateKey(byte[] byArray) throws IOException {
        this(new UnsyncByteArrayInputStream(byArray));
    }

    private void checkPandQ() {
        if (this.prime1.compareTo(this.prime2) < 0) {
            BigInt bigInt = this.prime1;
            this.prime1 = this.prime2;
            this.prime2 = bigInt;
            bigInt = this.exponent1;
            this.exponent1 = this.exponent2;
            this.exponent2 = bigInt;
            this.coefficient = this.prime2.modInverse(this.prime1);
        }
    }

    private void clearOutputCache() {
        if (this.pkiBytes != null) {
            Utils.setArray(this.pkiBytes, (byte)0);
            this.pkiBytes = null;
        }
        this.keyContents = null;
        if (this.keyContentsInternal != null) {
            ((ASN1Integer)this.keyContentsInternal.elementAt(3)).erase();
            ((ASN1Integer)this.keyContentsInternal.elementAt(4)).erase();
            ((ASN1Integer)this.keyContentsInternal.elementAt(5)).erase();
            ((ASN1Integer)this.keyContentsInternal.elementAt(6)).erase();
            ((ASN1Integer)this.keyContentsInternal.elementAt(7)).erase();
            ((ASN1Integer)this.keyContentsInternal.elementAt(8)).erase();
            this.keyContentsInternal = null;
        }
    }

    public Object clone() {
        BigInt bigInt;
        FIPS_140_2.assertReadyState();
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey();
        try {
            if (this.algID != null) {
                rSAPrivateKey.algID = new AlgorithmIdentifier(Utils.toStream(this.algID));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing algorithm identifier to stream");
        }
        BigInt bigInt2 = this.getModulusInternal();
        if (bigInt2 != null) {
            bigInt2 = BigInt.getInstance(bigInt2);
        }
        if ((bigInt = this.getExponentInternal()) != null) {
            bigInt = BigInt.getInstance(bigInt);
        }
        rSAPrivateKey.setModulusExponent(bigInt2, bigInt);
        if (this.publicExponent != null) {
            rSAPrivateKey.publicExponent = BigInt.getInstance(this.publicExponent);
        }
        if (this.prime1 != null) {
            rSAPrivateKey.prime1 = BigInt.getInstance(this.prime1);
        }
        if (this.prime2 != null) {
            rSAPrivateKey.prime2 = BigInt.getInstance(this.prime2);
        }
        if (this.exponent1 != null) {
            rSAPrivateKey.exponent1 = BigInt.getInstance(this.exponent1);
        }
        if (this.exponent2 != null) {
            rSAPrivateKey.exponent2 = BigInt.getInstance(this.exponent2);
        }
        if (this.coefficient != null) {
            rSAPrivateKey.coefficient = BigInt.getInstance(this.coefficient);
        }
        rSAPrivateKey.allowExport = this.allowExport;
        return rSAPrivateKey;
    }

    public void erase() {
        super.erase();
        this.clearOutputCache();
        this.publicExponent = null;
        if (this.prime1 != null) {
            this.prime1.erase();
            this.prime1 = null;
        }
        if (this.prime2 != null) {
            this.prime2.erase();
            this.prime2 = null;
        }
        if (this.exponent1 != null) {
            this.exponent1.erase();
            this.exponent1 = null;
        }
        if (this.exponent2 != null) {
            this.exponent2.erase();
            this.exponent2 = null;
        }
        if (this.coefficient != null) {
            this.coefficient.erase();
            this.coefficient = null;
        }
    }

    public void finalize() {
        this.erase();
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        if (this.algID == null) {
            this.algID = AlgID.rsaEncryption;
        }
        return this.algID;
    }

    public boolean getAllowExport() {
        return this.allowExport;
    }

    public ASN1Object getContents() {
        this.assertAllowExport();
        FIPS_140_2.assertReadyState();
        if (this.keyContents == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)this.getContentsInternal();
            int n = 0;
            int n2 = aSN1Sequence2.size();
            while (n < n2) {
                ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence2.elementAt(n);
                aSN1Sequence.addElement(new ASN1Integer(BigInt.getInstance(aSN1Integer.getBigIntValue())));
                ++n;
            }
            this.keyContents = aSN1Sequence;
        }
        return this.keyContents;
    }

    ASN1Object getContentsInternal() {
        FIPS_140_2.assertReadyState();
        if (this.keyContentsInternal == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            try {
                aSN1Sequence.addElement(new ASN1Integer(0L));
                aSN1Sequence.addElement(new ASN1Integer(this.getModulusInternal()));
                aSN1Sequence.addElement(new ASN1Integer(this.publicExponent));
                aSN1Sequence.addElement(new ASN1Integer(this.getExponentInternal()));
                aSN1Sequence.addElement(new ASN1Integer(this.prime1));
                aSN1Sequence.addElement(new ASN1Integer(this.prime2));
                aSN1Sequence.addElement(new ASN1Integer(this.exponent1));
                aSN1Sequence.addElement(new ASN1Integer(this.exponent2));
                aSN1Sequence.addElement(new ASN1Integer(this.coefficient));
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalStateException("Complete CRT representation required for ASN.1 output");
            }
            this.keyContentsInternal = aSN1Sequence;
        }
        return this.keyContentsInternal;
    }

    public BigInteger getCrtCoefficient() {
        this.assertAllowExport();
        FIPS_140_2.assertReadyState();
        return new BigInteger(this.coefficient.toByteArray());
    }

    BigInt getCrtCoefficientInternal() {
        FIPS_140_2.assertReadyState();
        return this.coefficient;
    }

    public byte[] getEncoded() {
        this.assertAllowExport();
        return (byte[])this.getEncodedInternal().clone();
    }

    byte[] getEncodedInternal() {
        FIPS_140_2.assertReadyState();
        if (this.pkiBytes == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(new ASN1Integer(0L));
            aSN1Sequence.addElement(this.getAlgID());
            aSN1Sequence.addElement(new ASN1OctetString(Utils.toBytes(this.getContentsInternal())));
            this.pkiBytes = Utils.toBytes(aSN1Sequence);
        }
        return this.pkiBytes;
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public BigInteger getPrimeExponentP() {
        this.assertAllowExport();
        FIPS_140_2.assertReadyState();
        return new BigInteger(this.exponent1.toByteArray());
    }

    BigInt getPrimeExponentPInternal() {
        FIPS_140_2.assertReadyState();
        return this.exponent1;
    }

    public BigInteger getPrimeExponentQ() {
        this.assertAllowExport();
        FIPS_140_2.assertReadyState();
        return new BigInteger(this.exponent2.toByteArray());
    }

    BigInt getPrimeExponentQInternal() {
        FIPS_140_2.assertReadyState();
        return this.exponent2;
    }

    public BigInteger getPrimeP() {
        this.assertAllowExport();
        FIPS_140_2.assertReadyState();
        return new BigInteger(this.prime1.toByteArray());
    }

    BigInt getPrimePInternal() {
        FIPS_140_2.assertReadyState();
        return this.prime1;
    }

    public BigInteger getPrimeQ() {
        this.assertAllowExport();
        FIPS_140_2.assertReadyState();
        return new BigInteger(this.prime2.toByteArray());
    }

    BigInt getPrimeQInternal() {
        FIPS_140_2.assertReadyState();
        return this.prime2;
    }

    public BigInteger getPublicExponent() {
        FIPS_140_2.assertReadyState();
        return new BigInteger(this.publicExponent.toByteArray());
    }

    BigInt getPublicExponentInternal() {
        FIPS_140_2.assertReadyState();
        return this.publicExponent;
    }

    public RSAPublicKey getPublicKey() {
        return new RSAPublicKey(this.getModulusInternal(), this.getPublicExponentInternal());
    }

    private void initialize(ASN1Object aSN1Object) throws InvalidInputException {
        this.erase();
        try {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Object;
            ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.elementAt(0);
            if (!aSN1Integer.equals(0)) {
                throw new VersionException(aSN1Integer.getValue(), 0);
            }
            BigInt bigInt = ((ASN1Integer)aSN1Sequence.elementAt(1)).getBigIntValue();
            BigInt bigInt2 = ((ASN1Integer)aSN1Sequence.elementAt(3)).getBigIntValue();
            this.setModulusExponent(bigInt, bigInt2);
            this.publicExponent = ((ASN1Integer)aSN1Sequence.elementAt(2)).getBigIntValue();
            this.prime1 = ((ASN1Integer)aSN1Sequence.elementAt(4)).getBigIntValue();
            this.prime2 = ((ASN1Integer)aSN1Sequence.elementAt(5)).getBigIntValue();
            this.exponent1 = ((ASN1Integer)aSN1Sequence.elementAt(6)).getBigIntValue();
            this.exponent2 = ((ASN1Integer)aSN1Sequence.elementAt(7)).getBigIntValue();
            this.coefficient = ((ASN1Integer)aSN1Sequence.elementAt(8)).getBigIntValue();
        }
        catch (VersionException versionException) {
            throw new InvalidInputException(versionException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException.toString());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new InvalidInputException(arrayIndexOutOfBoundsException.toString());
        }
        this.algID = null;
        this.getContentsInternal();
        this.checkPandQ();
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws AlgorithmIdentifierException, InvalidInputException {
        FIPS_140_2.assertReadyState();
        ASN1Object aSN1Object2 = algorithmIdentifier.getParameters();
        if (aSN1Object2 != null && !(aSN1Object2 instanceof ASN1Null)) {
            throw new AlgorithmIdentifierException();
        }
        this.initialize(aSN1Object);
        this.algID = algorithmIdentifier;
    }

    public void input(InputStream inputStream) throws IOException {
        block6: {
            FIPS_140_2.assertReadyState();
            try {
                ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
                if (aSN1Sequence.size() == 3 || aSN1Sequence.size() == 4) {
                    ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.elementAt(0);
                    if (!aSN1Integer.equals(0)) {
                        throw new VersionException(aSN1Integer.getValue(), 0);
                    }
                    AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.elementAt(1));
                    ASN1Object aSN1Object = ASN1Utils.inputASN1Object(((ASN1OctetString)aSN1Sequence.elementAt(2)).getValue());
                    this.initialize(algorithmIdentifier, aSN1Object);
                    ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Object;
                    ((ASN1Integer)aSN1Sequence2.elementAt(3)).erase();
                    ((ASN1Integer)aSN1Sequence2.elementAt(4)).erase();
                    ((ASN1Integer)aSN1Sequence2.elementAt(5)).erase();
                    ((ASN1Integer)aSN1Sequence2.elementAt(6)).erase();
                    ((ASN1Integer)aSN1Sequence2.elementAt(7)).erase();
                    ((ASN1Integer)aSN1Sequence2.elementAt(8)).erase();
                    break block6;
                }
                if (aSN1Sequence.size() == 9) {
                    this.initialize(aSN1Sequence);
                    ((ASN1Integer)aSN1Sequence.elementAt(3)).erase();
                    ((ASN1Integer)aSN1Sequence.elementAt(4)).erase();
                    ((ASN1Integer)aSN1Sequence.elementAt(5)).erase();
                    ((ASN1Integer)aSN1Sequence.elementAt(6)).erase();
                    ((ASN1Integer)aSN1Sequence.elementAt(7)).erase();
                    ((ASN1Integer)aSN1Sequence.elementAt(8)).erase();
                    break block6;
                }
                throw new ASN1FormatException("Sequence has wrong number of components.");
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new InvalidInputException(algorithmIdentifierException.toString());
            }
            catch (ClassCastException classCastException) {
                throw new InvalidInputException(classCastException.toString());
            }
        }
    }

    public boolean isPublic() {
        return false;
    }

    public int length() {
        return this.getEncodedInternal().length;
    }

    public void output(OutputStream outputStream) throws IOException {
        outputStream.write(this.getEncoded());
    }

    public void setAllowExport(boolean bl) {
        this.allowExport = bl;
    }

    public String toString() {
        FIPS_140_2.assertReadyState();
        return "{ modulus = " + this.getAlgID() + ", " + "publicExponent = " + this.getPublicExponentInternal() + " }";
    }
}

