/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1BitString;
import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Null;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.PublicKey;
import com.phaos.crypto.RSAKey;
import com.phaos.fips.FIPS_140_2;
import com.phaos.math.BigInt;
import com.phaos.utils.CryptoUtils;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;

public class RSAPublicKey
extends RSAKey
implements PublicKey {
    private AlgorithmIdentifier algID;
    private ASN1Sequence keyContents;
    private byte[] spkiBytes;

    public RSAPublicKey() {
    }

    RSAPublicKey(BigInt bigInt, BigInt bigInt2) {
        super(bigInt, bigInt2);
    }

    public RSAPublicKey(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public RSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        super(bigInteger, bigInteger2);
    }

    public RSAPublicKey(byte[] byArray) throws IOException {
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    private void clearOutputCache() {
        this.spkiBytes = null;
        this.keyContents = null;
    }

    public Object clone() {
        BigInt bigInt;
        FIPS_140_2.assertReadyState();
        RSAPublicKey rSAPublicKey = new RSAPublicKey();
        try {
            if (this.algID != null) {
                rSAPublicKey.algID = new AlgorithmIdentifier(Utils.toStream(this.algID));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing algorithm identifier to stream");
        }
        BigInt bigInt2 = this.getModulusInternal();
        if (bigInt2 != null) {
            bigInt2 = BigInt.getInstance(bigInt2);
        }
        if ((bigInt = this.getExponentInternal()) != null) {
            bigInt = BigInt.getInstance(bigInt);
        }
        rSAPublicKey.setModulusExponent(bigInt2, bigInt);
        return rSAPublicKey;
    }

    public void erase() {
        super.erase();
        this.clearOutputCache();
    }

    public void finalize() {
        this.erase();
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        if (this.algID == null) {
            this.algID = AlgID.rsaEncryption;
        }
        return this.algID;
    }

    public boolean getAllowExport() {
        return true;
    }

    public ASN1Object getContents() {
        FIPS_140_2.assertReadyState();
        if (this.keyContents == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(new ASN1Integer(this.getModulusInternal()));
            aSN1Sequence.addElement(new ASN1Integer(this.getExponentInternal()));
            this.keyContents = aSN1Sequence;
        }
        return this.keyContents;
    }

    public byte[] getEncoded() {
        FIPS_140_2.assertReadyState();
        if (this.spkiBytes == null) {
            ASN1Sequence aSN1Sequence = CryptoUtils.subjectPublicKeyInfo(this);
            this.spkiBytes = Utils.toBytes(aSN1Sequence);
        }
        return this.spkiBytes;
    }

    public String getFormat() {
        return "X.509";
    }

    private void initialize(ASN1Object aSN1Object) throws InvalidInputException {
        ASN1Sequence aSN1Sequence;
        try {
            aSN1Sequence = (ASN1Sequence)aSN1Object;
            BigInt bigInt = ((ASN1Integer)aSN1Sequence.elementAt(0)).getBigIntValue();
            BigInt bigInt2 = ((ASN1Integer)aSN1Sequence.elementAt(1)).getBigIntValue();
            this.setModulusExponent(bigInt, bigInt2);
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException.toString());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new InvalidInputException(arrayIndexOutOfBoundsException.toString());
        }
        this.algID = null;
        this.clearOutputCache();
        this.keyContents = aSN1Sequence;
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws AlgorithmIdentifierException, InvalidInputException {
        FIPS_140_2.assertReadyState();
        ASN1Object aSN1Object2 = algorithmIdentifier.getParameters();
        if (aSN1Object2 != null && !(aSN1Object2 instanceof ASN1Null)) {
            throw new AlgorithmIdentifierException();
        }
        this.initialize(aSN1Object);
        this.algID = algorithmIdentifier;
    }

    public void input(InputStream inputStream) throws IOException {
        FIPS_140_2.assertReadyState();
        try {
            ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
            if (aSN1Sequence.size() != 2) {
                throw new ASN1FormatException("Sequence has wrong number of components.");
            }
            if (aSN1Sequence.elementAt(0) instanceof ASN1Integer) {
                this.initialize(aSN1Sequence);
            } else {
                AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.elementAt(0));
                ASN1Object aSN1Object = ASN1Utils.inputASN1Object(((ASN1BitString)aSN1Sequence.elementAt(1)).getValue());
                this.initialize(algorithmIdentifier, aSN1Object);
            }
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new InvalidInputException(algorithmIdentifierException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException.toString());
        }
    }

    public boolean isPublic() {
        return true;
    }

    public int length() {
        return this.getEncoded().length;
    }

    public void output(OutputStream outputStream) throws IOException {
        outputStream.write(this.getEncoded());
    }

    public String toString() {
        FIPS_140_2.assertReadyState();
        return "{ modulus = " + this.getModulusInternal() + ", exponent = " + this.getExponentInternal() + " }";
    }
}

