/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Null;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.Cipher;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.Key;
import com.phaos.crypto.MaskException;
import com.phaos.crypto.MaskGenerator;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.OAEPAlgorithmIdentifier;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.RSA;
import com.phaos.crypto.RSAKey;
import com.phaos.crypto.RSAPrivateKey;
import com.phaos.crypto.RSAPublicKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.SymmetricKey;
import com.phaos.fips.FIPS_140_2;
import com.phaos.math.BigInt;
import com.phaos.utils.Utils;

public final class RSApkcs1
extends Cipher {
    private static final int ENCODING_OAEP = 0;
    private static final int ENCODING_V15 = 1;
    private MaskGenerator oaepMaskGenerator;
    private MessageDigest oaepDigest;
    private int encodingScheme = 1;
    private byte[] p;

    public String algName() {
        switch (this.encodingScheme) {
            case 0: {
                return "RSAES-OAEP";
            }
            case 1: {
                return "RSAES-PKCS1-v1_5";
            }
        }
        return "Unknown encoding method: " + this.encodingScheme;
    }

    private byte[] decodeOAEP(byte[] byArray) throws CipherException {
        int n = byArray.length;
        if (this.oaepDigest == null) {
            throw new CipherException("The OAEP encoding method requires a MessageDigest instance, the MessageDigest of this instance has been explicitly set to null");
        }
        if (this.oaepMaskGenerator == null) {
            throw new CipherException("The OAEP encoding method requires a MaskGenerator instance, the MaskGenerator of this instance has been explicitly set to null");
        }
        int n2 = this.oaepDigest.getDigestLength();
        if (n < 2 * n2 + 1) {
            throw new CipherException("Decoding error");
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        int n3 = n - n2;
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray, n2, byArray3, 0, n3);
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        try {
            byArray4 = Utils.xor(byArray2, this.oaepMaskGenerator.generateMask(byArray3, n2));
            byArray5 = Utils.xor(byArray3, this.oaepMaskGenerator.generateMask(byArray4, n3));
        }
        catch (MaskException maskException) {
            throw new CipherException(maskException.toString());
        }
        byte[] byArray6 = new byte[n2];
        System.arraycopy(byArray5, 0, byArray6, 0, n2);
        this.oaepDigest.init();
        if (this.p != null) {
            this.oaepDigest.update(this.p);
        }
        this.oaepDigest.computeCurrent();
        if (!Utils.areEqual(byArray6, this.oaepDigest.getDigestBits())) {
            throw new CipherException("Decoding error");
        }
        int n4 = n2;
        while (n4 < n3 && byArray5[n4] == 0) {
            ++n4;
        }
        if (n4 == n3 || byArray5[n4] != 1) {
            throw new CipherException("Decoding error");
        }
        byte[] byArray7 = new byte[n3 - n4 - 1];
        System.arraycopy(byArray5, n4 + 1, byArray7, 0, byArray7.length);
        return byArray7;
    }

    private byte[] decodeV15(byte[] byArray) throws CipherException {
        int n;
        int n2 = byArray.length;
        if (n2 < 10 || byArray[0] != 2 && byArray[0] != 1) {
            throw new CipherException("Decoding error");
        }
        if (byArray[0] == 1 && !((RSAKey)this.key).isPublic()) {
            throw new CipherException("Decoding error");
        }
        if (byArray[0] == 2 && ((RSAKey)this.key).isPublic()) {
            throw new CipherException("Decoding error");
        }
        if (byArray[0] == 1) {
            n = 1;
            while (n < n2 && byArray[n] != 0) {
                if ((byArray[n] & 0xFF) != 255) {
                    throw new CipherException("Decoding error");
                }
                ++n;
            }
        } else {
            n = 1;
            while (n < n2 && byArray[n] != 0) {
                ++n;
            }
        }
        if (n == n2 || n < 9) {
            throw new CipherException("Decoding error");
        }
        byte[] byArray2 = new byte[n2 - n - 1];
        System.arraycopy(byArray, n + 1, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public byte[] decrypt(byte[] byArray, int n, int n2, boolean bl) throws CipherException {
        this.assertDecryption();
        return this.decryption(byArray, n, n2, false);
    }

    public void decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws CipherException {
        byte[] byArray3 = this.decrypt(byArray, n, n2);
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
    }

    private byte[] decryption(byte[] byArray, int n, int n2, boolean bl) throws CipherException {
        FIPS_140_2.assertReadyState();
        RSAKey rSAKey = (RSAKey)this.key;
        BigInt bigInt = rSAKey.getModulusInternal();
        int n3 = Utils.length(bigInt);
        byte[] byArray2 = null;
        if (n == 0 && n2 == byArray.length) {
            byArray2 = byArray;
        } else {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
        }
        if (byArray2.length != n3) {
            throw new CipherException("Decryption error");
        }
        BigInt bigInt2 = new BigInt(1, byArray2);
        if (bigInt2.compareTo(bigInt) >= 0) {
            throw new CipherException("Decryption error");
        }
        RSA rSA = new RSA();
        rSA.setKey(rSAKey);
        BigInt bigInt3 = rSA.performOp(bigInt2);
        if (bigInt3.compareTo(BigInt.valueOf(256L).pow(n3 - 1)) >= 0) {
            throw new CipherException("Decryption error");
        }
        byte[] byArray3 = Utils.toByteArray(bigInt3);
        byte[] byArray4 = new byte[n3 - 1];
        System.arraycopy(byArray3, 0, byArray4, byArray4.length - byArray3.length, byArray3.length);
        try {
            switch (this.encodingScheme) {
                case 0: {
                    return this.decodeOAEP(byArray4);
                }
                case 1: {
                    return this.decodeV15(byArray4);
                }
            }
            throw new CipherException("Unknown encoding method");
        }
        catch (CipherException cipherException) {
            throw new CipherException("Decryption error");
        }
    }

    private byte[] encodeOAEP(byte[] byArray, int n) throws CipherException {
        if (this.oaepDigest == null) {
            throw new CipherException("The OAEP encoding method requires a MessageDigest instance, the MessageDigest of this instance has not been configured");
        }
        if (this.oaepMaskGenerator == null) {
            throw new CipherException("The OAEP encoding method requires a MaskGenerator instance, the MaskGenerator of this instance has not been configured");
        }
        int n2 = byArray.length;
        int n3 = this.oaepDigest.getDigestLength();
        if (n2 > n - 2 * n3 - 1) {
            throw new CipherException("Message too long");
        }
        this.oaepDigest.init();
        if (this.p != null) {
            this.oaepDigest.update(this.p);
        }
        this.oaepDigest.computeCurrent();
        byte[] byArray2 = new byte[n - n3];
        System.arraycopy(this.oaepDigest.getDigestBits(), 0, byArray2, 0, n3);
        byArray2[byArray2.length - n2 - 1] = 1;
        System.arraycopy(byArray, 0, byArray2, byArray2.length - n2, n2);
        byte[] byArray3 = new byte[n3];
        this.getRBS().randomBytes(byArray3);
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        try {
            byArray4 = Utils.xor(byArray2, this.oaepMaskGenerator.generateMask(byArray3, byArray2.length));
            byArray5 = Utils.xor(byArray3, this.oaepMaskGenerator.generateMask(byArray4, n3));
        }
        catch (MaskException maskException) {
            throw new CipherException(maskException.toString());
        }
        byte[] byArray6 = new byte[n];
        System.arraycopy(byArray5, 0, byArray6, 0, n3);
        System.arraycopy(byArray4, 0, byArray6, n3, byArray4.length);
        return byArray6;
    }

    private byte[] encodeV15(byte[] byArray, int n) throws CipherException {
        int n2 = byArray.length;
        int n3 = n - n2;
        if (n3 < 10) {
            throw new CipherException("Message too long");
        }
        byte[] byArray2 = new byte[n];
        if (((RSAKey)this.key).isPublic()) {
            RandomBitsSource randomBitsSource = this.getRBS();
            byArray2[0] = 2;
            int n4 = 1;
            while (n4 < n3 - 1) {
                byte by = randomBitsSource.randomByte();
                while (by == 0) {
                    by = randomBitsSource.randomByte();
                }
                byArray2[n4] = by;
                ++n4;
            }
        } else {
            byArray2[0] = 1;
            int n5 = 1;
            while (n5 < n3 - 1) {
                byArray2[n5] = -1;
                ++n5;
            }
        }
        byArray2[n3 - 1] = 0;
        System.arraycopy(byArray, 0, byArray2, n3, n2);
        return byArray2;
    }

    public byte[] encrypt(byte[] byArray, int n, int n2, boolean bl) throws CipherException {
        this.assertEncryption();
        return this.encryption(byArray, n, n2, bl);
    }

    public void encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws CipherException {
        byte[] byArray3 = this.encrypt(byArray, n, n2);
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
    }

    private byte[] encryption(byte[] byArray, int n, int n2, boolean bl) throws CipherException {
        FIPS_140_2.assertReadyState();
        RSAKey rSAKey = (RSAKey)this.key;
        int n3 = Utils.length(rSAKey.getModulusInternal());
        byte[] byArray2 = new byte[n3 - 1];
        byte[] byArray3 = null;
        if (n == 0 && n2 == byArray.length) {
            byArray3 = byArray;
        } else {
            byArray3 = new byte[n2];
            System.arraycopy(byArray, n, byArray3, 0, n2);
        }
        try {
            switch (this.encodingScheme) {
                case 0: {
                    byArray2 = this.encodeOAEP(byArray3, n3 - 1);
                    break;
                }
                case 1: {
                    byArray2 = this.encodeV15(byArray3, n3 - 1);
                    break;
                }
                default: {
                    throw new CipherException("Unknown encoding method: " + this.encodingScheme);
                }
            }
        }
        catch (CipherException cipherException) {
            throw new CipherException("Message too long");
        }
        RSA rSA = new RSA();
        rSA.setKey(rSAKey);
        byte[] byArray4 = Utils.toByteArray(rSA.performOp(new BigInt(1, byArray2)));
        byte[] byArray5 = new byte[n3];
        System.arraycopy(byArray4, 0, byArray5, n3 - byArray4.length, byArray4.length);
        return byArray5;
    }

    public void erase() {
        super.erase();
        this.encodingScheme = 1;
        if (this.oaepDigest != null) {
            this.oaepDigest.init();
            this.oaepDigest = null;
        }
        if (this.oaepMaskGenerator != null) {
            this.oaepMaskGenerator.erase();
            this.oaepMaskGenerator = null;
        }
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        if (this.encodingScheme == 0) {
            return new OAEPAlgorithmIdentifier(this.oaepDigest.getAlgID(), this.oaepMaskGenerator.getAlgID(), new AlgorithmIdentifier(OAEPAlgorithmIdentifier.P_SPECIFIED_OID, new ASN1OctetString(this.p)));
        }
        return AlgID.rsaEncryption;
    }

    public int getBlockSize() {
        return 0;
    }

    private void init(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (algorithmIdentifier.getOID().equals(AlgID.rsaEncryption.getOID())) {
            if (algorithmIdentifier.getParameters() != null && !(algorithmIdentifier.getParameters() instanceof ASN1Null)) {
                throw new AlgorithmIdentifierException("The rsaEncryption OID must be accompanied by NULL parameters");
            }
            this.encodingScheme = 1;
        } else if (algorithmIdentifier.getOID().equals(OAEPAlgorithmIdentifier.OAEP_OID)) {
            OAEPAlgorithmIdentifier oAEPAlgorithmIdentifier = algorithmIdentifier instanceof OAEPAlgorithmIdentifier ? (OAEPAlgorithmIdentifier)algorithmIdentifier : new OAEPAlgorithmIdentifier(algorithmIdentifier.getParameters());
            AlgorithmIdentifier algorithmIdentifier2 = oAEPAlgorithmIdentifier.getPSourceFunc();
            if (!algorithmIdentifier2.getOID().equals(OAEPAlgorithmIdentifier.P_SPECIFIED_OID)) {
                throw new AlgorithmIdentifierException("Only pSpecified AlgIDs are supported for OAEP encoding");
            }
            ASN1Object aSN1Object = algorithmIdentifier2.getParameters();
            if (!(aSN1Object instanceof ASN1OctetString)) {
                throw new AlgorithmIdentifierException("pSourceFunc parameters must be an instance of ASN1OctetString");
            }
            this.p = ((ASN1OctetString)aSN1Object).getValue();
            this.oaepDigest = MessageDigest.getInstance(oAEPAlgorithmIdentifier.getHashFunc());
            this.oaepMaskGenerator = MaskGenerator.getInstance(oAEPAlgorithmIdentifier.getMaskGenFunc());
            this.encodingScheme = 0;
        } else {
            throw new AlgorithmIdentifierException("Unsupported AlgorithmIdentifier: " + algorithmIdentifier);
        }
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, Key key, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException, InvalidKeyException {
        FIPS_140_2.assertReadyState();
        if (key == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        if (!(key instanceof RSAPublicKey) && !(key instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Key must be an instance of RSAPublicKey or RSAPrivateKey");
        }
        this.rbs = randomBitsSource;
        this.init(algorithmIdentifier);
        super.erase();
        this.key = key;
        this.releaseOp();
    }

    private byte[] unwrapKey(byte[] byArray) throws CipherException {
        this.assertKeyUnwrap();
        return this.decryption(byArray, 0, byArray.length, false);
    }

    public PrivateKey unwrapPrivateKey(byte[] byArray) throws CipherException {
        throw new CipherException("Cannot unwrap private using RSA PKCS#1");
    }

    public SymmetricKey unwrapSymmetricKey(byte[] byArray, AlgorithmIdentifier algorithmIdentifier) throws CipherException {
        byte[] byArray2 = this.unwrapKey(byArray);
        SymmetricKey symmetricKey = new SymmetricKey(byArray2, algorithmIdentifier);
        Utils.setArray(byArray2, (byte)0);
        return symmetricKey;
    }

    public byte[] wrapKey(PrivateKey privateKey) throws CipherException {
        throw new CipherException("Cannot wrap private key using RSA PKCS#1");
    }

    public byte[] wrapKey(SymmetricKey symmetricKey) throws CipherException {
        return this.wrapKey(symmetricKey.getBytesInternal());
    }

    private byte[] wrapKey(byte[] byArray) throws CipherException {
        this.assertKeyWrap();
        return this.encryption(byArray, 0, byArray.length, false);
    }
}

