/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.DSARandomBitsSource;
import com.phaos.crypto.EntropySource;
import com.phaos.fips.FIPS_140_2;
import com.phaos.fips.RNGTest;
import com.phaos.math.BigInt;
import java.math.BigInteger;

public abstract class RandomBitsSource {
    private static RandomBitsSource defaultRBS = null;
    private final RNGTest rngTest = new RNGTest(this);
    private static final Object obj = new Object();

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    protected RandomBitsSource() {
    }

    public abstract void clear();

    public static RandomBitsSource getDefault() {
        FIPS_140_2.assertReadyState();
        if (defaultRBS == null) {
            Object object = obj;
            synchronized (object) {
                if (defaultRBS == null) {
                    defaultRBS = new DSARandomBitsSource(true);
                }
            }
        }
        return defaultRBS;
    }

    protected final RNGTest getRNGTest() {
        return this.rngTest;
    }

    public BigInt randomBigInt(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid length " + n);
        }
        byte[] byArray = new byte[n % 8 == 0 ? n / 8 : n / 8 + 1];
        this.randomBytes(byArray);
        if (n % 8 != 0) {
            byArray[0] = (byte)(byArray[0] & (1 << n % 8) - 1);
        }
        return new BigInt(1, byArray);
    }

    public BigInteger randomBigInteger(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid length " + n);
        }
        byte[] byArray = new byte[n % 8 == 0 ? n / 8 : n / 8 + 1];
        this.randomBytes(byArray);
        if (n % 8 != 0) {
            byArray[0] = (byte)(byArray[0] & (1 << n % 8) - 1);
        }
        return new BigInteger(1, byArray);
    }

    public abstract byte randomByte();

    public byte[] randomBytes(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = this.randomByte();
            ++n;
        }
        return byArray;
    }

    public void seed() {
        this.seed(EntropySource.getDefault());
    }

    public abstract void seed(EntropySource var1);

    public abstract void seed(byte[] var1);

    public static void setDefault(RandomBitsSource randomBitsSource) {
        FIPS_140_2.assertReadyState();
        Object object = obj;
        synchronized (object) {
            defaultRBS = randomBitsSource;
        }
    }
}

