/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.EntropySource;
import com.phaos.fips.FIPS_140_2;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.security.SecureRandom;

public class SREntropySource
extends EntropySource {
    private Method method;
    private Object target;

    public SREntropySource() {
        this(new SecureRandom());
    }

    public SREntropySource(SecureRandom secureRandom) {
        FIPS_140_2.assertReadyState();
        try {
            Class<?> clazz = secureRandom.getClass();
            Class[] classArray = new Class[]{Integer.TYPE};
            Method method = null;
            try {
                method = clazz.getMethod("generateSeed", classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            if (method != null) {
                this.method = method;
                this.target = secureRandom;
            } else {
                this.method = clazz.getMethod("getSeed", classArray);
                this.target = null;
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException("Problems locating a method: " + exception.toString());
        }
    }

    public void clear() {
    }

    public byte generateByte() {
        FIPS_140_2.assertReadyState();
        try {
            Object object = this.method.invoke(this.target, new Integer(1));
            return Array.getByte(object, 0);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Problems invoking the method: " + this.method + ": " + exception.toString());
        }
    }

    public synchronized byte[] generateBytes(byte[] byArray) {
        FIPS_140_2.assertReadyState();
        try {
            Object object = this.method.invoke(this.target, new Integer(byArray.length));
            int n = 0;
            while (n < byArray.length) {
                byArray[n] = Array.getByte(object, n);
                ++n;
            }
            return byArray;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Problems invoking the method: " + this.method + ": " + exception.toString());
        }
    }
}

