/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.EntropySource;
import com.phaos.fips.FIPS_140_2;

public class SpinnerEntropySource
extends EntropySource
implements Runnable {
    private int count;
    private boolean stop;
    private int sleepTime;
    private static final int DEFAULT_SLEEP_TIME = 100;

    public SpinnerEntropySource() {
        this(100);
    }

    public SpinnerEntropySource(int n) {
        this.setSleepTime(n);
    }

    public void clear() {
    }

    public synchronized byte generateByte() {
        FIPS_140_2.assertReadyState();
        return (byte)(this.getCount() % 256);
    }

    private synchronized int getCount() {
        Thread thread = new Thread(this);
        this.stop = false;
        this.count = 0;
        thread.start();
        try {
            Thread.sleep(this.sleepTime);
        }
        catch (InterruptedException interruptedException) {}
        this.stop = true;
        do {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {}
        } while (thread.isAlive());
        return this.count;
    }

    public int getSleepTime() {
        FIPS_140_2.assertReadyState();
        return this.sleepTime;
    }

    public void run() {
        while (!this.stop) {
            ++this.count;
            Thread.yield();
        }
    }

    public synchronized void setSleepTime(int n) {
        FIPS_140_2.assertReadyState();
        if (n < 1) {
            throw new IllegalArgumentException("sleepTime=" + n);
        }
        this.sleepTime = n;
    }

    public String toString() {
        FIPS_140_2.assertReadyState();
        return "{ sleepTime = " + this.sleepTime + " }";
    }
}

