/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.Key;
import com.phaos.fips.FIPS_140_2;
import com.phaos.fips.KeyExportException;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class SymmetricKey
implements Key {
    private AlgorithmIdentifier algID;
    private boolean allowExport = true;
    private byte[] keyBytes;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    public SymmetricKey() {
        this(new byte[0]);
    }

    public SymmetricKey(byte[] byArray) {
        this(byArray, null);
    }

    public SymmetricKey(byte[] byArray, AlgorithmIdentifier algorithmIdentifier) {
        this.setBytes(byArray);
        this.algID = algorithmIdentifier;
    }

    protected void assertAllowExport() {
        if (!this.getAllowExport() || !FIPS_140_2.getAllowKeyExport()) {
            throw new KeyExportException("Plaintext key export not allowed");
        }
    }

    public Object clone() {
        FIPS_140_2.assertReadyState();
        SymmetricKey symmetricKey = new SymmetricKey();
        try {
            if (this.algID != null) {
                symmetricKey.algID = new AlgorithmIdentifier(Utils.toStream(this.algID));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing algorithm identifier to stream");
        }
        if (this.keyBytes != null) {
            symmetricKey.keyBytes = (byte[])this.keyBytes.clone();
        }
        symmetricKey.allowExport = this.allowExport;
        return symmetricKey;
    }

    public boolean equals(Object object) {
        FIPS_140_2.assertReadyState();
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof SymmetricKey)) {
            return false;
        }
        return Utils.areEqual(((SymmetricKey)object).getBytesInternal(), this.getBytesInternal());
    }

    public void erase() {
        if (this.keyBytes != null) {
            Utils.setArray(this.keyBytes, (byte)0);
            this.keyBytes = null;
        }
    }

    public void finalize() {
        this.erase();
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        return this.algID;
    }

    public String getAlgorithm() {
        FIPS_140_2.assertReadyState();
        if (this.algID != null) {
            ASN1ObjectID aSN1ObjectID = this.algID.getOID();
            if (aSN1ObjectID.equals(AlgID.desCBC.getOID()) || aSN1ObjectID.equals(AlgID.desECB.getOID())) {
                return "DES";
            }
            if (aSN1ObjectID.equals(AlgID.DES_EDE3_CBC.getOID()) || aSN1ObjectID.equals(AlgID.DES_EDE3_ECB.getOID())) {
                return "DES-EDE";
            }
            if (aSN1ObjectID.equals(AlgID.aes128_CBC.getOID()) || aSN1ObjectID.equals(AlgID.aes128_ECB.getOID()) || aSN1ObjectID.equals(AlgID.aes192_CBC.getOID()) || aSN1ObjectID.equals(AlgID.aes192_ECB.getOID()) || aSN1ObjectID.equals(AlgID.aes256_CBC.getOID()) || aSN1ObjectID.equals(AlgID.aes256_ECB.getOID())) {
                return "AES";
            }
            if (aSN1ObjectID.equals(AlgID.RC4.getOID())) {
                return "RC4";
            }
            if (aSN1ObjectID.equals(AlgID.BLOWFISH.getOID()) || aSN1ObjectID.equals(AlgID.blowfishCBC.getOID()) || aSN1ObjectID.equals(AlgID.blowfishECB.getOID())) {
                return "Blowfish";
            }
            if (aSN1ObjectID.equals(AlgID.RC2_CBC.getOID())) {
                return "RC2";
            }
            return this.algID.toString();
        }
        return null;
    }

    public boolean getAllowExport() {
        return this.allowExport;
    }

    public int getBitLength() {
        FIPS_140_2.assertReadyState();
        if (this.keyBytes == null) {
            return 0;
        }
        return 8 * this.keyBytes.length;
    }

    public byte[] getBytes() {
        this.assertAllowExport();
        return (byte[])this.getBytesInternal().clone();
    }

    byte[] getBytesInternal() {
        FIPS_140_2.assertReadyState();
        return this.keyBytes;
    }

    public byte[] getEncoded() {
        return this.getBytes();
    }

    byte[] getEncodedInternal() {
        return this.getBytesInternal();
    }

    public String getFormat() {
        return "RAW";
    }

    public int keySize() {
        FIPS_140_2.assertReadyState();
        return this.keyBytes.length;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        FIPS_140_2.assertReadyState();
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(new UnsyncByteArrayInputStream(byArray));
        this.algID = aSN1SequenceInputStream.getCurrentTag() == 16 ? new AlgorithmIdentifier(aSN1SequenceInputStream) : null;
        this.keyBytes = ASN1OctetString.inputValue(aSN1SequenceInputStream);
        aSN1SequenceInputStream.terminate();
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) {
        FIPS_140_2.assertReadyState();
        this.algID = algorithmIdentifier;
    }

    public void setAllowExport(boolean bl) {
        this.allowExport = bl;
    }

    public void setBytes(byte[] byArray) {
        FIPS_140_2.assertReadyState();
        this.erase();
        if (byArray != null) {
            this.keyBytes = (byte[])byArray.clone();
        }
    }

    public String toString() {
        FIPS_140_2.assertReadyState();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        stringBuffer.append("algID=");
        stringBuffer.append(String.valueOf(this.algID));
        stringBuffer.append(", ");
        stringBuffer.append("bitLength=");
        stringBuffer.append(this.getBitLength());
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        FIPS_140_2.assertReadyState();
        this.assertAllowExport();
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        if (this.algID != null) {
            aSN1Sequence.addElement(this.algID);
        }
        aSN1Sequence.addElement(new ASN1OctetString(this.keyBytes));
        objectOutput.writeObject(Utils.toBytes(aSN1Sequence));
    }
}

