/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.fips;

import com.phaos.crypto.AES;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.Cipher;
import com.phaos.crypto.DES;
import com.phaos.crypto.DES_EDE;
import com.phaos.crypto.DHKeyAgreement;
import com.phaos.crypto.DHKeyPairGenerator;
import com.phaos.crypto.DHParams;
import com.phaos.crypto.DHPrivateKey;
import com.phaos.crypto.DHPublicKey;
import com.phaos.crypto.DSA;
import com.phaos.crypto.DSAPrivateKey;
import com.phaos.crypto.DSAPublicKey;
import com.phaos.crypto.DSARandomBitsSource;
import com.phaos.crypto.ECDSA;
import com.phaos.crypto.ECPrivateKey;
import com.phaos.crypto.ECPublicKey;
import com.phaos.crypto.HMAC;
import com.phaos.crypto.KeyPair;
import com.phaos.crypto.Padding;
import com.phaos.crypto.RSAMDSignature;
import com.phaos.crypto.RSAPrivateKey;
import com.phaos.crypto.RSAPublicKey;
import com.phaos.crypto.RSApkcs1;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.SHA;
import com.phaos.crypto.SymmetricKey;
import com.phaos.fips.IntegrityTest;
import com.phaos.fips.ModuleState;
import com.phaos.fips.ModuleStateException;
import com.phaos.fips.SelfTestException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;

public final class FIPS_140_2 {
    private static volatile ModuleState moduleState = ModuleState.NOT_INITIALIZED;
    private static final Object STATE_LOCK = new Object();
    private static final Object PUST_LOCK = new Object();
    private static boolean allowKeyExport = false;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    private FIPS_140_2() {
    }

    /*
     * Unable to fully structure code
     */
    public static void assertReadyState() {
        if (FIPS_140_2.moduleState == ModuleState.READY) {
            return;
        }
        if (!(Thread.currentThread() instanceof SelfTestThread)) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            try {
                Thread.sleep(20L);
                continue;
            }
            catch (InterruptedException var0) {
                throw new ModuleStateException(var0.toString());
            }
lbl10:
            // 2 sources

            ** while (FIPS_140_2.getModuleState() == ModuleState.TESTING)
        }
lbl11:
        // 1 sources

        var0_1 = FIPS_140_2.getModuleState();
        if (var0_1 != ModuleState.READY) {
            throw new ModuleStateException("Crypto module not ready, state=" + var0_1);
        }
    }

    public static void clearModuleState() {
        ModuleState moduleState = FIPS_140_2.getModuleState();
        if (moduleState == ModuleState.NOT_INITIALIZED) {
            return;
        }
        if (moduleState.isUnrecoverableErrorState() || moduleState == ModuleState.TESTING) {
            throw new ModuleStateException("Cannot clear unrecoverable error state " + moduleState);
        }
        Object object = STATE_LOCK;
        synchronized (object) {
            moduleState = FIPS_140_2.getModuleState();
            if (moduleState == ModuleState.NOT_INITIALIZED) {
                Object var2_2 = null;
                return;
            }
            if (moduleState.isRecoverableErrorState() || moduleState == ModuleState.READY) {
                FIPS_140_2.setModuleState(ModuleState.NOT_INITIALIZED);
            } else if (moduleState.isUnrecoverableErrorState() || moduleState == ModuleState.TESTING) {
                throw new ModuleStateException("Cannot clear unrecoverable error state " + moduleState);
            }
        }
    }

    public static boolean getAllowKeyExport() {
        return allowKeyExport;
    }

    public static ModuleState getModuleState() {
        Object object = STATE_LOCK;
        synchronized (object) {
            ModuleState moduleState = FIPS_140_2.moduleState;
            Object var2_2 = null;
            return moduleState;
        }
    }

    public static void powerUpSelfTest() {
        if (moduleState == ModuleState.NOT_INITIALIZED) {
            Object object = PUST_LOCK;
            synchronized (object) {
                if (moduleState == ModuleState.NOT_INITIALIZED) {
                    new SelfTestThread().start();
                }
            }
        }
    }

    public static void selfTest(RandomBitsSource randomBitsSource) {
        while (!(Thread.currentThread() instanceof SelfTestThread) && FIPS_140_2.getModuleState() == ModuleState.TESTING) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                throw new ModuleStateException(interruptedException.toString());
            }
        }
        Object object = STATE_LOCK;
        synchronized (object) {
            FIPS_140_2.setModuleState(ModuleState.TESTING);
            FIPS_140_2.testDES();
            FIPS_140_2.test3DES();
            FIPS_140_2.testAES();
            FIPS_140_2.testSHA1();
            FIPS_140_2.testHMAC();
            FIPS_140_2.testRNG();
            FIPS_140_2.testDSA(randomBitsSource);
            FIPS_140_2.testRSA(randomBitsSource);
            FIPS_140_2.testECDSA(randomBitsSource);
            FIPS_140_2.testIntegrity();
            FIPS_140_2.setModuleState(ModuleState.READY);
        }
    }

    public static void setAllowKeyExport(boolean bl) {
        allowKeyExport = bl;
    }

    static void setModuleState(ModuleState moduleState) {
        if (!FIPS_140_2.moduleState.isUnrecoverableErrorState()) {
            Object object = STATE_LOCK;
            synchronized (object) {
                if (!FIPS_140_2.moduleState.isUnrecoverableErrorState()) {
                    FIPS_140_2.moduleState = moduleState;
                }
            }
        }
    }

    private static void test3DES() {
        try {
            DES_EDE dES_EDE = new DES_EDE();
            byte[] byArray = Utils.fromHexString("8000000000000000");
            byte[] byArray2 = Utils.fromHexString("95F8A5E5DD31D900");
            SymmetricKey symmetricKey = new SymmetricKey(Utils.fromHexString("010101010101010101010101010101010101010101010101"), AlgID.DES_EDE3_ECB);
            dES_EDE.initialize(AlgID.DES_EDE3_ECB, symmetricKey, Padding.NONE);
            byte[] byArray3 = dES_EDE.encrypt(byArray, false);
            if (Utils.areEqual(byArray3, byArray) || !Utils.areEqual(byArray3, byArray2)) {
                throw new SelfTestException("Triple DES known-answer test failed encryption");
            }
            dES_EDE.initialize(AlgID.DES_EDE3_ECB, symmetricKey, Padding.NONE);
            byte[] byArray4 = dES_EDE.decrypt(byArray3, false);
            if (!Utils.areEqual(byArray4, byArray)) {
                throw new SelfTestException("Triple DES known-answer test failed decryption");
            }
        }
        catch (SelfTestException selfTestException) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_3DES_KNOWN_ANSWER);
            throw selfTestException;
        }
        catch (Throwable throwable) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_3DES_KNOWN_ANSWER);
            throw new SelfTestException(throwable.toString());
        }
    }

    private static void testAES() {
        try {
            AES aES = new AES();
            byte[] byArray = Utils.fromHexString("00112233445566778899aabbccddeeff");
            byte[] byArray2 = Utils.fromHexString("69c4e0d86a7b0430d8cdb78070b4c55a");
            SymmetricKey symmetricKey = new SymmetricKey(Utils.fromHexString("000102030405060708090a0b0c0d0e0f"), AlgID.aes128_ECB);
            aES.initialize(AlgID.aes128_ECB, symmetricKey, Padding.NONE);
            byte[] byArray3 = aES.encrypt(byArray, false);
            if (Utils.areEqual(byArray3, byArray) || !Utils.areEqual(byArray3, byArray2)) {
                throw new SelfTestException("AES-128 known-answer test failed encryption");
            }
            aES.initialize(AlgID.aes128_ECB, symmetricKey, Padding.NONE);
            byte[] byArray4 = aES.decrypt(byArray3, false);
            if (!Utils.areEqual(byArray4, byArray)) {
                throw new SelfTestException("AES-128 known-answer test failed decryption");
            }
            byte[] byArray5 = Utils.fromHexString("00112233445566778899aabbccddeeff");
            byte[] byArray6 = Utils.fromHexString("dda97ca4864cdfe06eaf70a0ec0d7191");
            SymmetricKey symmetricKey2 = new SymmetricKey(Utils.fromHexString("000102030405060708090a0b0c0d0e0f1011121314151617"), AlgID.aes192_ECB);
            aES.initialize(AlgID.aes192_ECB, symmetricKey2, Padding.NONE);
            byte[] byArray7 = aES.encrypt(byArray5, false);
            if (Utils.areEqual(byArray7, byArray5) || !Utils.areEqual(byArray7, byArray6)) {
                throw new SelfTestException("AES-192 known-answer test failed encryption");
            }
            aES.initialize(AlgID.aes192_ECB, symmetricKey2, Padding.NONE);
            byte[] byArray8 = aES.decrypt(byArray7, false);
            if (!Utils.areEqual(byArray8, byArray5)) {
                throw new SelfTestException("AES-192 known-answer test failed decryption");
            }
            byte[] byArray9 = Utils.fromHexString("00112233445566778899aabbccddeeff");
            byte[] byArray10 = Utils.fromHexString("8ea2b7ca516745bfeafc49904b496089");
            SymmetricKey symmetricKey3 = new SymmetricKey(Utils.fromHexString("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f"), AlgID.aes256_ECB);
            aES.initialize(AlgID.aes256_ECB, symmetricKey3, Padding.NONE);
            byte[] byArray11 = aES.encrypt(byArray9, false);
            if (Utils.areEqual(byArray11, byArray9) || !Utils.areEqual(byArray11, byArray10)) {
                throw new SelfTestException("AES-256 known-answer test failed encryption");
            }
            aES.initialize(AlgID.aes256_ECB, symmetricKey3, Padding.NONE);
            byte[] byArray12 = aES.decrypt(byArray11, false);
            if (!Utils.areEqual(byArray12, byArray9)) {
                throw new SelfTestException("AES-256 known-answer test failed decryption");
            }
        }
        catch (SelfTestException selfTestException) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_AES_KNOWN_ANSWER);
            throw selfTestException;
        }
        catch (Throwable throwable) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_AES_KNOWN_ANSWER);
            throw new SelfTestException(throwable.toString());
        }
    }

    private static void testDES() {
        try {
            DES dES = new DES();
            byte[] byArray = Utils.fromHexString("4e6f772069732074");
            byte[] byArray2 = Utils.fromHexString("3fa40e8a984d4815");
            SymmetricKey symmetricKey = new SymmetricKey(Utils.fromHexString("0123456789abcdef"), AlgID.desECB);
            dES.initialize(AlgID.desECB, symmetricKey, Padding.NONE);
            byte[] byArray3 = dES.encrypt(byArray, false);
            if (Utils.areEqual(byArray3, byArray) || !Utils.areEqual(byArray3, byArray2)) {
                throw new SelfTestException("DES known-answer test failed encryption");
            }
            dES.initialize(AlgID.desECB, symmetricKey, Padding.NONE);
            byte[] byArray4 = dES.decrypt(byArray3, false);
            if (!Utils.areEqual(byArray4, byArray)) {
                throw new SelfTestException("DES known-answer test failed decryption");
            }
        }
        catch (SelfTestException selfTestException) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_DES_KNOWN_ANSWER);
            throw selfTestException;
        }
        catch (Throwable throwable) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_DES_KNOWN_ANSWER);
            throw new SelfTestException(throwable.toString());
        }
    }

    private static void testDSA(RandomBitsSource randomBitsSource) {
        try {
            DSAPublicKey dSAPublicKey = new DSAPublicKey(Utils.fromHexString("3081f03081a806072a8648ce38040130819c024100ee84635d2034c7ccdeb282d8d9498b79c74fdef02e561bbe3c7918259119d0efac63cc2162fc1075913fb4e47bec88187c2435abe9568f5271c30ff703dd57450215008c7a79e5faa9796509652ed68043ab441b69924302402e21f34d5c095e84d52ee333b32f5bfa4b211c9aa1c77084a60c693647c2ea348ed60492fc49acecc90bd21904a3f301aec2a13b6e90b4618463220460994c5903430002404c6dd4f8c1763407c0cbc4d23be79a657df1475e83cee27ae319f675a73469605f987b6e4d5fc167a285e403068d3e3dcf3138e4b59ab09c7b6d92269ce24b09"));
            DSAPrivateKey dSAPrivateKey = new DSAPrivateKey(Utils.fromHexString("3081c60201003081a806072a8648ce38040130819c024100ee84635d2034c7ccdeb282d8d9498b79c74fdef02e561bbe3c7918259119d0efac63cc2162fc1075913fb4e47bec88187c2435abe9568f5271c30ff703dd57450215008c7a79e5faa9796509652ed68043ab441b69924302402e21f34d5c095e84d52ee333b32f5bfa4b211c9aa1c77084a60c693647c2ea348ed60492fc49acecc90bd21904a3f301aec2a13b6e90b4618463220460994c59041602147bf0b8c76207a89ba7119b591a6f7a8e9ae746f1"));
            byte[] byArray = Utils.fromHexString("54686520717569636b2062726f776e20666f78206a756d706564206f76657220746865206c617a7920646f677321");
            DSA dSA = new DSA(dSAPublicKey, dSAPrivateKey, randomBitsSource, byArray);
            dSA.sign();
            if (!dSA.verify()) {
                throw new SelfTestException("DSA Signature pair-wise consistency test failed");
            }
        }
        catch (SelfTestException selfTestException) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_DSA);
            throw selfTestException;
        }
        catch (Throwable throwable) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_DSA);
            throw new SelfTestException(throwable.toString());
        }
    }

    private static void testECDSA(RandomBitsSource randomBitsSource) {
        try {
            byte[] byArray = Utils.fromHexString("54686520717569636b2062726f776e20666f78206a756d706564206f76657220746865206c617a7920646f677321");
            ECPublicKey eCPublicKey = new ECPublicKey(new UnsyncByteArrayInputStream(Utils.fromHexString("3082010c3081d306072a8648ce3d02013081c7020101302406072a8648ce3d0101021900fffffffffffffffffffffffffffffffeffffffffffffffff304b0418fffffffffffffffffffffffffffffffefffffffffffffffc041864210519e59c80e70fa7e9ab72243049feb8deecc146b9b10315003045ae6fc8422f64ed579528d38120eae12196d5043104188da80eb03090f67cbf20eb43a18800f4ff0afd82ff101207192b95ffc8da78631011ed6b24cdd573f977a11e794811021900ffffffffffffffffffffffff99def836146bc9b1b4d2283102010103340004310407efec711aaa7107d66b2f29a04193a47901644b588bb81aa42c10eb04b28d712faf69fcf34bf4218b191280aacd07a7")));
            ECPrivateKey eCPrivateKey = new ECPrivateKey(new UnsyncByteArrayInputStream(Utils.fromHexString("3081f60201003081d306072a8648ce3d02013081c7020101302406072a8648ce3d0101021900fffffffffffffffffffffffffffffffeffffffffffffffff304b0418fffffffffffffffffffffffffffffffefffffffffffffffc041864210519e59c80e70fa7e9ab72243049feb8deecc146b9b10315003045ae6fc8422f64ed579528d38120eae12196d5043104188da80eb03090f67cbf20eb43a18800f4ff0afd82ff101207192b95ffc8da78631011ed6b24cdd573f977a11e794811021900ffffffffffffffffffffffff99def836146bc9b1b4d22831020101041b021900f444e52705ceecd5c99575b8b843fe86fed08f04fff12a91")));
            ECDSA eCDSA = new ECDSA();
            eCDSA.setRandomBitsSource(randomBitsSource);
            eCDSA.setPrivateKey(eCPrivateKey);
            eCDSA.setDocument(byArray);
            eCDSA.sign();
            eCDSA.setPublicKey(eCPublicKey);
            if (!eCDSA.verify()) {
                throw new SelfTestException("ECDSA Signature prime-field pair-wise consistency test failed");
            }
            ECPublicKey eCPublicKey2 = new ECPublicKey(new UnsyncByteArrayInputStream(Utils.fromHexString("3081f73081c406072a8648ce3d02013081b8020101302506072a8648ce3d0102301a020200a306092a8648ce3d01020303300902010102010202010830450415072546b5435234a422e0789675f432c89435de5242041500c9517d06d5240d3cff38c74b20b6cd4d6f9dd4d9031500d2c0fb15760860def1eef4d696e6768756151754042b0407af69989546103d79329fcc3d74880f33bbe803cb01ec23211b5966adea1d3f87f7ea5848aef0b7ca9f02150400000000000000000001e60fc8821cc74daeafc1020102032e00042b04008966e50a031796c554c520205c5125695bef8a4a058408f809b731255c08ba3daa98fbfac9fa3ad92a")));
            ECPrivateKey eCPrivateKey2 = new ECPrivateKey(new UnsyncByteArrayInputStream(Utils.fromHexString("3081e30201003081c406072a8648ce3d02013081b8020101302506072a8648ce3d0102301a020200a306092a8648ce3d01020303300902010102010202010830450415072546b5435234a422e0789675f432c89435de5242041500c9517d06d5240d3cff38c74b20b6cd4d6f9dd4d9031500d2c0fb15760860def1eef4d696e6768756151754042b0407af69989546103d79329fcc3d74880f33bbe803cb01ec23211b5966adea1d3f87f7ea5848aef0b7ca9f02150400000000000000000001e60fc8821cc74daeafc1020102041702150207e0e28b610c4a4468965e5f58e1c0bc2b4bb65b")));
            ECDSA eCDSA2 = new ECDSA();
            eCDSA2.setRandomBitsSource(randomBitsSource);
            eCDSA2.setPrivateKey(eCPrivateKey2);
            eCDSA2.setDocument(byArray);
            eCDSA2.sign();
            eCDSA2.setPublicKey(eCPublicKey2);
            if (!eCDSA2.verify()) {
                throw new SelfTestException("ECDSA Signature binary-field pair-wise consistency test failed");
            }
        }
        catch (SelfTestException selfTestException) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_ECDSA);
            throw selfTestException;
        }
        catch (Throwable throwable) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_ECDSA);
            throw new SelfTestException(throwable.toString());
        }
    }

    private static void testHMAC() {
        try {
            HMAC hMAC = new HMAC();
            byte[] byArray = "Sample #1".getBytes("ASCII");
            byte[] byArray2 = Utils.fromHexString("4f4ca3d5d68ba7cc0a1208c9c61e9c5da0403c0a");
            SymmetricKey symmetricKey = new SymmetricKey(Utils.fromHexString("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f"), AlgID.hmacSHA);
            hMAC.initialize(AlgID.hmacSHA, symmetricKey);
            hMAC.update(byArray);
            byte[] byArray3 = hMAC.computeMAC();
            if (!Utils.areEqual(byArray3, byArray2)) {
                throw new SelfTestException("HMAC-SHA1 known answer test failed");
            }
        }
        catch (SelfTestException selfTestException) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_HMAC_KNOWN_ANSWER);
            throw selfTestException;
        }
        catch (Throwable throwable) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_HMAC_KNOWN_ANSWER);
            throw new SelfTestException(throwable.toString());
        }
    }

    private static void testIntegrity() {
        try {
            DSAPublicKey dSAPublicKey = new DSAPublicKey(Utils.fromHexString("308201b63082012b06072a8648ce3804013082011e02818100e6596ab57a361b583ad49f1616c3f4d14f5c979cfb7a6ce4c6a4eb7b80bca55fea753f184646f1aef1caec173b057771eda6dc3f8ebce360dc119d3bbbb7ac0b3955f63ce24135ac8a3f5dea5f0dadaf5144cab3dfbc03c748543d17e65877845451e942481494bd656a2fd48ecdfa7db8889d75a84777d6427ebebe3a8fe52f021500bd23d0cfb6a4db89c1a3983048c7c45e4bc46e57028180094caa028124447a4aadb9959c0f2ddef91210cf06937a8799336e9f155d98155a8ada8f9dfe83ed25f12d140dbee27cf81008ef453ffa2bb911492713e433bc7d9b3cff41f695e5f6534157cf30ce3082f8cde4403dbe063a6cf8d7499138e1ac9332822f0a3c60836e67d2a9ff85d7e9c12290c880acd6c5b85430777d55f203818400028180730ed85217d16ad96fc08cf9cc65497c627bfc38316e95251c447027d9dcab1e7028a3047dc4dd8141fbc5dbc99e0eeafce45a74309632dbed8d966f5545ba8a69f85f78465fef7dc59ff10c530d4e1201de18ee02c1866eb277df4c7989da98667f3360bb7d6e99ab0a91ec4a152452f313b1abc1121ef0ae83a71a55c82a0b"));
            IntegrityTest.verifyModule(dSAPublicKey);
        }
        catch (SelfTestException selfTestException) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_DES_KNOWN_ANSWER);
            throw selfTestException;
        }
        catch (Throwable throwable) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_DES_KNOWN_ANSWER);
            throw new SelfTestException(throwable.toString());
        }
    }

    public static void testKeyPair(DHPublicKey dHPublicKey, DHPrivateKey dHPrivateKey) {
        try {
            DHParams dHParams = dHPrivateKey.getParams();
            DHKeyPairGenerator dHKeyPairGenerator = new DHKeyPairGenerator();
            dHKeyPairGenerator.initialize(dHParams, RandomBitsSource.getDefault());
            KeyPair keyPair = dHKeyPairGenerator.generateKeyPair();
            DHPublicKey dHPublicKey2 = (DHPublicKey)keyPair.getPublic();
            DHPrivateKey dHPrivateKey2 = (DHPrivateKey)keyPair.getPrivate();
            DHKeyAgreement dHKeyAgreement = new DHKeyAgreement(dHPrivateKey, dHPublicKey2);
            byte[] byArray = dHKeyAgreement.generateSecret();
            DHKeyAgreement dHKeyAgreement2 = new DHKeyAgreement(dHPrivateKey2, dHPublicKey);
            byte[] byArray2 = dHKeyAgreement2.generateSecret();
            if (!Utils.areEqual(byArray, byArray2)) {
                throw new SelfTestException("Diffie-Hellman Key-Pair Generation pair-wise consistency test failed");
            }
        }
        catch (SelfTestException selfTestException) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_DH_KEY_GENERATION);
            throw selfTestException;
        }
        catch (Throwable throwable) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_DH_KEY_GENERATION);
            throw new SelfTestException(throwable.toString());
        }
    }

    public static void testKeyPair(DSAPublicKey dSAPublicKey, DSAPrivateKey dSAPrivateKey) {
        try {
            byte[] byArray = Utils.fromHexString("54686520717569636b2062726f776e20666f78206a756d706564206f76657220746865206c617a7920646f677321");
            DSA dSA = new DSA(dSAPublicKey, dSAPrivateKey, byArray);
            dSA.setRandomBitsSource(new DSARandomBitsSource());
            dSA.sign();
            if (!dSA.verify()) {
                throw new SelfTestException("DSA Key-Pair Generation pair-wise consistency test failed");
            }
        }
        catch (SelfTestException selfTestException) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_DSA_KEY_GENERATION);
            throw selfTestException;
        }
        catch (Throwable throwable) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_DSA_KEY_GENERATION);
            throw new SelfTestException(throwable.toString());
        }
    }

    public static void testKeyPair(ECPublicKey eCPublicKey, ECPrivateKey eCPrivateKey) {
        try {
            byte[] byArray = Utils.fromHexString("54686520717569636b2062726f776e20666f78206a756d706564206f76657220746865206c617a7920646f677321");
            ECDSA eCDSA = new ECDSA();
            eCDSA.setPrivateKey(eCPrivateKey);
            eCDSA.setDocument(byArray);
            eCDSA.sign();
            eCDSA.setPublicKey(eCPublicKey);
            if (!eCDSA.verify()) {
                throw new SelfTestException("ECDSA Key-Pair Generation pair-wise consistency test failed");
            }
        }
        catch (SelfTestException selfTestException) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_ECDSA_KEY_GENERATION);
            throw selfTestException;
        }
        catch (Throwable throwable) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_ECDSA_KEY_GENERATION);
            throw new SelfTestException(throwable.toString());
        }
    }

    public static void testKeyPair(RSAPublicKey rSAPublicKey, RSAPrivateKey rSAPrivateKey) {
        try {
            Cipher cipher = Cipher.getInstance(rSAPublicKey);
            byte[] byArray = RandomBitsSource.getDefault().randomBytes(new byte[rSAPublicKey.modulusLength() / 2]);
            byte[] byArray2 = cipher.encrypt(byArray);
            if (Utils.areEqual(byArray2, byArray)) {
                throw new SelfTestException("RSA Key-Pair Generation pair-wise consistency test failed");
            }
            Cipher cipher2 = Cipher.getInstance(rSAPrivateKey);
            byte[] byArray3 = cipher2.decrypt(byArray2);
            if (!Utils.areEqual(byArray3, byArray)) {
                throw new SelfTestException("RSA Key-Pair Generation pair-wise consistency test failed");
            }
            byte[] byArray4 = Utils.fromHexString("54686520717569636b2062726f776e20666f78206a756d706564206f76657220746865206c617a7920646f677321");
            byte[] byArray5 = Utils.fromHexString("72b66f96eab5ceca69d35e7edeeaf1b2668d4c6bea8e635eb797888843a9e873389e7c6724e794ba33d28eef318c5f77aa2d7966d5f6a8f964f9a89020eca313");
            RSAMDSignature rSAMDSignature = new RSAMDSignature(rSAPrivateKey, AlgID.sha_1, byArray4);
            rSAMDSignature.sign();
            rSAMDSignature.setPublicKey(rSAPublicKey);
            if (!rSAMDSignature.verify()) {
                throw new SelfTestException("RSA Key-Pair Generation pair-wise consistency test failed");
            }
        }
        catch (SelfTestException selfTestException) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_RSA_KEY_GENERATION);
            throw selfTestException;
        }
        catch (Throwable throwable) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_RSA_KEY_GENERATION);
            throw new SelfTestException(throwable.toString());
        }
    }

    private static void testRNG() {
        try {
            byte[] byArray = Utils.fromHexString("6162636465666768696a30313233343536373839");
            byte[] byArray2 = Utils.fromHexString("22166fbf");
            DSARandomBitsSource dSARandomBitsSource = new DSARandomBitsSource(false);
            dSARandomBitsSource.seed(byArray);
            byte[] byArray3 = dSARandomBitsSource.randomBytes(new byte[byArray2.length]);
            if (!Utils.areEqual(byArray3, byArray2)) {
                throw new SelfTestException("DSA Random Number Generator failed known-answer test");
            }
        }
        catch (SelfTestException selfTestException) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_RNG_KNOWN_ANSWER);
            throw selfTestException;
        }
        catch (Throwable throwable) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_RNG_KNOWN_ANSWER);
            throw new SelfTestException(throwable.toString());
        }
    }

    private static void testRSA(RandomBitsSource randomBitsSource) {
        try {
            RSAPublicKey rSAPublicKey = new RSAPublicKey(Utils.fromHexString("305c300d06092a864886f70d0101010500034b00304802410080d5faab51c2f21663b9e716134a6bcb75ad945181300a0491161931bb43d509cd2c067ddb5c5386df54bb7159c77d5373aa8409921ad46634f22de86bccafe10203010001"));
            RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(Utils.fromHexString("30820153020100300d06092a864886f70d01010105000482013d3082013902010002410080d5faab51c2f21663b9e716134a6bcb75ad945181300a0491161931bb43d509cd2c067ddb5c5386df54bb7159c77d5373aa8409921ad46634f22de86bccafe102030100010240114dabe70a8a263d7f935e4806bb3e130b710eb48ba74a1126f352daed0dc534e3c006213276ae7cd8bd07d90ef6627eef5b991e6b71aa4554e0bf722e60eca9022100e3e073447bce4211be5c20b8a2423fcf91023f48f59bd76515b4268345dc0e8302210090bc6cf8c9f2e7a5e586c05aa27ac923bca85efc646b47062638608a6196bacb02206de656d12580811ebb9704f4e6d45aa0098872eb060105edab7cf9c1ffd4346f022022c885cfcc88c9cefeb841a6068247b084f859cb823e9dd5067e6a0517aae7bd022065b3e4d8bfc5c8244b580c9095caaa6da84279c94f49f12aa3c0b94c99eb61b0"));
            byte[] byArray = Utils.fromHexString("54686520717569636b2062726f776e20666f78206a756d706564206f76657220746865206c617a7920646f677321");
            byte[] byArray2 = Utils.fromHexString("72b66f96eab5ceca69d35e7edeeaf1b2668d4c6bea8e635eb797888843a9e873389e7c6724e794ba33d28eef318c5f77aa2d7966d5f6a8f964f9a89020eca313");
            RSApkcs1 rSApkcs1 = new RSApkcs1();
            rSApkcs1.initialize(AlgID.rsaWithV15Encoding, rSAPublicKey, randomBitsSource);
            byte[] byArray3 = rSApkcs1.encrypt(byArray);
            if (Utils.areEqual(byArray3, byArray)) {
                throw new SelfTestException("RSA Encryption test failed encryption");
            }
            rSApkcs1.initialize(AlgID.rsaWithV15Encoding, rSAPrivateKey, randomBitsSource);
            byte[] byArray4 = rSApkcs1.decrypt(byArray3);
            if (!Utils.areEqual(byArray4, byArray)) {
                throw new SelfTestException("RSA Encryption test failed decryption");
            }
            RSAMDSignature rSAMDSignature = new RSAMDSignature(rSAPrivateKey, AlgID.sha_1, byArray);
            rSAMDSignature.setRandomBitsSource(randomBitsSource);
            byte[] byArray5 = rSAMDSignature.sign();
            if (!Utils.areEqual(byArray5, byArray2)) {
                throw new SelfTestException("RSA Signature known-answer test failed");
            }
            rSAMDSignature.setPublicKey(rSAPublicKey);
            if (!rSAMDSignature.verify()) {
                throw new SelfTestException("RSA Signature pair-wise consistency test failed");
            }
        }
        catch (SelfTestException selfTestException) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_RSA);
            throw selfTestException;
        }
        catch (Throwable throwable) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_RSA);
            throw new SelfTestException(throwable.toString());
        }
    }

    private static void testSHA1() {
        try {
            SHA sHA = new SHA();
            byte[] byArray = "abc".getBytes("ASCII");
            byte[] byArray2 = Utils.fromHexString("A9993E364706816ABA3E25717850C26C9CD0D89D");
            sHA.setAlgID(AlgID.sha_1);
            sHA.update(byArray);
            sHA.computeCurrent();
            byte[] byArray3 = sHA.getDigestBits();
            if (!Utils.areEqual(byArray3, byArray2)) {
                throw new SelfTestException("SHA-1 known-answer test failed");
            }
        }
        catch (SelfTestException selfTestException) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_SHA1_KNOWN_ANSWER);
            throw selfTestException;
        }
        catch (Throwable throwable) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_SHA1_KNOWN_ANSWER);
            throw new SelfTestException(throwable.toString());
        }
    }

    static final class SelfTestThread
    extends Thread {
        public SelfTestThread() {
            FIPS_140_2.setModuleState(ModuleState.TESTING);
        }

        public void run() {
            Object object = STATE_LOCK;
            synchronized (object) {
                FIPS_140_2.selfTest(new DSARandomBitsSource());
            }
        }
    }
}

