/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.fips;

import com.phaos.crypto.AlgID;
import com.phaos.crypto.DSA;
import com.phaos.crypto.DSAPublicKey;
import com.phaos.crypto.SHA;
import com.phaos.fips.FIPS_140_2;
import com.phaos.fips.ModuleState;
import com.phaos.fips.SelfTestException;
import com.phaos.utils.ArrayVector;
import com.phaos.utils.Utils;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

final class IntegrityTest {
    private static Properties digestTab;
    private static final byte[] signature;
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static char[] hexDigit;
    static /* synthetic */ Class class$com$phaos$fips$IntegrityTest;

    static {
        signature = Utils.fromHexString("");
        hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        FIPS_140_2.powerUpSelfTest();
    }

    private IntegrityTest() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static URL getJarFromClassURL(URL uRL) throws IOException {
        if (uRL == null) {
            return null;
        }
        String string = uRL.toString();
        int n = string.lastIndexOf(".jar!/");
        if (n == -1) {
            throw new IOException("Invalid URL for Phaos Crypto JAR " + string);
        }
        return new URL(string.substring("jar:".length(), n += ".jar".length()));
    }

    private static URL getResourceURL(final String string) throws Exception {
        return (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return (class$com$phaos$fips$IntegrityTest != null ? class$com$phaos$fips$IntegrityTest : (class$com$phaos$fips$IntegrityTest = IntegrityTest.class$("com.phaos.fips.IntegrityTest"))).getClassLoader().getResource(string);
            }
        });
    }

    private static InputStream getURLStream(final URL uRL) throws Exception {
        return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return uRL.openStream();
            }
        });
    }

    private static String saveConvert(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2++);
            switch (c) {
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    break;
                }
                case '\t': {
                    stringBuffer.append('\\');
                    stringBuffer.append('t');
                    break;
                }
                case '\n': {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    break;
                }
                case '\r': {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    break;
                }
                case '\f': {
                    stringBuffer.append('\\');
                    stringBuffer.append('f');
                    break;
                }
                default: {
                    if (c < '\u0014' || c > '\u007f') {
                        stringBuffer.append('\\');
                        stringBuffer.append('u');
                        stringBuffer.append(IntegrityTest.toHex(c >> 12 & 0xF));
                        stringBuffer.append(IntegrityTest.toHex(c >> 8 & 0xF));
                        stringBuffer.append(IntegrityTest.toHex(c >> 4 & 0xF));
                        stringBuffer.append(IntegrityTest.toHex(c & 0xF));
                        break;
                    }
                    if (specialSaveChars.indexOf(c) != -1) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static char toHex(int n) {
        return hexDigit[n & 0xF];
    }

    public static void verifyModule(DSAPublicKey dSAPublicKey) {
        try {
            Object object;
            byte[] byArray;
            int n;
            Object object2;
            Object object3;
            URL uRL;
            if (digestTab == null) {
                digestTab = new Properties();
                uRL = IntegrityTest.getResourceURL("com/phaos/fips/resources/digests.properties");
                if (uRL == null) {
                    throw new SelfTestException("Could not get Phaos Crypto JAR digest table");
                }
                digestTab.load(IntegrityTest.getURLStream(uRL));
            }
            if ((uRL = IntegrityTest.getJarFromClassURL(IntegrityTest.getResourceURL("com/phaos/fips/FIPS_140_2.class"))) == null) {
                throw new SelfTestException("Could not get URL for Phaos Crypto JAR");
            }
            ZipInputStream zipInputStream = new ZipInputStream(IntegrityTest.getURLStream(uRL));
            Properties properties = new Properties();
            SHA sHA = new SHA();
            sHA.setAlgID(AlgID.sha_1);
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                object3 = zipEntry.getName();
                int n2 = (int)zipEntry.getSize();
                if (n2 <= 0 || ((String)object3).startsWith("META_INF/") || !((String)object3).endsWith(".class")) continue;
                object2 = new byte[n2];
                int n3 = 0;
                n = 0;
                while (n < n2 && (n3 = zipInputStream.read((byte[])object2, n, n2 - n)) != -1) {
                    n += n3;
                }
                byArray = sHA.computeDigest((byte[])object2);
                object = Utils.fromHexString((String)((Hashtable)digestTab).get(object3));
                if (Utils.areEqual((byte[])object, byArray)) {
                    ((Hashtable)properties).put(object3, Utils.toHexString(byArray));
                    continue;
                }
                zipInputStream.close();
                throw new SelfTestException("Digest verification failed for " + (String)object3);
            }
            zipInputStream.close();
            object3 = IntegrityTest.getResourceURL("com/phaos/fips/resources/signature.bin");
            if (object3 == null) {
                throw new SelfTestException("Could not get Phaos Crypto JAR signature");
            }
            InputStream inputStream = IntegrityTest.getURLStream((URL)object3);
            object2 = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[256];
            n = 0;
            while ((n = inputStream.read(byArray2)) != -1) {
                ((ByteArrayOutputStream)object2).write(byArray2, 0, n);
            }
            byArray = ((ByteArrayOutputStream)object2).toByteArray();
            object = new ByteArrayOutputStream();
            IntegrityTest.writeProperties(properties, (OutputStream)object, null);
            byte[] byArray3 = ((ByteArrayOutputStream)object).toByteArray();
            DSA dSA = new DSA(dSAPublicKey, byArray, byArray3);
            if (!dSA.verify()) {
                throw new SelfTestException("Signature verification failed");
            }
        }
        catch (SelfTestException selfTestException) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_SOFTWARE_INTEGRITY);
            throw selfTestException;
        }
        catch (Throwable throwable) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_SOFTWARE_INTEGRITY);
            throw new SelfTestException(throwable.toString());
        }
    }

    public static void writeProperties(Properties properties, OutputStream outputStream, String string) throws IOException {
        int n;
        int n2;
        Object object;
        ArrayVector arrayVector = new ArrayVector(((Hashtable)properties).size());
        Enumeration enumeration = ((Hashtable)properties).keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            n2 = 0;
            n = arrayVector.size() - 1;
            while (n >= 0) {
                if (((String)object).compareTo((String)arrayVector.elementAt(n)) > 0) {
                    arrayVector.addElementAt(object, n + 1);
                    n2 = 1;
                    break;
                }
                --n;
            }
            if (n2 != 0) continue;
            arrayVector.addElementAt(object, 0);
        }
        object = new BufferedWriter(new OutputStreamWriter(outputStream, "8859_1"));
        if (string != null) {
            IntegrityTest.writeln((BufferedWriter)object, "#" + string);
        }
        n2 = 0;
        n = arrayVector.size();
        while (n2 < n) {
            String string2 = (String)arrayVector.elementAt(n2);
            String string3 = (String)((Hashtable)properties).get(string2);
            string2 = IntegrityTest.saveConvert(string2);
            string3 = IntegrityTest.saveConvert(string3);
            IntegrityTest.writeln((BufferedWriter)object, String.valueOf(string2) + "=" + string3);
            ++n2;
        }
        ((BufferedWriter)object).flush();
    }

    private static void writeln(BufferedWriter bufferedWriter, String string) throws IOException {
        bufferedWriter.write(string);
        bufferedWriter.newLine();
    }
}

