/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.fips;

import com.phaos.crypto.RandomBitsSource;
import com.phaos.fips.FIPS_140_2;
import com.phaos.fips.ModuleState;
import com.phaos.fips.SelfTestException;
import com.phaos.utils.FixedByteArrayOutputStream;
import com.phaos.utils.Utils;
import java.io.IOException;

public final class RNGTest {
    private static final int NUM_RANDOM_BYTES = 4;
    private FixedByteArrayOutputStream lastRandom = new FixedByteArrayOutputStream(4);
    private FixedByteArrayOutputStream nextRandom = new FixedByteArrayOutputStream(4);
    private RandomBitsSource rng;
    private boolean initializing;

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    public RNGTest(RandomBitsSource randomBitsSource) {
        this.rng = randomBitsSource;
    }

    public synchronized void initialize() {
        if (Thread.currentThread() instanceof FIPS_140_2.SelfTestThread) {
            return;
        }
        this.lastRandom.reset();
        this.nextRandom.reset();
        try {
            try {
                this.initializing = true;
                this.lastRandom.write(this.rng.randomBytes(new byte[4]));
            }
            catch (IOException iOException) {
                FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_RNG_CONTINUOUS);
                throw new SelfTestException(iOException.toString());
            }
            Object var2_2 = null;
            this.initializing = false;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.initializing = false;
            throw throwable;
        }
    }

    public synchronized void testRandomByte(byte by) {
        this.testRandomBytes(new byte[]{by}, 0, 1);
    }

    public synchronized void testRandomBytes(byte[] byArray, int n, int n2) {
        if (Thread.currentThread() instanceof FIPS_140_2.SelfTestThread) {
            return;
        }
        try {
            if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
                throw new ArrayIndexOutOfBoundsException("Invalid offset(" + n + ") or length(" + n2 + ")");
            }
            if (this.initializing) {
                return;
            }
            if (this.lastRandom.size() < 4) {
                throw new IllegalStateException("RNGTest not initialized");
            }
            do {
                byte[] byArray2;
                int n3;
                if ((n3 = Math.min(n2, 4 - this.nextRandom.size())) > 0) {
                    this.nextRandom.write(byArray, n, n3);
                    n += n3;
                    n2 -= n3;
                }
                if (this.nextRandom.size() != 4) continue;
                byte[] byArray3 = this.lastRandom.getBytes();
                if (Utils.areEqual(byArray3, byArray2 = this.nextRandom.getBytes())) {
                    throw new SelfTestException("Continuous RNG self-test failed");
                }
                this.lastRandom.reset();
                this.lastRandom.write(byArray2);
                this.nextRandom.reset();
            } while (n2 > 0);
        }
        catch (SelfTestException selfTestException) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_RNG_CONTINUOUS);
            throw selfTestException;
        }
        catch (Throwable throwable) {
            FIPS_140_2.setModuleState(ModuleState.ERROR_TEST_RNG_CONTINUOUS);
            throw new SelfTestException(throwable.toString());
        }
    }
}

