/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.math;

import com.phaos.math.MPN;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.util.Random;

public class BigInt
extends Number
implements Comparable {
    private transient int ival;
    private transient int[] words;
    private int bitCount = -1;
    private int bitLength = -1;
    private int firstNonzeroByteNum = -2;
    private int lowestSetBit = -2;
    private byte[] magnitude;
    private int signum;
    public static final BigInt ZERO = BigInt.valueOf(0L);
    public static final BigInt ONE = BigInt.valueOf(1L);
    public static final BigInt TWO = BigInt.valueOf(2L);
    private static final int FLOOR = 1;
    private static final int CEILING = 2;
    private static final int TRUNCATE = 3;
    private static final int ROUND = 4;
    private static final int[] primes = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251};
    private boolean stillAlive = true;
    private static int[] blank = new int[128];
    private static final byte[] bit4_count;

    static {
        byte[] byArray = new byte[16];
        byArray[1] = 1;
        byArray[2] = 1;
        byArray[3] = 2;
        byArray[4] = 1;
        byArray[5] = 2;
        byArray[6] = 2;
        byArray[7] = 3;
        byArray[8] = 1;
        byArray[9] = 2;
        byArray[10] = 2;
        byArray[11] = 3;
        byArray[12] = 2;
        byArray[13] = 3;
        byArray[14] = 3;
        byArray[15] = 4;
        bit4_count = byArray;
    }

    private BigInt() {
    }

    private BigInt(int n) {
        this.ival = n;
    }

    public BigInt(int n, int n2, Random random) {
        this(n, random);
        while (!this.isProbablePrime(n2)) {
            this.init(n, random);
        }
        return;
    }

    public BigInt(int n, Random random) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.init(n, random);
    }

    public BigInt(int n, byte[] byArray) {
        if (byArray == null || n > 1 || n < -1) {
            throw new NumberFormatException();
        }
        if (n == 0) {
            int n2 = byArray.length - 1;
            while (n2 >= 0 && byArray[n2] == 0) {
                --n2;
            }
            if (n2 >= 0) {
                throw new NumberFormatException();
            }
            return;
        }
        this.words = BigInt.byteArrayToIntArray(byArray, 0);
        BigInt bigInt = BigInt.make(this.words, this.words.length);
        this.ival = bigInt.ival;
        this.words = bigInt.words;
        bigInt.words = null;
        if (n < 0) {
            this.setNegative();
        }
    }

    public BigInt(String string) {
        this(string, 10);
    }

    public BigInt(String string, int n) {
        BigInt bigInt = BigInt.valueOf(string, n);
        this.ival = bigInt.ival;
        this.words = bigInt.words;
        bigInt.words = null;
    }

    public BigInt(byte[] byArray) {
        if (byArray == null || byArray.length < 1) {
            throw new NumberFormatException();
        }
        this.words = BigInt.byteArrayToIntArray(byArray, byArray[0] < 0 ? -1 : 0);
        BigInt bigInt = BigInt.make(this.words, this.words.length);
        this.ival = bigInt.ival;
        this.words = bigInt.words;
        bigInt.words = null;
    }

    public BigInt abs() {
        return BigInt.abs(this);
    }

    private static BigInt abs(BigInt bigInt) {
        return bigInt.isNegative() ? BigInt.neg(bigInt) : bigInt;
    }

    private static final BigInt add(int n, int n2) {
        return BigInt.make((long)n + (long)n2);
    }

    public BigInt add(BigInt bigInt) {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        return BigInt.add(this, bigInt, 1);
    }

    private static BigInt add(BigInt bigInt, int n) {
        if (bigInt.words == null) {
            return BigInt.add(bigInt.ival, n);
        }
        BigInt bigInt2 = new BigInt(0);
        bigInt2.setAdd(bigInt, n);
        return bigInt2.canonicalize();
    }

    private static BigInt add(BigInt bigInt, BigInt bigInt2, int n) {
        BigInt bigInt3;
        if (bigInt.words == null && bigInt2.words == null) {
            return BigInt.make((long)n * (long)bigInt2.ival + (long)bigInt.ival);
        }
        if (n != 1) {
            bigInt2 = n == -1 ? BigInt.neg(bigInt2) : BigInt.times(bigInt2, BigInt.make(n));
        }
        if (bigInt.words == null) {
            return BigInt.add(bigInt2, bigInt.ival);
        }
        if (bigInt2.words == null) {
            return BigInt.add(bigInt, bigInt2.ival);
        }
        if (bigInt2.ival > bigInt.ival) {
            bigInt3 = bigInt;
            bigInt = bigInt2;
            bigInt2 = bigInt3;
        }
        bigInt3 = BigInt.alloc(bigInt.ival + 1);
        int n2 = bigInt2.ival;
        long l = MPN.add_n(bigInt3.words, bigInt.words, bigInt2.words, n2);
        long l2 = bigInt2.words[n2 - 1] < 0 ? 0xFFFFFFFFL : 0L;
        while (n2 < bigInt.ival) {
            bigInt3.words[n2] = (int)(l += ((long)bigInt.words[n2] & 0xFFFFFFFFL) + l2);
            l >>>= 32;
            ++n2;
        }
        if (bigInt.words[n2 - 1] < 0) {
            --l2;
        }
        bigInt3.words[n2] = (int)(l + l2);
        bigInt3.ival = n2 + 1;
        return bigInt3.canonicalize();
    }

    private static BigInt alloc(int n) {
        if (n <= 1) {
            return new BigInt();
        }
        BigInt bigInt = new BigInt();
        bigInt.words = new int[n];
        return bigInt;
    }

    public BigInt and(BigInt bigInt) {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        if (bigInt.words == null) {
            return BigInt.and(this, bigInt.ival);
        }
        if (this.words == null) {
            return BigInt.and(bigInt, this.ival);
        }
        BigInt bigInt2 = this;
        if (this.ival < bigInt.ival) {
            BigInt bigInt3 = this;
            bigInt2 = bigInt;
            bigInt = bigInt3;
        }
        int n = bigInt.isNegative() ? bigInt2.ival : bigInt.ival;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < bigInt.ival) {
            nArray[n2] = bigInt2.words[n2] & bigInt.words[n2];
            ++n2;
        }
        while (n2 < n) {
            nArray[n2] = bigInt2.words[n2];
            ++n2;
        }
        return BigInt.make(nArray, n);
    }

    private static BigInt and(BigInt bigInt, int n) {
        if (bigInt.words == null) {
            return BigInt.make(bigInt.ival & n);
        }
        if (n >= 0) {
            return BigInt.make(bigInt.words[0] & n);
        }
        int n2 = bigInt.ival;
        int[] nArray = new int[n2];
        nArray[0] = bigInt.words[0] & n;
        while (--n2 > 0) {
            nArray[n2] = bigInt.words[n2];
        }
        return BigInt.make(nArray, bigInt.ival);
    }

    public BigInt andNot(BigInt bigInt) {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        return this.and(bigInt.not());
    }

    public int bitCount() {
        int n;
        int n2;
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        int[] nArray = this.words;
        if (nArray == null) {
            n2 = 1;
            n = BigInt.bitCount(this.ival);
        } else {
            n2 = this.ival;
            n = BigInt.bitCount(nArray, n2);
        }
        return this.isNegative() ? n2 * 32 - n : n;
    }

    private static int bitCount(int n) {
        int n2 = 0;
        while (n != 0) {
            n2 += bit4_count[n & 0xF];
            n >>>= 4;
        }
        return n2;
    }

    private static int bitCount(int[] nArray, int n) {
        int n2 = 0;
        while (--n >= 0) {
            n2 += BigInt.bitCount(nArray[n]);
        }
        return n2;
    }

    public int bitLength() {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        if (this.words == null) {
            return MPN.intLength(this.ival);
        }
        return MPN.intLength(this.words, this.ival);
    }

    private static BigInt bitOp(int n, BigInt bigInt, BigInt bigInt2) {
        switch (n) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return bigInt.and(bigInt2);
            }
            case 3: {
                return bigInt;
            }
            case 5: {
                return bigInt2;
            }
            case 15: {
                return BigInt.make(-1L);
            }
        }
        BigInt bigInt3 = new BigInt();
        BigInt.setBitOp(bigInt3, n, bigInt, bigInt2);
        return bigInt3.canonicalize();
    }

    private static int[] byteArrayToIntArray(byte[] byArray, int n) {
        int[] nArray = new int[byArray.length / 4 + 1];
        int n2 = nArray.length;
        int n3 = 0;
        int n4 = n;
        int n5 = byArray.length % 4;
        while (n5 > 0) {
            n4 = n4 << 8 | byArray[n3] & 0xFF;
            --n5;
            ++n3;
        }
        nArray[--n2] = n4;
        while (n2 > 0) {
            nArray[--n2] = byArray[n3++] << 24 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF;
        }
        return nArray;
    }

    private BigInt canonicalize() {
        if (this.words != null && (this.ival = BigInt.wordsNeeded(this.words, this.ival)) <= 1) {
            if (this.ival == 1) {
                this.ival = this.words[0];
            }
            this.words = null;
        }
        return this;
    }

    private boolean checkBits(int n) {
        if (n <= 0) {
            return false;
        }
        if (this.words == null) {
            return n > 31 || (this.ival & (1 << n) - 1) != 0;
        }
        int n2 = 0;
        while (n2 < n >> 5) {
            if (this.words[n2] != 0) {
                return true;
            }
            ++n2;
        }
        return (n & 0x1F) != 0 && (this.words[n2] & (1 << (n & 0x1F)) - 1) != 0;
    }

    public BigInt clearBit(int n) {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        if (n < 0) {
            throw new ArithmeticException();
        }
        return this.and(ONE.shiftLeft(n).not());
    }

    public int compareTo(BigInt bigInt) {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        return BigInt.compareTo(this, bigInt);
    }

    private static int compareTo(BigInt bigInt, BigInt bigInt2) {
        int n;
        boolean bl;
        if (bigInt.words == null && bigInt2.words == null) {
            return bigInt.ival < bigInt2.ival ? -1 : (bigInt.ival > bigInt2.ival ? 1 : 0);
        }
        boolean bl2 = bigInt.isNegative();
        if (bl2 != (bl = bigInt2.isNegative())) {
            return bl2 ? -1 : 1;
        }
        int n2 = bigInt.words == null ? 1 : bigInt.ival;
        int n3 = n = bigInt2.words == null ? 1 : bigInt2.ival;
        if (n2 != n) {
            return n2 > n != bl2 ? 1 : -1;
        }
        return MPN.cmp(bigInt.words, bigInt2.words, n2);
    }

    public int compareTo(Object object) {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        if (object instanceof BigInt) {
            return BigInt.compareTo(this, (BigInt)object);
        }
        throw new ClassCastException();
    }

    private static void divide(long l, long l2, BigInt bigInt, BigInt bigInt2, int n) {
        boolean bl;
        boolean bl2;
        if (l < 0L) {
            bl2 = true;
            if (l == Long.MIN_VALUE) {
                BigInt.divide(BigInt.make(l), BigInt.make(l2), bigInt, bigInt2, n);
                return;
            }
            l = -l;
        } else {
            bl2 = false;
        }
        if (l2 < 0L) {
            bl = true;
            if (l2 == Long.MIN_VALUE) {
                if (n == 3) {
                    if (bigInt != null) {
                        bigInt.set(0L);
                    }
                    if (bigInt2 != null) {
                        bigInt2.set(l);
                    }
                } else {
                    BigInt.divide(BigInt.make(l), BigInt.make(l2), bigInt, bigInt2, n);
                }
                return;
            }
            l2 = -l2;
        } else {
            bl = false;
        }
        long l3 = l / l2;
        long l4 = l % l2;
        boolean bl3 = bl2 ^ bl;
        boolean bl4 = false;
        if (l4 != 0L) {
            switch (n) {
                case 1: 
                case 2: {
                    if (bl3 != (n == 1)) break;
                    bl4 = true;
                    break;
                }
                case 4: {
                    bl4 = l4 > l2 - (l3 & 1L) >> 1;
                    break;
                }
            }
        }
        if (bigInt != null) {
            if (bl4) {
                ++l3;
            }
            if (bl3) {
                l3 = -l3;
            }
            bigInt.set(l3);
        }
        if (bigInt2 != null) {
            if (bl4) {
                l4 = l2 - l4;
                bl2 ^= true;
            }
            if (bl2) {
                l4 = -l4;
            }
            bigInt2.set(l4);
        }
    }

    public BigInt divide(BigInt bigInt) {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        if (bigInt.isZero()) {
            throw new ArithmeticException("divisor is zero");
        }
        BigInt bigInt2 = new BigInt();
        BigInt.divide(this, bigInt, bigInt2, null, 3);
        return bigInt2.canonicalize();
    }

    private static void divide(BigInt bigInt, BigInt bigInt2, BigInt bigInt3, BigInt bigInt4, int n) {
        int n2;
        int n3;
        if (!(bigInt.words != null && bigInt.ival > 2 || bigInt2.words != null && bigInt2.ival > 2)) {
            long l = bigInt.longValue();
            long l2 = bigInt2.longValue();
            if (l != Long.MIN_VALUE && l2 != Long.MIN_VALUE) {
                BigInt.divide(l, l2, bigInt3, bigInt4, n);
                return;
            }
        }
        boolean bl = bigInt.isNegative();
        boolean bl2 = bigInt2.isNegative();
        boolean bl3 = bl ^ bl2;
        int n4 = bigInt2.words == null ? 1 : bigInt2.ival;
        int[] nArray = new int[n4];
        bigInt2.getAbsolute(nArray);
        while (n4 > 1 && nArray[n4 - 1] == 0) {
            --n4;
        }
        int n5 = bigInt.words == null ? 1 : bigInt.ival;
        int[] nArray2 = new int[n5 + 2];
        bigInt.getAbsolute(nArray2);
        while (n5 > 1 && nArray2[n5 - 1] == 0) {
            --n5;
        }
        int n6 = MPN.cmp(nArray2, n5, nArray, n4);
        if (n6 < 0) {
            int[] nArray3 = nArray2;
            nArray2 = nArray;
            nArray = nArray3;
            n3 = n5;
            n2 = 1;
            nArray2[0] = 0;
        } else if (n6 == 0) {
            nArray2[0] = 1;
            n2 = 1;
            nArray[0] = 0;
            n3 = 1;
        } else if (n4 == 1) {
            n2 = n5;
            if (nArray[0] == 1 && nArray2[n5 - 1] < 0) {
                ++n2;
            }
            n3 = 1;
            nArray[0] = MPN.divmod_1(nArray2, nArray2, n5, nArray[0]);
        } else {
            int n7;
            int n8 = MPN.count_leading_zeros(nArray[n4 - 1]);
            if (n8 != 0) {
                MPN.lshift(nArray, 0, nArray, n4, n8);
                n7 = MPN.lshift(nArray2, 0, nArray2, n5, n8);
                nArray2[n5++] = n7;
            }
            if (n5 == n4) {
                nArray2[n5++] = 0;
            }
            MPN.divide(nArray2, n5, nArray, n4);
            n3 = n4;
            MPN.rshift0(nArray, nArray2, 0, n3, n8);
            n2 = n5 + 1 - n4;
            if (bigInt3 != null) {
                n7 = 0;
                while (n7 < n2) {
                    nArray2[n7] = nArray2[n7 + n4];
                    ++n7;
                }
            }
        }
        if (nArray[n3 - 1] < 0) {
            nArray[n3] = 0;
            ++n3;
        }
        boolean bl4 = false;
        if (n3 > 1 || nArray[0] != 0) {
            switch (n) {
                case 1: 
                case 2: {
                    if (bl3 != (n == 1)) break;
                    bl4 = true;
                    break;
                }
                case 4: {
                    BigInt bigInt5 = bigInt4 == null ? new BigInt() : bigInt4;
                    bigInt5.set(nArray, n3);
                    bigInt5 = BigInt.shift(bigInt5, 1);
                    if (bl2) {
                        bigInt5.setNegative();
                    }
                    int n9 = BigInt.compareTo(bigInt5, bigInt2);
                    if (bl2) {
                        n9 = -n9;
                    }
                    boolean bl5 = bl4 = n9 == 1 || n9 == 0 && (nArray2[0] & 1) != 0;
                }
            }
        }
        if (bigInt3 != null) {
            bigInt3.set(nArray2, n2);
            if (bl3) {
                if (bl4) {
                    bigInt3.setInvert();
                } else {
                    bigInt3.setNegative();
                }
            } else if (bl4) {
                bigInt3.setAdd(1);
            }
        }
        if (bigInt4 != null) {
            bigInt4.set(nArray, n3);
            if (bl4) {
                BigInt bigInt6;
                if (bigInt2.words == null) {
                    bigInt6 = bigInt4;
                    bigInt6.set(bl2 ? nArray[0] + bigInt2.ival : nArray[0] - bigInt2.ival);
                } else {
                    bigInt6 = BigInt.add(bigInt4, bigInt2, bl2 ? 1 : -1);
                }
                if (bl) {
                    bigInt4.setNegative(bigInt6);
                } else {
                    bigInt4.set(bigInt6);
                }
            } else if (bl) {
                bigInt4.setNegative();
            }
        }
    }

    public BigInt[] divideAndRemainder(BigInt bigInt) {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        if (bigInt.isZero()) {
            throw new ArithmeticException("divisor is zero");
        }
        BigInt[] bigIntArray = new BigInt[]{new BigInt(), new BigInt()};
        BigInt.divide(this, bigInt, bigIntArray[0], bigIntArray[1], 3);
        bigIntArray[0].canonicalize();
        bigIntArray[1].canonicalize();
        return bigIntArray;
    }

    public double doubleValue() {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        if (this.words == null) {
            return this.ival;
        }
        if (this.ival <= 2) {
            return this.longValue();
        }
        if (this.isNegative()) {
            return BigInt.neg(this).roundToDouble(0, true, false);
        }
        return this.roundToDouble(0, false, false);
    }

    private static boolean equals(BigInt bigInt, BigInt bigInt2) {
        if (bigInt.words == null && bigInt2.words == null) {
            return bigInt.ival == bigInt2.ival;
        }
        if (bigInt.words == null || bigInt2.words == null || bigInt.ival != bigInt2.ival) {
            return false;
        }
        int n = bigInt.ival;
        while (--n >= 0) {
            if (bigInt.words[n] == bigInt2.words[n]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        if (object == null || !(object instanceof BigInt)) {
            return false;
        }
        return BigInt.equals(this, (BigInt)object);
    }

    public void erase() {
        if (this.equals(ZERO) || this.equals(ONE) || this.equals(TWO)) {
            return;
        }
        if (this.words != null) {
            System.arraycopy(blank, 0, this.words, 0, this.words.length);
            this.words = null;
        }
        this.ival = 0;
        this.stillAlive = false;
    }

    private static final int[] euclidInv(int n, int n2, int n3) {
        if (n2 == 0) {
            throw new ArithmeticException("not invertible");
        }
        if (n2 == 1) {
            int[] nArray = new int[3];
            nArray[0] = -n3;
            nArray[1] = 1;
            return nArray;
        }
        int[] nArray = BigInt.euclidInv(n2, n % n2, n / n2);
        nArray[2] = nArray[0];
        nArray[0] = nArray[2] * -n3 + nArray[1];
        nArray[1] = nArray[2];
        return nArray;
    }

    private static final BigInt[] euclidInv(BigInt bigInt, BigInt bigInt2, BigInt bigInt3) {
        BigInt[] bigIntArray;
        if (bigInt2.isZero()) {
            throw new ArithmeticException("not invertible");
        }
        if (bigInt2.isOne()) {
            BigInt[] bigIntArray2 = new BigInt[3];
            bigIntArray2[0] = BigInt.neg(bigInt3);
            bigIntArray2[1] = ONE;
            return bigIntArray2;
        }
        if (bigInt.words == null && bigInt2.words == null) {
            int[] nArray = BigInt.euclidInv(bigInt2.ival, bigInt.ival % bigInt2.ival, bigInt.ival / bigInt2.ival);
            bigIntArray = new BigInt[3];
            bigIntArray[0] = new BigInt(nArray[0]);
            bigIntArray[1] = new BigInt(nArray[1]);
        } else {
            BigInt bigInt4 = new BigInt();
            BigInt bigInt5 = new BigInt();
            BigInt.divide(bigInt, bigInt2, bigInt5, bigInt4, 1);
            bigIntArray = BigInt.euclidInv(bigInt2, bigInt4, bigInt5);
        }
        bigIntArray[2] = bigIntArray[0];
        bigIntArray[0] = BigInt.add(bigIntArray[1], BigInt.times(bigIntArray[2], bigInt3), -1);
        bigIntArray[1] = bigIntArray[2];
        return bigIntArray;
    }

    public BigInt flipBit(int n) {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        if (n < 0) {
            throw new ArithmeticException();
        }
        return this.xor(ONE.shiftLeft(n));
    }

    public float floatValue() {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        return (float)this.doubleValue();
    }

    private void format(int n, StringBuffer stringBuffer) {
        if (this.words == null) {
            stringBuffer.append(Integer.toString(this.ival, n));
        } else if (this.ival <= 2) {
            stringBuffer.append(Long.toString(this.longValue(), n));
        } else {
            int[] nArray;
            boolean bl = this.isNegative();
            if (bl || n != 16) {
                nArray = new int[this.ival];
                this.getAbsolute(nArray);
            } else {
                nArray = this.words;
            }
            int n2 = this.ival;
            int n3 = n2 * (MPN.chars_per_word(n) + 1);
            if (n == 16) {
                if (bl) {
                    stringBuffer.append('-');
                }
                int n4 = stringBuffer.length();
                int n5 = n2;
                while (--n5 >= 0) {
                    int n6 = nArray[n5];
                    int n7 = 8;
                    while (--n7 >= 0) {
                        int n8 = n6 >> 4 * n7 & 0xF;
                        if (n8 <= 0 && stringBuffer.length() <= n4) continue;
                        stringBuffer.append(Character.forDigit(n8, 16));
                    }
                }
            } else {
                int n9;
                int n10 = stringBuffer.length();
                do {
                    n9 = MPN.divmod_1(nArray, nArray, n2, n);
                    stringBuffer.append(Character.forDigit(n9, n));
                    while (n2 > 0 && nArray[n2 - 1] == 0) {
                        --n2;
                    }
                } while (n2 != 0);
                if (bl) {
                    stringBuffer.append('-');
                }
                n9 = stringBuffer.length() - 1;
                while (n10 < n9) {
                    char c = stringBuffer.charAt(n10);
                    stringBuffer.setCharAt(n10, stringBuffer.charAt(n9));
                    stringBuffer.setCharAt(n9, c);
                    ++n10;
                    --n9;
                }
            }
        }
    }

    private static final int gcd(int n, int n2) {
        int n3;
        if (n2 > n) {
            n3 = n;
            n = n2;
            n2 = n3;
        }
        while (n2 != 0) {
            if (n2 == 1) {
                return n2;
            }
            n3 = n2;
            n2 = n % n2;
            n = n3;
        }
        return n;
    }

    public BigInt gcd(BigInt bigInt) {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        int n = this.ival;
        int n2 = bigInt.ival;
        if (this.words == null) {
            if (n == 0) {
                return BigInt.abs(bigInt);
            }
            if (bigInt.words == null && n != Integer.MIN_VALUE && n2 != Integer.MIN_VALUE) {
                if (n < 0) {
                    n = -n;
                }
                if (n2 < 0) {
                    n2 = -n2;
                }
                return BigInt.make(BigInt.gcd(n, n2));
            }
            n = 1;
        }
        if (bigInt.words == null) {
            if (n2 == 0) {
                return BigInt.abs(this);
            }
            n2 = 1;
        }
        int n3 = (n > n2 ? n : n2) + 1;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        this.getAbsolute(nArray);
        bigInt.getAbsolute(nArray2);
        n3 = MPN.gcd(nArray, nArray2, n3);
        BigInt bigInt2 = new BigInt(0);
        bigInt2.ival = n3;
        bigInt2.words = nArray;
        return bigInt2.canonicalize();
    }

    private void getAbsolute(int[] nArray) {
        int n;
        int n2;
        if (this.words == null) {
            n2 = 1;
            nArray[0] = this.ival;
        } else {
            n = n2 = this.ival;
            while (--n >= 0) {
                nArray[n] = this.words[n];
            }
        }
        if (nArray[n2 - 1] < 0) {
            BigInt.negate(nArray, nArray, n2);
        }
        n = nArray.length;
        while (--n > n2) {
            nArray[n] = 0;
        }
    }

    public static BigInt getInstance(BigInt bigInt) {
        return new BigInt(bigInt.toByteArray());
    }

    public static BigInt getInstance(BigInteger bigInteger) {
        return new BigInt(bigInteger.toByteArray());
    }

    public int getLowestSetBit() {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        if (this.isZero()) {
            return -1;
        }
        if (this.words == null) {
            return MPN.findLowestBit(this.ival);
        }
        return MPN.findLowestBit(this.words);
    }

    public int hashCode() {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        return this.words == null ? this.ival : this.words[0] + this.words[this.ival - 1];
    }

    private void init(int n, Random random) {
        int n2 = n & 0x1F;
        if (n2 > 0) {
            n2 = random.nextInt() >>> 32 - n2;
        }
        int n3 = n / 32;
        while (n2 == 0 && n3 > 0) {
            n2 = random.nextInt();
            --n3;
        }
        if (n3 == 0 && n2 >= 0) {
            this.ival = n2;
        } else {
            this.ival = n2 < 0 ? n3 + 2 : n3 + 1;
            this.words = new int[this.ival];
            this.words[n3] = n2;
            while (--n3 >= 0) {
                this.words[n3] = random.nextInt();
            }
        }
    }

    public int intValue() {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        if (this.words == null) {
            return this.ival;
        }
        return this.words[0];
    }

    private final boolean isMinusOne() {
        return this.words == null && this.ival == -1;
    }

    private final boolean isNegative() {
        return (this.words == null ? this.ival : this.words[this.ival - 1]) < 0;
    }

    private final boolean isOdd() {
        int n = this.words == null ? this.ival : this.words[0];
        return (n & 1) != 0;
    }

    private final boolean isOne() {
        return this.words == null && this.ival == 1 || this.ival == 1 && this.words != null && this.words[0] == 1;
    }

    public boolean isProbablePrime(int n) {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        int n2 = 0;
        while (n2 < primes.length) {
            if (this.words == null && this.ival == primes[n2]) {
                return true;
            }
            if (this.remainder(BigInt.make(primes[n2])).isZero()) {
                return false;
            }
            ++n2;
        }
        BigInt bigInt = BigInt.add(this, -1);
        int n3 = bigInt.getLowestSetBit();
        BigInt bigInt2 = bigInt.divide(BigInt.make(2L << n3 - 1));
        Random random = new Random();
        while (n-- > 0) {
            int n4 = random.nextInt();
            n4 = (n4 < 0 ? -n4 : n4) % 1023 + 2;
            BigInt bigInt3 = BigInt.make(n4).modPow(bigInt2, this);
            if (bigInt3.isOne() || bigInt3.equals(bigInt)) continue;
            int n5 = 0;
            while (n5 < n3) {
                if (bigInt3.isOne()) {
                    return false;
                }
                ++n5;
                if (bigInt3.equals(bigInt)) break;
                bigInt3 = bigInt3.modPow(BigInt.make(2L), this);
            }
            if (n5 != n3 || bigInt3.equals(bigInt)) continue;
            return false;
        }
        return true;
    }

    private final boolean isZero() {
        return this.words == null && this.ival == 0 || this.ival == 1 && this.words != null && this.words[0] == 0;
    }

    public long longValue() {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        if (this.words == null) {
            return this.ival;
        }
        if (this.ival == 1) {
            return this.words[0];
        }
        return ((long)this.words[1] << 32) + ((long)this.words[0] & 0xFFFFFFFFL);
    }

    private static BigInt make(long l) {
        int n = (int)l;
        if ((long)n == l) {
            return new BigInt(n);
        }
        BigInt bigInt = BigInt.alloc(2);
        bigInt.ival = 2;
        bigInt.words[0] = n;
        bigInt.words[1] = (int)(l >> 32);
        return bigInt;
    }

    private static BigInt make(int[] nArray, int n) {
        if (nArray == null) {
            return BigInt.make(n);
        }
        if ((n = BigInt.wordsNeeded(nArray, n)) <= 1) {
            return n == 0 ? ZERO : BigInt.make(nArray[0]);
        }
        BigInt bigInt = new BigInt();
        bigInt.words = nArray;
        bigInt.ival = n;
        return bigInt;
    }

    public BigInt max(BigInt bigInt) {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        return BigInt.compareTo(this, bigInt) > 0 ? this : bigInt;
    }

    public BigInt min(BigInt bigInt) {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        return BigInt.compareTo(this, bigInt) < 0 ? this : bigInt;
    }

    public BigInt mod(BigInt bigInt) {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        if (bigInt.isNegative() || bigInt.isZero()) {
            throw new ArithmeticException("non-positive modulus");
        }
        BigInt bigInt2 = new BigInt();
        BigInt.divide(this, bigInt, null, bigInt2, 1);
        return bigInt2.canonicalize();
    }

    public BigInt modInverse(BigInt bigInt) {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        if (bigInt.isNegative() || bigInt.isZero()) {
            throw new ArithmeticException("non-positive modulo");
        }
        if (bigInt.isOne()) {
            return ZERO;
        }
        if (this.isOne()) {
            return ONE;
        }
        BigInt bigInt2 = new BigInt();
        int n = this.ival;
        int n2 = bigInt.ival;
        boolean bl = false;
        if (bigInt.words == null) {
            if (this.words != null || this.isNegative()) {
                n = this.mod((BigInt)bigInt).ival;
            }
            if (n2 > n) {
                int n3 = n;
                n = n2;
                n2 = n3;
                bl = true;
            }
            bigInt2.ival = BigInt.euclidInv(n2, n % n2, n / n2)[bl ? 0 : 1];
            if (bigInt2.ival < 0) {
                bigInt2.ival += bigInt.ival;
            }
        } else {
            BigInt bigInt3;
            BigInt bigInt4 = this;
            if (this.isNegative() && (bigInt4 = this.mod(bigInt)).isOne()) {
                return ONE;
            }
            if (bigInt4.compareTo(bigInt) < 0) {
                bigInt3 = bigInt4;
                bigInt4 = bigInt;
                bigInt = bigInt3;
                bl = true;
            }
            bigInt3 = new BigInt();
            BigInt bigInt5 = new BigInt();
            BigInt.divide(bigInt4, bigInt, bigInt5, bigInt3, 1);
            bigInt2 = BigInt.euclidInv(bigInt, bigInt3, bigInt5)[bl ? 0 : 1];
            if (bigInt2.isNegative()) {
                bigInt2 = BigInt.add(bigInt2, bl ? bigInt4 : bigInt, 1);
            }
        }
        return bigInt2;
    }

    public BigInt modPow(BigInt bigInt, BigInt bigInt2) {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        if (bigInt2.isNegative() || bigInt2.isZero()) {
            throw new ArithmeticException("non-positive modulo");
        }
        if (bigInt.isNegative()) {
            return this.modInverse(bigInt2);
        }
        if (bigInt.isOne()) {
            return this.mod(bigInt2);
        }
        BigInt bigInt3 = ONE;
        BigInt bigInt4 = this;
        BigInt bigInt5 = bigInt;
        while (!bigInt5.isZero()) {
            if (bigInt5.and(ONE).isOne()) {
                bigInt3 = BigInt.times(bigInt3, bigInt4).mod(bigInt2);
            }
            bigInt5 = bigInt5.shiftRight(1);
            bigInt4 = BigInt.times(bigInt4, bigInt4).mod(bigInt2);
        }
        return bigInt3;
    }

    public BigInt multiply(BigInt bigInt) {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        return BigInt.times(this, bigInt);
    }

    private static BigInt neg(BigInt bigInt) {
        if (bigInt.words == null && bigInt.ival != Integer.MIN_VALUE) {
            return BigInt.make(-bigInt.ival);
        }
        BigInt bigInt2 = new BigInt(0);
        bigInt2.setNegative(bigInt);
        return bigInt2.canonicalize();
    }

    public BigInt negate() {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        return BigInt.neg(this);
    }

    private static boolean negate(int[] nArray, int[] nArray2, int n) {
        long l = 1L;
        boolean bl = nArray2[n - 1] < 0;
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = (int)(l += (long)(~nArray2[n2]) & 0xFFFFFFFFL);
            l >>= 32;
            ++n2;
        }
        return bl && nArray[n - 1] < 0;
    }

    public BigInt not() {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        return BigInt.bitOp(12, this, ZERO);
    }

    public BigInt or(BigInt bigInt) {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        return BigInt.bitOp(7, this, bigInt);
    }

    public BigInt pow(int n) {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        if (n <= 0) {
            if (n == 0) {
                return ONE;
            }
            throw new ArithmeticException("negative exponent");
        }
        if (this.isZero()) {
            return this;
        }
        int n2 = this.words == null ? 1 : this.ival;
        int n3 = (this.bitLength() * n >> 5) + 2 * n2;
        boolean bl = this.isNegative() && (n & 1) != 0;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        this.getAbsolute(nArray);
        int n4 = 1;
        nArray2[0] = 1;
        block0: while (true) {
            int[] nArray4;
            if ((n & 1) != 0) {
                MPN.mul(nArray3, nArray, n2, nArray2, n4);
                nArray4 = nArray3;
                nArray3 = nArray2;
                nArray2 = nArray4;
                n4 += n2;
                while (nArray2[n4 - 1] == 0) {
                    --n4;
                }
            }
            if ((n >>= 1) == 0) break;
            MPN.mul(nArray3, nArray, n2, nArray, n2);
            nArray4 = nArray3;
            nArray3 = nArray;
            nArray = nArray4;
            n2 *= 2;
            while (true) {
                if (nArray[n2 - 1] != 0) continue block0;
                --n2;
            }
            break;
        }
        if (nArray2[n4 - 1] < 0) {
            ++n4;
        }
        if (bl) {
            BigInt.negate(nArray2, nArray2, n4);
        }
        return BigInt.make(nArray2, n4);
    }

    private BigInt pow(BigInt bigInt) {
        if (this.isOne()) {
            return this;
        }
        if (this.isMinusOne()) {
            return bigInt.isOdd() ? this : ONE;
        }
        if (bigInt.words == null && bigInt.ival >= 0) {
            return this.pow(bigInt.ival);
        }
        if (this.isZero()) {
            return this;
        }
        BigInt bigInt2 = this;
        BigInt bigInt3 = null;
        while (true) {
            if (bigInt.isOdd()) {
                BigInt bigInt4 = bigInt3 = bigInt3 == null ? bigInt2 : BigInt.times(bigInt3, bigInt2);
            }
            if ((bigInt = BigInt.shift(bigInt, -1)).isZero()) break;
            bigInt2 = BigInt.times(bigInt2, bigInt2);
        }
        return bigInt3 == null ? ONE : bigInt3;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.words = BigInt.byteArrayToIntArray(this.magnitude, this.signum < 0 ? -1 : 0);
        BigInt bigInt = BigInt.make(this.words, this.words.length);
        this.ival = bigInt.ival;
        this.words = bigInt.words;
        bigInt.words = null;
    }

    private void realloc(int n) {
        if (n == 0) {
            if (this.words != null) {
                if (this.ival > 0) {
                    this.ival = this.words[0];
                }
                this.words = null;
            }
        } else if (this.words == null || this.words.length < n || this.words.length > n + 2) {
            int[] nArray = new int[n];
            if (this.words == null) {
                nArray[0] = this.ival;
                this.ival = 1;
            } else {
                if (n < this.ival) {
                    this.ival = n;
                }
                System.arraycopy(this.words, 0, nArray, 0, this.ival);
            }
            this.words = nArray;
        }
    }

    public BigInt remainder(BigInt bigInt) {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        if (bigInt.isZero()) {
            throw new ArithmeticException("divisor is zero");
        }
        BigInt bigInt2 = new BigInt();
        BigInt.divide(this, bigInt, null, bigInt2, 3);
        return bigInt2.canonicalize();
    }

    private double roundToDouble(int n, boolean bl, boolean bl2) {
        int n2 = this.bitLength();
        if ((n += n2 - 1) < -1075) {
            return bl ? -0.0 : 0.0;
        }
        if (n > 1023) {
            return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        }
        int n3 = n >= -1022 ? 53 : 53 + n + 1022;
        int n4 = n2 - (n3 + 1);
        long l = n4 > 0 ? (this.words == null ? (long)(this.ival >> n4) : MPN.rshift_long(this.words, this.ival, n4)) : this.longValue() << -n4;
        if (n == 1023 && l >> 1 == 0x1FFFFFFFFFFFFFL) {
            if (bl2 || this.checkBits(n2 - n3)) {
                return bl ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            return bl ? -1.7976931348623157E308 : Double.MAX_VALUE;
        }
        if ((l & 1L) == 1L && ((l & 2L) == 2L || bl2 || this.checkBits(n4))) {
            if (((l += 2L) & 0x40000000000000L) != 0L) {
                ++n;
                l >>= 1;
            } else if (n3 == 52 && (l & 0x20000000000000L) != 0L) {
                ++n;
            }
        }
        long l2 = bl ? Long.MIN_VALUE : 0L;
        long l3 = (n += 1023) <= 0 ? 0L : (long)n << 52;
        long l4 = (l >>= 1) & 0xFFEFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(l2 | l3 | l4);
    }

    private final void set(long l) {
        int n = (int)l;
        if ((long)n == l) {
            this.ival = n;
            this.words = null;
        } else {
            this.realloc(2);
            this.words[0] = n;
            this.words[1] = (int)(l >> 32);
            this.ival = 2;
        }
    }

    private final void set(BigInt bigInt) {
        if (bigInt.words == null) {
            this.set(bigInt.ival);
        } else if (this != bigInt) {
            this.realloc(bigInt.ival);
            System.arraycopy(bigInt.words, 0, this.words, 0, bigInt.ival);
            this.ival = bigInt.ival;
        }
    }

    private final void set(int[] nArray, int n) {
        this.ival = n;
        this.words = nArray;
    }

    private final void setAdd(int n) {
        this.setAdd(this, n);
    }

    private void setAdd(BigInt bigInt, int n) {
        if (bigInt.words == null) {
            this.set((long)bigInt.ival + (long)n);
            return;
        }
        int n2 = bigInt.ival;
        this.realloc(n2 + 1);
        long l = n;
        int n3 = 0;
        while (n3 < n2) {
            this.words[n3] = (int)(l += (long)bigInt.words[n3] & 0xFFFFFFFFL);
            l >>= 32;
            ++n3;
        }
        if (bigInt.words[n2 - 1] < 0) {
            --l;
        }
        this.words[n2] = (int)l;
        this.ival = BigInt.wordsNeeded(this.words, n2 + 1);
    }

    public BigInt setBit(int n) {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        if (n < 0) {
            throw new ArithmeticException();
        }
        return this.or(ONE.shiftLeft(n));
    }

    private static void setBitOp(BigInt bigInt, int n, BigInt bigInt2, BigInt bigInt3) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (bigInt3.words != null && (bigInt2.words == null || bigInt2.ival < bigInt3.ival)) {
            BigInt bigInt4 = bigInt2;
            bigInt2 = bigInt3;
            bigInt3 = bigInt4;
            n = BigInt.swappedOp(n);
        }
        if (bigInt3.words == null) {
            n6 = bigInt3.ival;
            n5 = 1;
        } else {
            n6 = bigInt3.words[0];
            n5 = bigInt3.ival;
        }
        if (bigInt2.words == null) {
            n4 = bigInt2.ival;
            n3 = 1;
        } else {
            n4 = bigInt2.words[0];
            n3 = bigInt2.ival;
        }
        if (n3 > 1) {
            bigInt.realloc(n3);
        }
        int[] nArray = bigInt.words;
        int n7 = 0;
        int n8 = 0;
        block0 : switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                while (true) {
                    n2 = n4 & n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInt2.words[n7];
                    n6 = bigInt3.words[n7];
                }
                if (n6 >= 0) break;
                n8 = 1;
                break;
            }
            case 2: {
                while (true) {
                    n2 = n4 & ~n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInt2.words[n7];
                    n6 = bigInt3.words[n7];
                }
                if (n6 < 0) break;
                n8 = 1;
                break;
            }
            case 3: {
                n2 = n4;
                n8 = 1;
                break;
            }
            case 4: {
                while (true) {
                    n2 = ~n4 & n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInt2.words[n7];
                    n6 = bigInt3.words[n7];
                }
                if (n6 >= 0) break;
                n8 = 2;
                break;
            }
            case 5: {
                while (true) {
                    n2 = n6;
                    if (n7 + 1 >= n5) break block0;
                    nArray[n7++] = n2;
                    n4 = bigInt2.words[n7];
                    n6 = bigInt3.words[n7];
                }
            }
            case 6: {
                while (true) {
                    n2 = n4 ^ n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInt2.words[n7];
                    n6 = bigInt3.words[n7];
                }
                n8 = n6 < 0 ? 2 : 1;
                break;
            }
            case 7: {
                while (true) {
                    n2 = n4 | n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInt2.words[n7];
                    n6 = bigInt3.words[n7];
                }
                if (n6 < 0) break;
                n8 = 1;
                break;
            }
            case 8: {
                while (true) {
                    n2 = ~(n4 | n6);
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInt2.words[n7];
                    n6 = bigInt3.words[n7];
                }
                if (n6 < 0) break;
                n8 = 2;
                break;
            }
            case 9: {
                while (true) {
                    n2 = ~(n4 ^ n6);
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInt2.words[n7];
                    n6 = bigInt3.words[n7];
                }
                n8 = n6 >= 0 ? 2 : 1;
                break;
            }
            case 10: {
                while (true) {
                    n2 = ~n6;
                    if (n7 + 1 >= n5) break block0;
                    nArray[n7++] = n2;
                    n4 = bigInt2.words[n7];
                    n6 = bigInt3.words[n7];
                }
            }
            case 11: {
                while (true) {
                    n2 = n4 | ~n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInt2.words[n7];
                    n6 = bigInt3.words[n7];
                }
                if (n6 >= 0) break;
                n8 = 1;
                break;
            }
            case 12: {
                n2 = ~n4;
                n8 = 2;
                break;
            }
            case 13: {
                while (true) {
                    n2 = ~n4 | n6;
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInt2.words[n7];
                    n6 = bigInt3.words[n7];
                }
                if (n6 < 0) break;
                n8 = 2;
                break;
            }
            case 14: {
                while (true) {
                    n2 = ~(n4 & n6);
                    if (n7 + 1 >= n5) break;
                    nArray[n7++] = n2;
                    n4 = bigInt2.words[n7];
                    n6 = bigInt3.words[n7];
                }
                if (n6 >= 0) break;
                n8 = 2;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        if (n7 + 1 == n3) {
            n8 = 0;
        }
        switch (n8) {
            case 0: {
                if (n7 == 0 && nArray == null) {
                    bigInt.ival = n2;
                    return;
                }
                nArray[n7++] = n2;
                break;
            }
            case 1: {
                nArray[n7] = n2;
                while (++n7 < n3) {
                    nArray[n7] = bigInt2.words[n7];
                }
                break;
            }
            case 2: {
                nArray[n7] = n2;
                while (++n7 < n3) {
                    nArray[n7] = ~bigInt2.words[n7];
                }
                break;
            }
        }
        bigInt.ival = n7;
    }

    private void setInvert() {
        if (this.words == null) {
            this.ival ^= 0xFFFFFFFF;
        } else {
            int n = this.ival;
            while (--n >= 0) {
                this.words[n] = ~this.words[n];
            }
        }
    }

    private final void setNegative() {
        this.setNegative(this);
    }

    private void setNegative(BigInt bigInt) {
        int n = bigInt.ival;
        if (bigInt.words == null) {
            if (n == Integer.MIN_VALUE) {
                this.set(-((long)n));
            } else {
                this.set(-n);
            }
            return;
        }
        this.realloc(n + 1);
        if (BigInt.negate(this.words, bigInt.words, n)) {
            this.words[n++] = 0;
        }
        this.ival = n;
    }

    private void setShift(BigInt bigInt, int n) {
        if (n > 0) {
            this.setShiftLeft(bigInt, n);
        } else {
            this.setShiftRight(bigInt, -n);
        }
    }

    private void setShiftLeft(BigInt bigInt, int n) {
        int n2;
        int n3;
        int[] nArray;
        if (bigInt.words == null) {
            if (n < 32) {
                this.set((long)bigInt.ival << n);
                return;
            }
            nArray = new int[]{bigInt.ival};
            n3 = 1;
        } else {
            nArray = bigInt.words;
            n3 = bigInt.ival;
        }
        int n4 = n >> 5;
        int n5 = n3 + n4;
        if ((n &= 0x1F) == 0) {
            this.realloc(n5);
            n2 = n3;
            while (--n2 >= 0) {
                this.words[n2 + n4] = nArray[n2];
            }
        } else {
            this.realloc(++n5);
            n2 = MPN.lshift(this.words, n4, nArray, n3, n);
            n = 32 - n;
            this.words[n5 - 1] = n2 << n >> n;
        }
        this.ival = n5;
        n2 = n4;
        while (--n2 >= 0) {
            this.words[n2] = 0;
        }
    }

    private void setShiftRight(BigInt bigInt, int n) {
        if (bigInt.words == null) {
            this.set(n < 32 ? bigInt.ival >> n : (bigInt.ival < 0 ? -1 : 0));
        } else if (n == 0) {
            this.set(bigInt);
        } else {
            boolean bl = bigInt.isNegative();
            int n2 = n >> 5;
            n &= 0x1F;
            int n3 = bigInt.ival - n2;
            if (n3 <= 0) {
                this.set(bl ? -1 : 0);
            } else {
                if (this.words == null || this.words.length < n3) {
                    this.realloc(n3);
                }
                MPN.rshift0(this.words, bigInt.words, n2, n3, n);
                this.ival = n3;
                if (bl) {
                    int n4 = n3 - 1;
                    this.words[n4] = this.words[n4] | -2 << 31 - n;
                }
            }
        }
    }

    private static BigInt shift(BigInt bigInt, int n) {
        if (bigInt.words == null) {
            if (n <= 0) {
                return BigInt.make(n > -32 ? bigInt.ival >> -n : (bigInt.ival < 0 ? -1 : 0));
            }
            if (n < 32) {
                return BigInt.make((long)bigInt.ival << n);
            }
        }
        if (n == 0) {
            return bigInt;
        }
        BigInt bigInt2 = new BigInt(0);
        bigInt2.setShift(bigInt, n);
        return bigInt2.canonicalize();
    }

    public BigInt shiftLeft(int n) {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        return BigInt.shift(this, n);
    }

    public BigInt shiftRight(int n) {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        return BigInt.shift(this, -n);
    }

    public int signum() {
        int n;
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        int n2 = n = this.words == null ? this.ival : this.words[this.ival - 1];
        if (n == 0 && this.words == null) {
            return 0;
        }
        return n < 0 ? -1 : 1;
    }

    public BigInt subtract(BigInt bigInt) {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        return BigInt.add(this, bigInt, -1);
    }

    private static int swappedOp(int n) {
        return "\u0000\u0001\u0004\u0005\u0002\u0003\u0006\u0007\b\t\f\r\n\u000b\u000e\u000f".charAt(n);
    }

    public boolean testBit(int n) {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        if (n < 0) {
            throw new ArithmeticException();
        }
        return this.and(ONE.shiftLeft(n)).isZero() ^ true;
    }

    private static final BigInt times(BigInt bigInt, int n) {
        boolean bl;
        if (n == 0) {
            return ZERO;
        }
        if (n == 1) {
            return bigInt;
        }
        int[] nArray = bigInt.words;
        int n2 = bigInt.ival;
        if (nArray == null) {
            return BigInt.make((long)n2 * (long)n);
        }
        BigInt bigInt2 = BigInt.alloc(n2 + 1);
        if (nArray[n2 - 1] < 0) {
            bl = true;
            BigInt.negate(bigInt2.words, nArray, n2);
            nArray = bigInt2.words;
        } else {
            bl = false;
        }
        if (n < 0) {
            bl ^= true;
            n = -n;
        }
        bigInt2.words[n2] = MPN.mul_1(bigInt2.words, nArray, n2, n);
        bigInt2.ival = n2 + 1;
        if (bl) {
            bigInt2.setNegative();
        }
        return bigInt2.canonicalize();
    }

    private static final BigInt times(BigInt bigInt, BigInt bigInt2) {
        Object object;
        int[] nArray;
        int[] nArray2;
        if (bigInt2.words == null) {
            return BigInt.times(bigInt, bigInt2.ival);
        }
        if (bigInt.words == null) {
            return BigInt.times(bigInt2, bigInt.ival);
        }
        boolean bl = false;
        int n = bigInt.ival;
        int n2 = bigInt2.ival;
        if (bigInt.isNegative()) {
            bl = true;
            nArray2 = new int[n];
            BigInt.negate(nArray2, bigInt.words, n);
        } else {
            bl = false;
            nArray2 = bigInt.words;
        }
        if (bigInt2.isNegative()) {
            bl ^= true;
            nArray = new int[n2];
            BigInt.negate(nArray, bigInt2.words, n2);
        } else {
            nArray = bigInt2.words;
        }
        if (n < n2) {
            object = nArray2;
            nArray2 = nArray;
            nArray = object;
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        object = BigInt.alloc(n + n2);
        MPN.mul(((BigInt)object).words, nArray2, n, nArray, n2);
        ((BigInt)object).ival = n + n2;
        if (bl) {
            super.setNegative();
        }
        return super.canonicalize();
    }

    public byte[] toByteArray() {
        int n;
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        byte[] byArray = new byte[(this.bitLength() + 1 + 7) / 8];
        int n2 = byArray.length;
        int n3 = 0;
        while (n2 > 4) {
            n = this.words[n3++];
            int n4 = 4;
            while (n4 > 0) {
                byArray[--n2] = (byte)n;
                --n4;
                n >>= 8;
            }
        }
        n = this.words == null ? this.ival : this.words[n3];
        while (n2 > 0) {
            byArray[--n2] = (byte)n;
            n >>= 8;
        }
        return byArray;
    }

    public String toString() {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        return this.toString(10);
    }

    public String toString(int n) {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        if (this.words == null) {
            return Integer.toString(this.ival, n);
        }
        if (this.ival <= 2) {
            return Long.toString(this.longValue(), n);
        }
        int n2 = this.ival * (MPN.chars_per_word(n) + 1);
        StringBuffer stringBuffer = new StringBuffer(n2);
        this.format(n, stringBuffer);
        return stringBuffer.toString();
    }

    public static BigInt valueOf(long l) {
        return BigInt.make(l);
    }

    private static BigInt valueOf(String string, int n) throws NumberFormatException {
        int n2 = string.length();
        if (n2 <= 15 && n <= 16) {
            return BigInt.make(Long.parseLong(string, n));
        }
        int n3 = 0;
        byte[] byArray = new byte[n2];
        boolean bl = false;
        int n4 = 0;
        while (n4 < n2) {
            char c = string.charAt(n4);
            if (c == '-') {
                bl = true;
            } else if (c != '_' && (n3 != 0 || c != ' ' && c != '\t')) {
                int n5 = Character.digit(c, n);
                if (n5 < 0) break;
                byArray[n3++] = (byte)n5;
            }
            ++n4;
        }
        return BigInt.valueOf(byArray, n3, bl, n);
    }

    private static BigInt valueOf(byte[] byArray, int n, boolean bl, int n2) {
        int n3 = MPN.chars_per_word(n2);
        int[] nArray = new int[n / n3 + 1];
        int n4 = MPN.set_str(nArray, byArray, n, n2);
        if (n4 == 0) {
            return ZERO;
        }
        if (nArray[n4 - 1] < 0) {
            nArray[n4++] = 0;
        }
        if (bl) {
            BigInt.negate(nArray, nArray, n4);
        }
        return BigInt.make(nArray, n4);
    }

    /*
     * Unable to fully structure code
     */
    private static int wordsNeeded(int[] var0, int var1_1) {
        block3: {
            var2_2 = var1_1;
            if (var2_2 <= 0) break block3;
            if ((var3_3 = var0[--var2_2]) != -1) ** GOTO lbl11
            while (var2_2 > 0 && (var3_3 = var0[var2_2 - 1]) < 0) {
                --var2_2;
                if (var3_3 == -1) {
                    continue;
                }
                break block3;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                --var2_2;
lbl11:
                // 2 sources

                ** while (var3_3 == 0 && var2_2 > 0 && (var3_3 = var0[var2_2 - 1]) >= 0)
            }
        }
        return var2_2 + 1;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        this.signum = this.signum();
        this.magnitude = this.toByteArray();
        objectOutputStream.defaultWriteObject();
    }

    public BigInt xor(BigInt bigInt) {
        if (!this.stillAlive) {
            throw new IllegalStateException("This BigInt has been erased");
        }
        return BigInt.bitOp(6, this, bigInt);
    }
}

