/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.math;

import com.phaos.crypto.ECC;
import com.phaos.math.BigInt;
import com.phaos.math.BinaryEllipticCurve;
import com.phaos.math.BinaryField;
import com.phaos.math.BinaryFieldValue;
import com.phaos.math.ECException;
import com.phaos.math.ECPoint;
import com.phaos.math.ECUtils;
import com.phaos.math.EllipticCurve;
import com.phaos.math.Field;
import com.phaos.math.FieldElement;
import com.phaos.math.FieldValue;
import com.phaos.utils.Utils;

public class BinaryECPoint
extends ECPoint {
    private static final EllipticCurve B_163_CURVE;
    private static final FieldValue[][] B163;
    private static final FieldValue[][] M163;

    static {
        BinaryField binaryField = new BinaryField(ECC.b_163);
        BinaryFieldValue binaryFieldValue = new BinaryFieldValue(Utils.fromHexString("072546B5435234A422E0789675F432C89435DE5242"));
        BinaryFieldValue binaryFieldValue2 = new BinaryFieldValue(Utils.fromHexString("00C9517D06D5240D3CFF38C74B20B6CD4D6F9DD4D9"));
        BinaryFieldValue binaryFieldValue3 = new BinaryFieldValue(Utils.fromHexString("07af69989546103d79329fcc3d74880f33bbe803cb"));
        BinaryFieldValue binaryFieldValue4 = new BinaryFieldValue(Utils.fromHexString("01ec23211b5966adea1d3f87f7ea5848aef0b7ca9f"));
        try {
            B_163_CURVE = EllipticCurve.getInstance(new FieldElement(binaryField, binaryFieldValue), new FieldElement(binaryField, binaryFieldValue2), null);
        }
        catch (ECException eCException) {
            throw new RuntimeException(eCException.toString());
        }
        B163 = BinaryECPoint.preComputeFBC(binaryField, binaryFieldValue, binaryFieldValue3, binaryFieldValue4, 5);
        M163 = BinaryECPoint.preComputeINME(binaryField, binaryFieldValue, binaryFieldValue3, binaryFieldValue4, 4);
    }

    BinaryECPoint(BinaryEllipticCurve binaryEllipticCurve, int[] nArray, int[] nArray2) {
        BinaryField binaryField = (BinaryField)binaryEllipticCurve.getField();
        this.curve = binaryEllipticCurve;
        this.x = binaryField.createFieldElement(nArray);
        this.y = binaryField.createFieldElement(nArray2);
    }

    BinaryECPoint(EllipticCurve ellipticCurve, FieldElement fieldElement, FieldElement fieldElement2) {
        super(ellipticCurve, fieldElement, fieldElement2);
    }

    BinaryECPoint(EllipticCurve ellipticCurve, byte[] byArray) {
        super(ellipticCurve, byArray);
    }

    public ECPoint add(ECPoint eCPoint) throws ECException {
        if (!this.curve.equals(eCPoint.getCurve())) {
            throw new ECException("The points are on different curves.");
        }
        if (this.isPointZero()) {
            return eCPoint;
        }
        if (eCPoint.isPointZero()) {
            return new BinaryECPoint(this.curve, this.x, this.y);
        }
        if (this.equals(eCPoint)) {
            return this.doubling();
        }
        if (eCPoint.equals(this.negate())) {
            return this.curve.getPointZero();
        }
        FieldValue[] fieldValueArray = BinaryECPoint.add(this.field, this.curve.getA().getFieldValue(), new FieldValue[]{this.x.getFieldValue(), this.y.getFieldValue()}, new FieldValue[]{eCPoint.x.getFieldValue(), eCPoint.y.getFieldValue()}, null);
        return new BinaryECPoint(this.curve, new FieldElement(this.field, fieldValueArray[0]), new FieldElement(this.field, fieldValueArray[1]));
    }

    private static FieldValue[] add(Field field, FieldValue fieldValue, FieldValue[] fieldValueArray, FieldValue[] fieldValueArray2, FieldValue[] fieldValueArray3) {
        int n;
        int n2 = n = fieldValueArray.length == 0 && fieldValueArray2.length == 0 ? 0 : 2;
        if (fieldValueArray3 == null || fieldValueArray3.length != n) {
            fieldValueArray3 = new FieldValue[n];
        }
        if (fieldValueArray.length == 0) {
            fieldValueArray3 = (FieldValue[])fieldValueArray2.clone();
        } else if (fieldValueArray2.length == 0) {
            fieldValueArray3 = (FieldValue[])fieldValueArray.clone();
        } else {
            fieldValueArray3[0] = fieldValueArray[0].add(fieldValueArray2[0]);
            fieldValueArray3[1] = fieldValueArray[1].add(fieldValueArray2[1]);
            if (fieldValueArray3[0].isZero()) {
                fieldValueArray3 = fieldValueArray3[1].isZero() ? BinaryECPoint.doubling(field, fieldValue, fieldValueArray2, fieldValueArray3) : new FieldValue[]{};
            } else {
                fieldValueArray3[1] = fieldValueArray3[1].multiply(fieldValueArray3[0].modInverse(field)).mod(field);
                fieldValueArray3[0] = fieldValueArray3[1].square().mod(field).add(fieldValueArray3[1]).add(fieldValueArray3[0]).add(fieldValue);
                fieldValueArray3[1] = fieldValueArray3[1].multiply(fieldValueArray2[0].add(fieldValueArray3[0])).mod(field).add(fieldValueArray2[1]).add(fieldValueArray3[0]);
            }
        }
        return fieldValueArray3;
    }

    int compressY() {
        if (this.x.isElementZero()) {
            return 0;
        }
        return this.y.divide(this.x).toBigInt().testBit(0) ? 1 : 0;
    }

    FieldElement decompressY(FieldElement fieldElement, int n) {
        int n2;
        if (fieldElement.isElementZero()) {
            return ECUtils.sqrt(this.curve.getB());
        }
        FieldElement fieldElement2 = fieldElement.add(this.curve.getA()).add(this.curve.getB().multiply(fieldElement.pow(2).inverse()));
        FieldElement fieldElement3 = ECUtils.solveBinaryQuadraticEqt(fieldElement2);
        if (fieldElement3 == null) {
            throw new IllegalArgumentException("Invalid input for ECPoint!");
        }
        int n3 = n2 = fieldElement3.toBigInt().testBit(0) ? 1 : 0;
        if (n2 != n) {
            fieldElement3 = fieldElement3.add(this.field.getElementOne());
        }
        return fieldElement.multiply(fieldElement3);
    }

    public ECPoint doubling() {
        if (this.equals(this.negate())) {
            return this.curve.getPointZero();
        }
        FieldValue[] fieldValueArray = BinaryECPoint.doubling(this.field, this.curve.getA().getFieldValue(), new FieldValue[]{this.x.getFieldValue(), this.y.getFieldValue()}, null);
        return new BinaryECPoint(this.curve, new FieldElement(this.field, fieldValueArray[0]), new FieldElement(this.field, fieldValueArray[1]));
    }

    private static FieldValue[] doubling(Field field, FieldValue fieldValue, FieldValue[] fieldValueArray, FieldValue[] fieldValueArray2) {
        if (fieldValueArray.length == 0 || fieldValueArray[0].isZero()) {
            fieldValueArray2 = new FieldValue[]{};
        } else {
            if (fieldValueArray2 == null || fieldValueArray2.length != 2) {
                fieldValueArray2 = new FieldValue[2];
            }
            FieldValue fieldValue2 = fieldValueArray[0];
            FieldValue fieldValue3 = fieldValueArray[1];
            fieldValueArray2[1] = fieldValue2.add(fieldValue3.multiply(fieldValue2.modInverse(field)).mod(field));
            fieldValueArray2[0] = fieldValueArray2[1].square().mod(field).add(fieldValueArray2[1]).add(fieldValue);
            fieldValueArray2[1] = fieldValueArray2[0].add(fieldValue2).multiply(fieldValueArray2[1]).mod(field).add(fieldValueArray2[0]).add(fieldValue3);
        }
        return fieldValueArray2;
    }

    public ECPoint multiply(BigInt bigInt) {
        if (this.isPointZero() || bigInt.signum() == 0) {
            return this.curve.getPointZero();
        }
        if (bigInt.signum() < 0) {
            return this.multiply(bigInt.negate()).negate();
        }
        FieldValue fieldValue = this.curve.getA().getFieldValue();
        FieldValue[] fieldValueArray = new FieldValue[]{};
        if (this.curve.equals(B_163_CURVE) && this.x.getFieldValue().equals(B163[1][0]) && this.y.getFieldValue().equals(B163[1][1])) {
            int n = 32;
            while (n >= 0) {
                fieldValueArray = BinaryECPoint.doubling(this.field, fieldValue, fieldValueArray, fieldValueArray);
                int n2 = (bigInt.testBit(n) ? 1 : 0) + (bigInt.testBit(33 + n) ? 2 : 0) + (bigInt.testBit(66 + n) ? 4 : 0) + (bigInt.testBit(99 + n) ? 8 : 0) + (bigInt.testBit(132 + n) ? 16 : 0);
                fieldValueArray = BinaryECPoint.add(this.field, fieldValue, fieldValueArray, B163[n2], fieldValueArray);
                --n;
            }
        } else {
            int[] nArray = ECUtils.computeWindowNAF(4, bigInt);
            FieldValue[][] fieldValueArray2 = new FieldValue[4][];
            fieldValueArray2[0] = new FieldValue[]{this.x.getFieldValue(), this.y.getFieldValue()};
            fieldValueArray = BinaryECPoint.doubling(this.field, fieldValue, fieldValueArray2[0], fieldValueArray);
            fieldValueArray2[1] = BinaryECPoint.add(this.field, fieldValue, fieldValueArray2[0], fieldValueArray, null);
            fieldValueArray2[2] = BinaryECPoint.add(this.field, fieldValue, fieldValueArray2[1], fieldValueArray, null);
            fieldValueArray2[3] = BinaryECPoint.add(this.field, fieldValue, fieldValueArray2[2], fieldValueArray, null);
            fieldValueArray = new FieldValue[]{};
            int n = nArray.length - 1;
            while (n >= 0) {
                fieldValueArray = BinaryECPoint.doubling(this.field, fieldValue, fieldValueArray, fieldValueArray);
                int n3 = nArray[n];
                if (n3 > 0) {
                    fieldValueArray = BinaryECPoint.add(this.field, fieldValue, fieldValueArray, fieldValueArray2[n3 - 1 >> 1], fieldValueArray);
                } else if (n3 < 0) {
                    fieldValueArray = BinaryECPoint.negate(BinaryECPoint.add(this.field, fieldValue, BinaryECPoint.negate(fieldValueArray, fieldValueArray), fieldValueArray2[-n3 - 1 >> 1], fieldValueArray), fieldValueArray);
                }
                --n;
            }
        }
        if (fieldValueArray.length == 0) {
            return this.curve.getPointZero();
        }
        return new BinaryECPoint(this.curve, new FieldElement(this.field, fieldValueArray[0]), new FieldElement(this.field, fieldValueArray[1]));
    }

    public ECPoint multiplyAndAdd(BigInt bigInt, ECPoint eCPoint, BigInt bigInt2) throws ECException {
        if (!this.curve.equals(eCPoint.getCurve())) {
            throw new ECException("The points are on different curves");
        }
        FieldValue fieldValue = this.curve.getA().getFieldValue();
        FieldValue[][][] fieldValueArray = new FieldValue[2][8][2];
        fieldValueArray[1] = BinaryECPoint.preComputeINME(this.field, fieldValue, eCPoint.x.getFieldValue(), eCPoint.y.getFieldValue(), 4);
        if (this.curve.equals(B_163_CURVE) && this.x.getFieldValue().equals(M163[0][0]) && this.y.getFieldValue().equals(M163[0][1])) {
            System.arraycopy(M163, 0, fieldValueArray[0], 0, 8);
        } else {
            fieldValueArray[0] = BinaryECPoint.preComputeINME(this.field, fieldValue, this.x.getFieldValue(), this.y.getFieldValue(), 4);
        }
        int[][] nArray = new int[][]{ECUtils.computeWindowNAF(5, bigInt), ECUtils.computeWindowNAF(5, bigInt2)};
        FieldValue[] fieldValueArray2 = new FieldValue[]{};
        int n = Math.max(nArray[0].length, nArray[1].length) - 1;
        while (n >= 0) {
            fieldValueArray2 = BinaryECPoint.doubling(this.field, fieldValue, fieldValueArray2, fieldValueArray2);
            int n2 = 1;
            while (n2 >= 0) {
                if (n < nArray[n2].length) {
                    int n3 = nArray[n2][n];
                    if (n3 > 0) {
                        fieldValueArray2 = BinaryECPoint.add(this.field, fieldValue, fieldValueArray2, fieldValueArray[n2][(n3 - 1) / 2], fieldValueArray2);
                    } else if (n3 < 0) {
                        fieldValueArray2 = BinaryECPoint.negate(BinaryECPoint.add(this.field, fieldValue, BinaryECPoint.negate(fieldValueArray2, fieldValueArray2), fieldValueArray[n2][(-n3 - 1) / 2], fieldValueArray2), fieldValueArray2);
                    }
                }
                --n2;
            }
            --n;
        }
        if (fieldValueArray2.length == 0) {
            return this.curve.getPointZero();
        }
        return new BinaryECPoint(this.curve, new FieldElement(this.field, fieldValueArray2[0]), new FieldElement(this.field, fieldValueArray2[1]));
    }

    public ECPoint negate() {
        if (this.isPointZero()) {
            return this.curve.getPointZero();
        }
        return new BinaryECPoint(this.curve, this.x, this.x.add(this.y));
    }

    private static FieldValue[] negate(FieldValue[] fieldValueArray, FieldValue[] fieldValueArray2) {
        if (fieldValueArray.length == 0) {
            fieldValueArray2 = new FieldValue[]{};
        } else if (fieldValueArray2 == null || fieldValueArray2.length != 2) {
            fieldValueArray2 = new FieldValue[]{fieldValueArray[0], fieldValueArray[0].add(fieldValueArray[1])};
        }
        return fieldValueArray2;
    }

    private static FieldValue[][] preComputeFBC(Field field, FieldValue fieldValue, FieldValue fieldValue2, FieldValue fieldValue3, int n) {
        int n2;
        int n3;
        int n4 = 1 << n;
        int n5 = (((BinaryField)field).getM() + n - 1) / n;
        FieldValue[][] fieldValueArray = new FieldValue[n4][];
        fieldValueArray[0] = new FieldValue[0];
        fieldValueArray[1] = new FieldValue[]{fieldValue2, fieldValue3};
        int n6 = 1;
        while (n6 < n) {
            n3 = 1 << n6;
            fieldValueArray[n3] = BinaryECPoint.doubling(field, fieldValue, fieldValueArray[n3 / 2], null);
            n2 = n5 - 1;
            while (n2 > 0) {
                fieldValueArray[n3] = BinaryECPoint.doubling(field, fieldValue, fieldValueArray[n3], fieldValueArray[n3]);
                --n2;
            }
            ++n6;
        }
        n3 = 3;
        while (n3 < n4) {
            if (fieldValueArray[n3] == null) {
                n2 = 1;
                int n7 = n - 1;
                while (n7 >= 0) {
                    int n8 = 1 << n7;
                    if ((n3 & n8) != 0) {
                        if (n2 != 0) {
                            fieldValueArray[n3] = (FieldValue[])fieldValueArray[n8].clone();
                            n2 = 0;
                        } else {
                            fieldValueArray[n3] = BinaryECPoint.add(field, fieldValue, fieldValueArray[n3], fieldValueArray[n8], fieldValueArray[n3]);
                        }
                    }
                    --n7;
                }
            }
            ++n3;
        }
        return fieldValueArray;
    }

    private static FieldValue[][] preComputeINME(Field field, FieldValue fieldValue, FieldValue fieldValue2, FieldValue fieldValue3, int n) {
        int n2 = 1 << n - 1;
        FieldValue[][] fieldValueArray = new FieldValue[n2][2];
        fieldValueArray[0][0] = fieldValue2;
        fieldValueArray[0][1] = fieldValue3;
        fieldValueArray[n2 - 1] = BinaryECPoint.add(field, fieldValue, fieldValueArray[0], fieldValueArray[0], fieldValueArray[n2 - 1]);
        int n3 = 1;
        while (n3 < n2) {
            fieldValueArray[n3] = BinaryECPoint.add(field, fieldValue, fieldValueArray[n2 - 1], fieldValueArray[n3 - 1], fieldValueArray[n3]);
            ++n3;
        }
        return fieldValueArray;
    }
}

