/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.math;

import com.phaos.crypto.RandomBitsSource;
import com.phaos.math.BinaryECPoint;
import com.phaos.math.BinaryField;
import com.phaos.math.ECPoint;
import com.phaos.math.ECUtils;
import com.phaos.math.EllipticCurve;
import com.phaos.math.FieldElement;

public class BinaryEllipticCurve
extends EllipticCurve {
    public ECPoint createBinaryECPoint(int[] nArray, int[] nArray2) {
        return new BinaryECPoint(this, nArray, nArray2);
    }

    public ECPoint createECPoint(FieldElement fieldElement, FieldElement fieldElement2) {
        if (!this.isPointOnCurve(fieldElement, fieldElement2)) {
            throw new IllegalArgumentException("x, y not define a point on this curve");
        }
        return new BinaryECPoint((EllipticCurve)this, fieldElement, fieldElement2);
    }

    public ECPoint createECPoint(byte[] byArray) {
        return new BinaryECPoint(this, byArray);
    }

    public ECPoint createRandomPoint() {
        FieldElement fieldElement = null;
        FieldElement fieldElement2 = null;
        while (fieldElement2 == null) {
            fieldElement = this.field.createFieldElement(RandomBitsSource.getDefault().randomBigInt(((BinaryField)this.field).getM()));
            if (fieldElement.isElementZero()) {
                return new BinaryECPoint((EllipticCurve)this, this.field.getElementZero(), ECUtils.sqrt(this.b));
            }
            FieldElement fieldElement3 = fieldElement.pow(3).add(this.a.multiply(fieldElement.pow(2))).add(this.b);
            if (fieldElement3.isElementZero()) {
                return new BinaryECPoint((EllipticCurve)this, fieldElement, this.field.getElementZero());
            }
            fieldElement2 = ECUtils.solveBinaryQuadraticEqt(fieldElement.pow(2).inverse().multiply(fieldElement3));
        }
        return new BinaryECPoint((EllipticCurve)this, fieldElement, fieldElement.multiply(fieldElement2));
    }

    public boolean isEllipticCurveVR() {
        if (this.seed == null) {
            throw new IllegalStateException("Seed value must be present for the verification.");
        }
        int n = ((BinaryField)this.field).getM();
        int n2 = (n - 1) / 160;
        FieldElement fieldElement = this.field.createFieldElement(ECUtils.computeR(this.seed, n2, n));
        return fieldElement.equals(this.b);
    }

    public boolean isNonsingular() {
        return this.b.isElementZero() ^ true;
    }

    public boolean isPointOnCurve(FieldElement fieldElement, FieldElement fieldElement2) {
        if (!this.field.equals(fieldElement.getField()) || !this.field.equals(fieldElement2.getField())) {
            return false;
        }
        return fieldElement2.pow(2).add(fieldElement.multiply(fieldElement2)).equals(fieldElement.pow(3).add(this.a.multiply(fieldElement.pow(2))).add(this.b));
    }
}

